/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.backend;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import lwjgl3.Lwjgl3ApplicationConfiguration;

public class GDXAppSettings {
    public String title;
    public int width = 1280;
    public int height = 720;
    public int x = -1;
    public int y = -1;
    public boolean fullscreen = false;
    public boolean useHDPI = true;
    public boolean vSyncEnabled = true;
    public int samples = 2;
    public boolean forceExit = false;
    public boolean resizable = true;
    public boolean useAudio = true;
    public int audioDeviceSimultaneousSources = 24;
    public int audioDeviceBufferSize = 512;
    public int audioDeviceBufferCount = 9;
    public Color initialBackgroundColor = Color.BLACK;
    public int foregroundFPS = 60;
    public int backgroundFPS = 60;
    @Deprecated
    public boolean pauseWhenMinimized = true;
    @Deprecated
    public boolean pauseWhenBackground = false;

    public Lwjgl3ApplicationConfiguration getLwjgl3Configuration() {
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setTitle(this.title);
        config.setWindowedMode(this.width, this.height);
        config.setWindowPosition(this.x, this.y);
        if (this.fullscreen) {
            config.setFullscreenMode(Lwjgl3ApplicationConfiguration.getDisplayMode());
        }
        if (this.useHDPI) {
            config.setHdpiMode(HdpiMode.Logical);
        }
        config.vSyncEnabled = this.vSyncEnabled;
        config.samples = this.samples;
        config.glEmulation = Lwjgl3ApplicationConfiguration.GLEmulation.GL20;
        config.setResizable(this.resizable);
        config.setAudioConfig(this.audioDeviceSimultaneousSources, this.audioDeviceBufferSize, this.audioDeviceBufferCount);
        config.setInitialBackgroundColor(this.initialBackgroundColor);
        config.setForegroundFPS(this.foregroundFPS);
        config.setIdleFPS(this.backgroundFPS);
        config.disableAudio(true);
        return config;
    }
}

