//  2DUniformShader.vsh
//  Vertex shader to that keeps a uniform color throughout 2D shape. 
//  Supports projection and modelview matrices.
//
//  Created by Walker White on 5/22/12.
//  Copyright (c) 2012 Cornell University. All rights reserved.

// Inputs values
attribute vec4 position; 

// Matrices
uniform vec4 color;
uniform mat4 projection;
uniform mat4 modelview;

void main(void) { 
	gl_Position = projection * modelview * position;
}