/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.g2d;

import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;

public class UniformShader
extends ShaderProgram {
    private int theColor = -1;
    private int projection = -1;
    private int modelview = -1;

    private UniformShader(InternalFileHandleResolver resolver) {
        super(resolver.resolve("shaders/2DUniformShader.vsh"), resolver.resolve("shaders/2DUniformShader.fsh"));
        if (!this.isCompiled()) {
            throw new RuntimeException("Shader compilation failed");
        }
    }

    public UniformShader() {
        this(new InternalFileHandleResolver());
        this.theColor = this.getUniformLocation("color");
        this.projection = this.getUniformLocation("projection");
        this.modelview = this.getUniformLocation("modelview");
    }

    public Mesh createMesh(int verts, int indices) {
        Mesh mesh = new Mesh(Mesh.VertexDataType.VertexArray, false, verts, indices, new VertexAttribute(1, 2, "position"));
        return mesh;
    }

    public void setColor(Color color) {
        float[] f = new float[]{color.r, color.g, color.b, color.a};
        this.setColor(f);
    }

    public void setColor(float[] color) {
        this.setUniform4fv(this.theColor, color, 0, color.length);
    }

    public void setProjection(Matrix4 matrix) {
        this.setUniformMatrix4fv(this.projection, matrix.val, 0, matrix.val.length);
    }

    public void setModelview(Matrix4 matrix) {
        this.setUniformMatrix4fv(this.modelview, matrix.val, 0, matrix.val.length);
    }
}

