/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.g2d;

import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;

public class ColorShader
extends ShaderProgram {
    private int projection = -1;
    private int modelview = -1;

    private ColorShader(InternalFileHandleResolver resolver) {
        super(resolver.resolve("shaders/2DColorShader.vsh"), resolver.resolve("shaders/2DColorShader.fsh"));
        if (!this.isCompiled()) {
            throw new RuntimeException("Shader compilation failed");
        }
    }

    public ColorShader() {
        this(new InternalFileHandleResolver());
        this.projection = this.getUniformLocation("projection");
        this.modelview = this.getUniformLocation("modelview");
    }

    public Mesh createMesh(int verts, int indices) {
        Mesh mesh = new Mesh(Mesh.VertexDataType.VertexArray, false, verts, indices, new VertexAttribute(1, 2, "position"), new VertexAttribute(4, 4, "sourceColor"));
        return mesh;
    }

    public void setProjection(Matrix4 matrix) {
        this.setUniformMatrix4fv(this.projection, matrix.val, 0, matrix.val.length);
    }

    public void setModelview(Matrix4 matrix) {
        this.setUniformMatrix4fv(this.modelview, matrix.val, 0, matrix.val.length);
    }
}

