/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.bezier;

import com.badlogic.gdx.math.Vector2;
import edu.cornell.gdiac.bezier.RootSolver;
import java.nio.FloatBuffer;

public class Spline {
    public static final int CRITERION_FLAT = 0;
    public static final int CRITERION_DISTANCE = 1;
    public static final int CRITERION_SPACING = 2;
    private static final int MAX_DEPTH = 8;
    protected int size = 0;
    protected float[] points;
    protected boolean[] smooth;
    private int maxs = 1;
    private static Vector2 temp0 = new Vector2();
    private static Vector2 temp1 = new Vector2();
    private static float SMOOTH_EPSILON = 1.0E-4f;
    private static boolean crossing = false;
    private static final int BUFFER_EMPTY = 0;
    private static final int BUFFER_POINTS = 1;
    private static final int BUFFER_VERTICES = 2;
    private static final int BUFFER_PARAMETERS = 3;
    private static final int BUFFER_TANGENTS = 4;
    private static final int BUFFER_NORMALS = 5;
    private static final int BUFFER_SHADOW = 6;
    private static final int BUFFER_PENUMBRA = 7;

    public Spline() {
        this(0.0f, 0.0f);
    }

    public Spline(float x, float y) {
        this(x, y, x, y);
        this.size = 0;
    }

    public Spline(float x0, float y0, float x1, float y1) {
        this.points = new float[8];
        this.smooth = new boolean[2];
        this.smooth[0] = true;
        this.smooth[1] = true;
        this.points[0] = x0;
        this.points[1] = y0;
        this.points[2] = x0;
        this.points[3] = y0;
        this.points[4] = x1;
        this.points[5] = y1;
        this.points[6] = x1;
        this.points[7] = y1;
        this.size = 1;
    }

    public int getSize() {
        return this.size;
    }

    public Spline(float[] points, int offset, int length) {
        if (length - 2 == 0) {
            throw new IllegalArgumentException();
        }
        this.maxs = this.size = (length - 2) / 6;
        this.points = new float[length];
        this.smooth = new boolean[this.size + 1];
        System.arraycopy(points, offset, this.points, 0, length);
        this.smooth[0] = true;
        this.smooth[this.size] = true;
        for (int ii = 1; ii < this.size; ++ii) {
            temp0.set(this.points[6 * ii - 2] - this.points[6 * ii], this.points[6 * ii - 1] - this.points[6 * ii + 1]);
            temp1.set(this.points[6 * ii + 2] - this.points[6 * ii], this.points[6 * ii + 3] - this.points[6 * ii + 1]);
            temp0.nor();
            temp1.nor();
            temp0.sub(temp1);
            this.smooth[ii] = temp0.len2() < SMOOTH_EPSILON;
        }
    }

    public Spline(Spline spline) {
        this.size = spline.size;
        this.maxs = spline.maxs;
        this.points = new float[spline.points.length];
        this.smooth = new boolean[spline.smooth.length];
        System.arraycopy(spline.points, 0, this.points, 0, this.points.length);
        System.arraycopy(spline.smooth, 0, this.smooth, 0, this.smooth.length);
    }

    private void expand() {
        float[] npoints = new float[this.points.length * 2];
        boolean[] nsmooth = new boolean[this.smooth.length * 2];
        System.arraycopy(this.points, 0, npoints, 0, this.points.length);
        System.arraycopy(this.smooth, 0, nsmooth, 0, this.smooth.length);
        this.points = npoints;
        this.smooth = nsmooth;
        this.maxs *= 2;
    }

    public boolean getSmooth(int index) {
        return this.smooth[index];
    }

    public void setSmooth(int index, boolean flag) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.smooth[index] = flag;
        if (flag && index > 0 && index < this.size) {
            Vector2 left = new Vector2();
            Vector2 right = new Vector2();
            temp0.set(this.points[6 * index - 2] - this.points[6 * index], this.points[6 * index - 1] - this.points[6 * index + 1]);
            temp1.set(this.points[6 * index] - this.points[6 * index + 2], this.points[6 * index + 1] - this.points[6 * index + 3]);
            temp0.nor();
            temp1.nor();
            temp0.lerp(temp1, 0.5f);
            temp0.nor();
            temp1.set(this.points[6 * index - 2] - this.points[6 * index], this.points[6 * index - 1] - this.points[6 * index + 1]);
            temp0.scl(temp1.len());
            this.points[6 * index - 2] = this.points[6 * index] + Spline.temp0.x;
            this.points[6 * index - 1] = this.points[6 * index + 1] + Spline.temp0.y;
            this.points[6 * index + 2] = this.points[6 * index] - Spline.temp0.x;
            this.points[6 * index + 3] = this.points[6 * index + 1] - Spline.temp0.y;
        }
    }

    public float[] getControlPoints() {
        return this.points;
    }

    public int addAnchor(float px, float py) {
        return this.addAnchor(px, py, px, py);
    }

    public int addAnchor(float px, float py, float tx, float ty) {
        int pos;
        if (this.size == this.maxs) {
            this.expand();
        }
        if ((pos = 6 * this.size + 2) > 2 && this.smooth[this.size]) {
            this.points[pos] = 2.0f * this.points[pos - 2] - this.points[pos - 4];
            this.points[pos + 1] = 2.0f * this.points[pos - 1] - this.points[pos - 3];
        } else {
            this.points[pos] = this.points[0];
            this.points[pos + 1] = this.points[1];
        }
        this.points[pos + 2] = tx;
        this.points[pos + 3] = ty;
        this.points[pos + 4] = px;
        this.points[pos + 5] = py;
        ++this.size;
        this.smooth[this.size] = true;
        return this.size;
    }

    public void deleteAnchor(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.points, 6 * (index + 1), this.points, 6 * index, 6 * this.size - 4);
        System.arraycopy(this.smooth, index + 1, this.smooth, index, this.size);
        --this.size;
    }

    public void insertAnchor(float param) {
        int segment = (int)param;
        this.insertAnchor(segment, param - (float)segment);
    }

    private void insertAnchor(int segment, float param) {
        if (segment < 0 || segment >= this.size) {
            throw new IllegalArgumentException();
        }
        if (param <= 0.0f || param >= 1.0f) {
            throw new IllegalArgumentException();
        }
        if (this.size == this.maxs) {
            this.expand();
        }
        float[] insert = new float[10];
        float hx = (1.0f - param) * this.points[6 * segment + 2] + param * this.points[6 * segment + 4];
        float hy = (1.0f - param) * this.points[6 * segment + 3] + param * this.points[6 * segment + 5];
        insert[0] = (1.0f - param) * this.points[6 * segment] + param * this.points[6 * segment + 2];
        insert[1] = (1.0f - param) * this.points[6 * segment + 1] + param * this.points[6 * segment + 3];
        insert[2] = (1.0f - param) * insert[0] + param * hx;
        insert[3] = (1.0f - param) * insert[1] + param * hy;
        insert[8] = (1.0f - param) * this.points[6 * segment + 4] + param * this.points[6 * segment + 6];
        insert[9] = (1.0f - param) * this.points[6 * segment + 5] + param * this.points[6 * segment + 7];
        insert[6] = (1.0f - param) * hx + param * insert[8];
        insert[7] = (1.0f - param) * hy + param * insert[9];
        insert[4] = (1.0f - param) * insert[2] + param * insert[6];
        insert[5] = (1.0f - param) * insert[3] + param * insert[7];
        System.arraycopy(this.points, 6 * (segment + 1), this.points, 6 * (segment + 2), 6 * (this.size - segment - 1) + 2);
        if (segment + 1 < this.size) {
            System.arraycopy(this.smooth, segment + 1, this.smooth, segment + 2, this.size - segment - 1);
        }
        this.smooth[segment + 1] = true;
        for (int ii = 0; ii < insert.length; ++ii) {
            this.points[6 * segment + 2 + ii] = insert[ii];
        }
        ++this.size;
    }

    public int nearestAnchor(float px, float py, float threshold) {
        float best = Float.POSITIVE_INFINITY;
        int index = -1;
        Vector2 temp = new Vector2();
        for (int ii = 0; ii <= this.size; ++ii) {
            temp0.set(this.points[6 * ii] - px, this.points[6 * ii + 1] - py);
            float d = temp0.len2();
            if (!(d < threshold) || !(d < best)) continue;
            best = d;
            index = ii;
        }
        return index;
    }

    public int nearestTangent(float px, float py, float threshold) {
        float best = Float.POSITIVE_INFINITY;
        int index = -1;
        Vector2 temp = new Vector2();
        for (int ii = 0; ii < this.size; ++ii) {
            temp0.set(this.points[6 * ii + 2] - px, this.points[6 * ii + 3] - py);
            float d = temp0.len2();
            if (d < threshold && d < best) {
                best = d;
                index = 2 * ii + 1;
            }
            temp0.set(this.points[6 * ii + 4] - px, this.points[6 * ii + 5] - py);
            d = temp0.len2();
            if (!(d < threshold) || !(d < best)) continue;
            best = d;
            index = 2 * ii + 2;
        }
        return index;
    }

    public void setAnchor(int index, float px, float py) {
        float dx = px - this.points[6 * index];
        float dy = py - this.points[6 * index + 1];
        if (index > 0) {
            this.points[6 * index - 2] = this.points[6 * index - 2] + dx;
            this.points[6 * index - 1] = this.points[6 * index - 1] + dy;
        }
        if (index < this.size) {
            this.points[6 * index + 2] = this.points[6 * index + 2] + dx;
            this.points[6 * index + 3] = this.points[6 * index + 3] + dy;
        }
        this.points[6 * index] = px;
        this.points[6 * index + 1] = py;
    }

    public void setTangent(int index, float tx, float ty, boolean symmetric) {
        int tangt2;
        int spline = index / 2;
        int anchor = 6 * spline;
        int tangt1 = index % 2 == 0 ? anchor - 2 : anchor + 2;
        int n = tangt2 = index % 2 == 0 ? anchor + 2 : anchor - 2;
        if (spline == 0 || spline == this.size) {
            tangt2 = -1;
        }
        if (symmetric && tangt2 != -1) {
            temp0.set(this.points[anchor] - tx, this.points[anchor + 1] - ty);
            this.points[tangt2] = this.points[anchor] + Spline.temp0.x;
            this.points[tangt2 + 1] = this.points[anchor + 1] + Spline.temp0.y;
        } else if (this.smooth[spline] && tangt2 != -1) {
            temp0.set(this.points[anchor] - this.points[tangt2], this.points[anchor + 1] - this.points[tangt2 + 1]);
            float d = temp0.len();
            temp0.set(this.points[anchor] - tx, this.points[anchor + 1] - ty);
            temp0.nor();
            temp0.scl(d);
            this.points[tangt2] = this.points[anchor] + Spline.temp0.x;
            this.points[tangt2 + 1] = this.points[anchor + 1] + Spline.temp0.y;
        }
        this.points[tangt1] = tx;
        this.points[tangt1 + 1] = ty;
    }

    public void getPoint(float tp, float[] result, int offset) {
        int segment = (int)tp;
        this.getPoint(tp - (float)segment, segment, result, offset);
    }

    private void getPoint(float tp, int segment, float[] result, int offset) {
        if (segment == this.size) {
            result[offset] = this.points[6 * segment];
            result[offset + 1] = this.points[6 * segment + 1];
            return;
        }
        int index = 6 * segment;
        float sp = 1.0f - tp;
        float a = sp * sp;
        float d = tp * tp;
        float b = 3.0f * tp * a;
        float c = 3.0f * sp * d;
        result[offset] = (a *= sp) * this.points[index] + b * this.points[index + 2] + c * this.points[index + 4] + (d *= tp) * this.points[index + 6];
        result[offset + 1] = a * this.points[index + 1] + b * this.points[index + 3] + c * this.points[index + 5] + d * this.points[index + 7];
    }

    private void getProjectionPoly(float x, float y, int segment, float[] result, int offset) {
        int index = 6 * segment;
        Vector2 a = new Vector2(this.points[6 * segment + 6] - 3.0f * this.points[6 * segment + 4] + 3.0f * this.points[6 * segment + 2] - this.points[6 * segment], this.points[6 * segment + 7] - 3.0f * this.points[6 * segment + 5] + 3.0f * this.points[6 * segment + 3] - this.points[6 * segment + 1]);
        Vector2 b = new Vector2(3.0f * this.points[6 * segment + 4] - 6.0f * this.points[6 * segment + 2] + 3.0f * this.points[6 * segment], 3.0f * this.points[6 * segment + 5] - 6.0f * this.points[6 * segment + 3] + 3.0f * this.points[6 * segment + 1]);
        Vector2 c = new Vector2(3.0f * (this.points[6 * segment + 2] - this.points[6 * segment]), 3.0f * (this.points[6 * segment + 3] - this.points[6 * segment + 1]));
        Vector2 p = new Vector2(this.points[6 * segment] - x, this.points[6 * segment + 1] - y);
        float norm = 3.0f * a.dot(a);
        result[offset] = 5.0f * a.dot(b) / norm;
        result[offset + 1] = (4.0f * a.dot(c) + 2.0f * b.dot(b)) / norm;
        result[offset + 2] = (3.0f * b.dot(c) + 3.0f * a.dot(p)) / norm;
        result[offset + 3] = (c.dot(c) + 2.0f * b.dot(p)) / norm;
        result[offset + 4] = c.dot(p) / norm;
    }

    public float getProjection(float x, float y) {
        float tmin = -1.0f;
        float dmin = -1.0f;
        int smin = -1;
        int RESOLUTION = 256;
        float[] compare = new float[4];
        for (int ii = 0; ii < this.size; ++ii) {
            for (int jj = 0; jj < RESOLUTION; ++jj) {
                float t = (float)jj / (float)RESOLUTION;
                this.getPoint(t, ii, compare, 0);
                temp0.set(compare[0] - x, compare[1] - y);
                float d = temp0.len2();
                if (smin != -1 && !(d < dmin)) continue;
                tmin = t;
                dmin = d;
                smin = ii;
            }
        }
        temp0.set(this.points[6 * this.size] - x, this.points[6 * this.size + 1] - y);
        float d = temp0.len2();
        if (d < dmin) {
            tmin = 1.0f;
            dmin = d;
            smin = this.size - 1;
        }
        return (float)smin + tmin;
    }

    private float getProjection2(float x, float y) {
        float tmin = -1.0f;
        float dmin = -1.0f;
        int smin = -1;
        float[] result = new float[2];
        for (int ii = 0; ii < this.size; ++ii) {
            this.getProjection2(x, y, ii, result, 0);
            if (smin != -1 && !(result[1] < dmin)) continue;
            tmin = result[0];
            dmin = result[1];
            smin = ii;
        }
        return (float)smin + tmin;
    }

    private void getProjection2(float x, float y, int segment, float[] result, int offset) {
        float[] poly = new float[5];
        float[] roots = new float[5];
        this.getProjectionPoly(x, y, segment, poly, 0);
        float epsilon = 0.001953125f;
        RootSolver.solveRoots(poly, 0, 5, roots, 0, epsilon);
        float tmin = 0.0f;
        float[] compare = new float[2];
        this.getPoint(0.0f, segment, compare, 0);
        temp0.set(compare[0] - x, compare[1] - y);
        float dmin = temp0.len2();
        float t = 1.0f;
        this.getPoint(1.0f, segment, compare, 0);
        temp0.set(compare[0] - x, compare[1] - y);
        float d = temp0.len2();
        if (d < dmin) {
            tmin = t;
            dmin = d;
        }
        int RESOLUTION = 256;
        for (int ii = 0; ii < 5; ++ii) {
            if (Float.isNaN(roots[ii]) || !(roots[ii] > 0.0f) || !(roots[ii] < 1.0f)) continue;
            t = roots[ii] * (float)RESOLUTION;
            t = Math.round(t);
            this.getPoint(t /= (float)RESOLUTION, segment, compare, 0);
            temp0.set(compare[0] - x, compare[1] - y);
            d = temp0.len2();
            if (!(d < dmin)) continue;
            tmin = t;
            dmin = d;
        }
        result[offset] = tmin;
        result[offset + 1] = dmin;
    }

    public void subdivide(int segment, float[] left, int loffset, float[] rght, int roffset) {
        Spline.subdivide(this.points, 6 * segment, left, loffset, rght, roffset);
    }

    public static void subdivide(float[] src, int soffset, float[] left, int loffset, float[] rght, int roffset) {
        float alpha = 0.5f;
        float hx = (1.0f - alpha) * src[soffset + 2] + alpha * src[soffset + 4];
        float hy = (1.0f - alpha) * src[soffset + 3] + alpha * src[soffset + 5];
        left[loffset] = src[soffset];
        left[loffset + 1] = src[soffset + 1];
        left[loffset + 2] = (1.0f - alpha) * src[soffset] + alpha * src[soffset + 2];
        left[loffset + 3] = (1.0f - alpha) * src[soffset + 1] + alpha * src[soffset + 3];
        left[loffset + 4] = (1.0f - alpha) * left[loffset + 2] + alpha * hx;
        left[loffset + 5] = (1.0f - alpha) * left[loffset + 3] + alpha * hy;
        rght[roffset + 7] = src[soffset + 7];
        rght[roffset + 6] = src[soffset + 6];
        rght[roffset + 5] = (1.0f - alpha) * src[soffset + 5] + alpha * src[soffset + 7];
        rght[roffset + 4] = (1.0f - alpha) * src[soffset + 4] + alpha * src[soffset + 6];
        rght[roffset + 3] = (1.0f - alpha) * hy + alpha * rght[roffset + 5];
        rght[roffset + 2] = (1.0f - alpha) * hx + alpha * rght[roffset + 4];
        rght[roffset + 1] = (1.0f - alpha) * left[loffset + 5] + alpha * rght[roffset + 3];
        rght[roffset] = (1.0f - alpha) * left[loffset + 4] + alpha * rght[roffset + 2];
        left[loffset + 6] = rght[roffset];
        left[loffset + 7] = rght[roffset + 1];
    }

    public int countPoints() {
        return this.countPoints(0.25f, 1);
    }

    public int countPoints(float tolerance) {
        return this.countPoints(tolerance, 1);
    }

    public int countPoints(float tolerance, int criterion) {
        int result = 0;
        for (int ii = 0; ii <= this.size; ++ii) {
            result += this.processBuffer(this.points, 6 * ii, ii, null, 0, null, tolerance, criterion, 0);
        }
        return result;
    }

    public int generatePoints(FloatBuffer buffer) {
        return this.generatePoints(buffer, 0.25f, 1);
    }

    public int generatePoints(FloatBuffer buffer, float tolerance) {
        return this.generatePoints(buffer, tolerance, 1);
    }

    public int generatePoints(FloatBuffer buffer, float tolerance, int criterion) {
        int result = 0;
        for (int ii = 0; ii <= this.size; ++ii) {
            result += this.processBuffer(this.points, 6 * ii, ii, buffer, 1, null, tolerance, criterion, 0);
        }
        buffer.position(0);
        return result;
    }

    public int generateVertices(FloatBuffer buffer, float width) {
        return this.generateVertices(buffer, width, 0.25f, 1);
    }

    public int generateVertices(FloatBuffer buffer, float width, float tolerance) {
        return this.generateVertices(buffer, width, tolerance, 1);
    }

    public int generateVertices(FloatBuffer buffer, float width, float tolerance, int criterion) {
        int result = 0;
        float[] param = new float[]{width};
        for (int ii = 0; ii < this.size; ++ii) {
            result += this.processBuffer(this.points, 6 * ii, ii, buffer, 2, param, tolerance, criterion, 0);
        }
        int offset = 6 * this.size;
        temp0.set(this.points[offset] - this.points[offset - 2], this.points[offset + 1] - this.points[offset - 1]);
        temp0.set(-Spline.temp0.y, Spline.temp0.x);
        temp0.nor();
        temp0.scl(width / 2.0f);
        buffer.put(this.points[offset] + Spline.temp0.x);
        buffer.put(this.points[offset + 1] + Spline.temp0.y);
        buffer.put(this.points[offset] - Spline.temp0.x);
        buffer.put(this.points[offset + 1] - Spline.temp0.y);
        buffer.position(0);
        return result + 2;
    }

    public int generateParameters(FloatBuffer buffer) {
        return this.generateParameters(buffer, 0.25f, 1);
    }

    public int generateParameters(FloatBuffer buffer, float tolerance) {
        return this.generateParameters(buffer, tolerance, 1);
    }

    public int generateParameters(FloatBuffer buffer, float tolerance, int criterion) {
        int result = 0;
        for (int ii = 0; ii <= this.size; ++ii) {
            result += this.processBuffer(this.points, 6 * ii, ii, buffer, 2, null, tolerance, criterion, 0);
        }
        buffer.position(0);
        return result;
    }

    public int generateTangents(FloatBuffer buffer) {
        return this.generateTangents(buffer, 0.25f, 1);
    }

    public int generateTangents(FloatBuffer buffer, float tolerance) {
        return this.generateTangents(buffer, tolerance, 1);
    }

    public int generateTangents(FloatBuffer buffer, float tolerance, int criterion) {
        int result = 0;
        for (int ii = 0; ii < this.size; ++ii) {
            result += this.processBuffer(this.points, 6 * ii, ii, buffer, 4, null, tolerance, criterion, 0);
        }
        int offset = 6 * this.size;
        buffer.put(3.0f * (this.points[offset] - this.points[offset - 2]));
        buffer.put(3.0f * (this.points[offset + 1] - this.points[offset - 1]));
        buffer.position(0);
        return result + 1;
    }

    public int generateNormals(FloatBuffer buffer, float length) {
        return this.generateNormals(buffer, length, 0.25f, 1);
    }

    public int generateNormals(FloatBuffer buffer, float length, float tolerance) {
        return this.generateNormals(buffer, length, tolerance, 1);
    }

    public int generateNormals(FloatBuffer buffer, float length, float tolerance, int criterion) {
        int result = 0;
        float[] param = new float[]{length};
        for (int ii = 0; ii < this.size; ++ii) {
            result += this.processBuffer(this.points, 6 * ii, ii, buffer, 5, param, tolerance, criterion, 0);
        }
        int offset = 6 * this.size;
        temp0.set(this.points[offset] - this.points[offset - 2], this.points[offset + 1] - this.points[offset - 1]);
        temp0.set(-Spline.temp0.y, Spline.temp0.x);
        temp0.nor();
        temp0.scl(length);
        buffer.put(this.points[offset]);
        buffer.put(this.points[offset + 1]);
        buffer.put(this.points[offset] + Spline.temp0.x);
        buffer.put(this.points[offset + 1] + Spline.temp0.y);
        buffer.position(0);
        return result + 2;
    }

    public int generateShadow(FloatBuffer buffer, float x, float y, float infinity) {
        return this.generateShadow(buffer, x, y, infinity, 0.25f, 1);
    }

    public int generateShadow(FloatBuffer buffer, float x, float y, float infinity, float tolerance) {
        return this.generateShadow(buffer, x, y, infinity, tolerance, 1);
    }

    public int generateShadow(FloatBuffer buffer, float x, float y, float infinity, float tolerance, int criterion) {
        int result = 0;
        crossing = false;
        float[] param = new float[4];
        param[0] = x;
        param[1] = y;
        param[2] = infinity;
        for (int ii = 0; ii < this.size; ++ii) {
            result += this.processBuffer(this.points, 6 * ii, ii, buffer, 6, param, tolerance, criterion, 0);
        }
        int offset = 6 * this.size;
        temp0.set(this.points[offset] - x, this.points[offset + 1] - y);
        temp0.nor();
        temp0.scl(infinity);
        buffer.put(this.points[offset]);
        buffer.put(this.points[offset + 1]);
        buffer.put(this.points[offset] + Spline.temp0.x);
        buffer.put(this.points[offset + 1] + Spline.temp0.y);
        buffer.position(0);
        return result + 2;
    }

    public int generatePenumbra(FloatBuffer buffer, float x, float y, float width, float infinity) {
        return this.generatePenumbra(buffer, x, y, width, infinity, 0.25f, 1);
    }

    public int generatePenumbra(FloatBuffer buffer, float x, float y, float width, float infinity, float tolerance) {
        return this.generatePenumbra(buffer, x, y, width, infinity, tolerance, 1);
    }

    public int generatePenumbra(FloatBuffer buffer, float x, float y, float width, float infinity, float tolerance, int criterion) {
        int result = 0;
        float[] param = new float[]{x, y, width, infinity};
        for (int ii = 0; ii < this.size; ++ii) {
            result += this.processBuffer(this.points, 6 * ii, 0.0f, buffer, 7, param, tolerance, criterion, 0);
        }
        int offset = 6 * this.size;
        temp0.set(this.points[offset] - x, this.points[offset + 1] - y);
        temp1.set(Spline.temp0.y, -Spline.temp0.x);
        temp1.nor();
        temp1.scl(width);
        temp0.add(temp1);
        temp0.nor();
        temp0.scl(infinity);
        buffer.put(this.points[offset]);
        buffer.put(this.points[offset + 1]);
        buffer.put(this.points[offset] + Spline.temp0.x);
        buffer.put(this.points[offset + 1] + Spline.temp0.y);
        temp0.set(this.points[offset] - x, this.points[offset + 1] - y);
        temp0.sub(temp1);
        temp0.nor();
        temp0.scl(infinity);
        buffer.put(this.points[offset] + Spline.temp0.x);
        buffer.put(this.points[offset + 1] + Spline.temp0.y);
        buffer.position(0);
        return result + 3;
    }

    private int processBuffer(float[] anchors, int offset, float tp, FloatBuffer buffer, int bufferType, float[] params, float tolerance, int criterion, int depth) {
        boolean terminate;
        boolean bl = terminate = depth >= 8 || offset >= 6 * this.size;
        if (!terminate && criterion == 2) {
            temp0.set(anchors[offset + 6] - anchors[offset], anchors[offset + 7] - anchors[offset + 1]);
            terminate = temp0.len() < tolerance;
        } else if (!(terminate || criterion != 1 && criterion != 0)) {
            float leng = 1.0f;
            if (criterion == 0) {
                temp0.set(anchors[offset + 6] - anchors[offset], anchors[offset + 7] - anchors[offset + 1]);
                leng = temp0.len();
            }
            temp0.set(anchors[offset + 6] - anchors[offset], anchors[offset + 7] - anchors[offset + 1]);
            temp1.set(anchors[offset + 2] - anchors[offset], anchors[offset + 3] - anchors[offset + 1]);
            temp1.nor();
            float scale = temp0.dot(temp1);
            temp1.scl(scale);
            temp0.sub(temp1);
            terminate = temp0.len() < tolerance * leng;
            temp0.set(anchors[offset + 0] - anchors[offset + 6], anchors[offset + 1] - anchors[offset + 7]);
            temp1.set(anchors[offset + 4] - anchors[offset + 6], anchors[offset + 5] - anchors[offset + 7]);
            temp1.nor();
            scale = temp0.dot(temp1);
            temp1.scl(scale);
            temp0.sub(temp1);
            terminate = terminate && temp0.len() < tolerance * leng;
        }
        int result = 0;
        if (terminate) {
            switch (bufferType) {
                case 1: {
                    buffer.put(anchors, offset, 2);
                    return 1;
                }
                case 2: {
                    temp0.set(anchors[offset + 2] - anchors[offset], anchors[offset + 3] - anchors[offset + 1]);
                    temp0.nor();
                    temp0.set(-Spline.temp0.y, Spline.temp0.x);
                    temp0.scl(params[0] / 2.0f);
                    buffer.put(anchors[offset] + Spline.temp0.x);
                    buffer.put(anchors[offset + 1] + Spline.temp0.y);
                    buffer.put(anchors[offset] - Spline.temp0.x);
                    buffer.put(anchors[offset + 1] - Spline.temp0.y);
                    return 2;
                }
                case 3: {
                    buffer.put(tp);
                    return 1;
                }
                case 4: {
                    buffer.put(3.0f * (anchors[offset + 2] - anchors[offset]));
                    buffer.put(3.0f * (anchors[offset + 3] - anchors[offset + 1]));
                    return 1;
                }
                case 5: {
                    temp0.set(anchors[offset + 2] - anchors[offset], anchors[offset + 3] - anchors[offset + 1]);
                    temp0.set(-Spline.temp0.y, Spline.temp0.x);
                    temp0.nor();
                    temp0.scl(params[0]);
                    buffer.put(anchors[offset]);
                    buffer.put(anchors[offset + 1]);
                    buffer.put(anchors[offset] + Spline.temp0.x);
                    buffer.put(anchors[offset + 1] + Spline.temp0.y);
                    return 2;
                }
                case 6: {
                    temp0.set(anchors[offset] - params[0], anchors[offset + 1] - params[1]);
                    temp0.nor();
                    temp0.scl(params[2]);
                    buffer.put(anchors[offset]);
                    buffer.put(anchors[offset + 1]);
                    buffer.put(anchors[offset] + Spline.temp0.x);
                    buffer.put(anchors[offset + 1] + Spline.temp0.y);
                    return 2;
                }
                case 7: {
                    temp0.set(anchors[offset] - params[0], anchors[offset + 1] - params[1]);
                    temp1.set(Spline.temp0.y, -Spline.temp0.x);
                    temp1.nor();
                    temp1.scl(params[2]);
                    temp0.add(temp1);
                    temp0.nor();
                    temp0.scl(params[3]);
                    buffer.put(anchors[offset]);
                    buffer.put(anchors[offset + 1]);
                    buffer.put(anchors[offset] + Spline.temp0.x);
                    buffer.put(anchors[offset + 1] + Spline.temp0.y);
                    temp0.set(anchors[offset] - params[0], anchors[offset + 1] - params[1]);
                    temp0.sub(temp1);
                    temp0.nor();
                    temp0.scl(params[3]);
                    buffer.put(anchors[offset] + Spline.temp0.x);
                    buffer.put(anchors[offset + 1] + Spline.temp0.y);
                    return 3;
                }
            }
            return 1;
        }
        int SPLINE_LENGTH = 8;
        float[] left = new float[SPLINE_LENGTH];
        float[] rght = new float[SPLINE_LENGTH];
        Spline.subdivide(anchors, offset, left, 0, rght, 0);
        float sp = tp + 1.0f / (float)(1 << depth + 1);
        result = this.processBuffer(left, 0, tp, buffer, bufferType, params, tolerance, criterion, depth + 1);
        return result += this.processBuffer(rght, 0, sp, buffer, bufferType, params, tolerance, criterion, depth + 1);
    }

    private boolean inSegment(float x, float y, int segment) {
        int offset = 6 * segment;
        float xmin = this.points[offset];
        float xmax = this.points[offset];
        float ymin = this.points[offset + 1];
        float ymax = this.points[offset + 1];
        for (int ii = 2; ii < 8; ii += 2) {
            float f = this.points[offset + ii];
            if (f < xmin) {
                xmin = f;
            } else if (f > xmax) {
                xmax = f;
            }
            f = this.points[offset + ii + 1];
            if (f < ymin) {
                ymin = f;
                continue;
            }
            if (!(f > ymax)) continue;
            ymax = f;
        }
        return x >= xmin && x <= xmax && y >= ymin && y <= ymax;
    }
}

