/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.bezier;

import com.badlogic.gdx.math.Vector2;
import java.nio.FloatBuffer;

public class BezierBuffer {
    public static final int CRITERION_FLAT = 0;
    public static final int CRITERION_DISTANCE = 1;
    public static final int CRITERION_SPACING = 2;
    private static final float PARALLEL_TRESHOLD = 0.1f;
    private float tolerance = 0.1f;
    private int criterion = 1;
    private int depth = 8;
    private int size = 0;
    private float[] points;
    private float[] tangts;
    private float[] params;
    private static Vector2 vect0 = new Vector2();
    private static Vector2 vect1 = new Vector2();
    private static Vector2 norm0 = new Vector2();
    private static Vector2 norm1 = new Vector2();

    public float getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(float value) {
        this.tolerance = value;
    }

    public int getCriterion() {
        return this.criterion;
    }

    public void setCriterion(int value) {
        this.criterion = value;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int value) {
        this.depth = value;
    }

    public int getSize() {
        return this.size;
    }

    public BezierBuffer(int depth) {
        this.depth = depth;
        int buffsize = 1 << depth + 1;
        this.points = new float[2 * buffsize];
        this.tangts = new float[2 * buffsize];
        this.params = new float[buffsize];
        this.size = 0;
    }

    public BezierBuffer() {
        this(8);
    }

    public void set(float[] anchors, int offset) {
        this.size = 0;
        this.add(anchors, offset);
    }

    public void add(float[] anchors, int offset) {
        float[] temp = new float[8];
        System.arraycopy(anchors, offset, temp, 0, 8);
        this.process(temp, 0, 0.0f);
        this.points[2 * this.size] = anchors[6 + offset];
        this.points[2 * this.size + 1] = anchors[7 + offset];
        this.tangts[2 * this.size] = 3.0f * (anchors[6 + offset] - anchors[4 + offset]);
        this.tangts[2 * this.size + 1] = 3.0f * (anchors[7 + offset] - anchors[5 + offset]);
        this.params[this.size] = 1.0f;
        ++this.size;
    }

    public void clear() {
        this.size = 0;
    }

    private void process(float[] anchors, int depth, float tp) {
        boolean terminate;
        boolean bl = terminate = depth >= 8;
        if (!terminate && this.criterion == 2) {
            vect0.set(anchors[6] - anchors[0], anchors[7] - anchors[1]);
            terminate = vect0.len() < this.tolerance;
        } else if (!(terminate || this.criterion != 1 && this.criterion != 0)) {
            float leng = 1.0f;
            if (this.criterion == 0) {
                vect0.set(anchors[6] - anchors[0], anchors[7] - anchors[1]);
                leng = vect0.len();
            }
            vect0.set(anchors[6] - anchors[0], anchors[7] - anchors[1]);
            norm0.set(anchors[2] - anchors[0], anchors[3] - anchors[1]);
            norm0.nor();
            float scale = vect0.dot(norm0);
            norm0.scl(scale);
            vect0.sub(norm0);
            terminate = vect0.len() < this.tolerance * leng;
            vect0.set(anchors[0] - anchors[6], anchors[1] - anchors[7]);
            norm0.set(anchors[4] - anchors[6], anchors[5] - anchors[7]);
            norm0.nor();
            scale = vect0.dot(norm0);
            norm0.scl(scale);
            vect0.sub(norm0);
            boolean bl2 = terminate = terminate && vect0.len() < this.tolerance * leng;
        }
        if (terminate) {
            this.points[2 * this.size] = anchors[0];
            this.points[2 * this.size + 1] = anchors[1];
            this.tangts[2 * this.size] = 3.0f * (anchors[2] - anchors[0]);
            this.tangts[2 * this.size + 1] = 3.0f * (anchors[3] - anchors[1]);
            this.params[this.size] = tp;
            ++this.size;
        } else {
            float[] left = new float[anchors.length];
            float[] rght = new float[anchors.length];
            float alpha = 0.5f;
            float hx = (1.0f - alpha) * anchors[2] + alpha * anchors[4];
            float hy = (1.0f - alpha) * anchors[3] + alpha * anchors[5];
            left[0] = anchors[0];
            left[1] = anchors[1];
            left[2] = (1.0f - alpha) * anchors[0] + alpha * anchors[2];
            left[3] = (1.0f - alpha) * anchors[1] + alpha * anchors[3];
            left[4] = (1.0f - alpha) * left[2] + alpha * hx;
            left[5] = (1.0f - alpha) * left[3] + alpha * hy;
            rght[7] = anchors[7];
            rght[6] = anchors[6];
            rght[5] = (1.0f - alpha) * anchors[5] + alpha * anchors[7];
            rght[4] = (1.0f - alpha) * anchors[4] + alpha * anchors[6];
            rght[3] = (1.0f - alpha) * hy + alpha * rght[5];
            rght[2] = (1.0f - alpha) * hx + alpha * rght[4];
            rght[1] = (1.0f - alpha) * left[5] + alpha * rght[3];
            rght[0] = (1.0f - alpha) * left[4] + alpha * rght[2];
            left[6] = rght[0];
            left[7] = rght[1];
            this.process(left, depth + 1, tp);
            this.process(rght, depth + 1, tp + 1.0f / (float)(1 << depth + 1));
        }
    }

    public float closest(float[] p) {
        float bestT = -1.0f;
        float bestDistance = 10.0f;
        float bestX = 0.0f;
        float bestY = 0.0f;
        for (int ii = 0; ii < this.size; ++ii) {
            float thisT = this.params[ii];
            vect0.set(p[0] - this.points[2 * ii], p[1] - this.points[2 * ii + 1]);
            if (!(vect0.len() < bestDistance)) continue;
            bestDistance = vect0.len();
            bestT = thisT;
            bestX = this.points[2 * ii];
            bestY = this.points[2 * ii + 1];
        }
        if (bestT >= 0.0f) {
            p[0] = bestX;
            p[1] = bestY;
        }
        return bestT;
    }

    public int placePoints(FloatBuffer pointBuffer) {
        pointBuffer.put(this.points);
        return this.size;
    }

    public int placeVertices(FloatBuffer vertexBuffer, float weight) {
        if (this.size < 2) {
            return 0;
        }
        norm0.set(this.points[2] - this.points[0], this.points[3] - this.points[1]);
        norm0.set(-BezierBuffer.norm0.y, BezierBuffer.norm0.x);
        norm0.nor();
        norm0.scl(weight / 2.0f);
        System.out.println("0:" + this.points[0] + "," + this.points[1]);
        vertexBuffer.put(this.points[0] + BezierBuffer.norm0.x);
        vertexBuffer.put(this.points[1] + BezierBuffer.norm0.y);
        vertexBuffer.put(this.points[0] - BezierBuffer.norm0.x);
        vertexBuffer.put(this.points[1] - BezierBuffer.norm0.y);
        System.out.println("X " + this.size);
        for (int ii = 1; ii < this.size; ++ii) {
            norm1.set(norm0);
            if (ii < this.size - 1) {
                vect0.set(this.points[2 * ii - 2] - this.points[2 * ii], this.points[2 * ii - 1] - this.points[2 * ii + 1]);
                vect0.nor();
                vect1.set(this.points[2 * ii + 2] - this.points[2 * ii], this.points[2 * ii + 3] - this.points[2 * ii + 1]);
                vect1.nor();
                norm0.set(vect0);
                norm0.add(vect1);
                if (norm0.len() < 0.1f) {
                    norm0.set(-BezierBuffer.vect1.y, BezierBuffer.vect1.x);
                }
            } else {
                norm0.set(this.points[2 * ii] - this.points[2 * ii - 2], this.points[2 * ii + 1] - this.points[2 * ii - 1]);
                norm0.set(-BezierBuffer.norm0.y, BezierBuffer.norm0.x);
            }
            norm0.nor();
            norm0.scl(weight / 2.0f);
            if (norm1.dot(norm0) < 0.0f) {
                norm0.scl(-1.0f);
            }
            System.out.println(ii + ":" + this.points[2 * ii] + "," + this.points[2 * ii + 1]);
            vertexBuffer.put(this.points[2 * ii] + BezierBuffer.norm0.x);
            vertexBuffer.put(this.points[2 * ii + 1] + BezierBuffer.norm0.y);
            vertexBuffer.put(this.points[2 * ii] - BezierBuffer.norm0.x);
            vertexBuffer.put(this.points[2 * ii + 1] - BezierBuffer.norm0.y);
        }
        return this.size;
    }

    public int placeColors(FloatBuffer colorBuffer, float[] colors, boolean weighted) {
        int COLOR_WIDTH = 4;
        float[] temp = new float[COLOR_WIDTH];
        int offset = COLOR_WIDTH;
        if (weighted) {
            offset = 2 * COLOR_WIDTH;
        }
        for (int ii = 0; ii < this.size; ++ii) {
            int jj;
            for (jj = 0; jj < temp.length; ++jj) {
                temp[jj] = (1.0f - this.params[ii]) * colors[jj] + this.params[ii] * colors[offset + jj];
            }
            colorBuffer.put(temp);
            if (!weighted) continue;
            for (jj = 0; jj < temp.length; ++jj) {
                temp[jj] = (1.0f - this.params[ii]) * colors[jj + COLOR_WIDTH] + this.params[ii] * colors[offset + jj + COLOR_WIDTH];
            }
            colorBuffer.put(temp);
        }
        return this.size;
    }

    public int placeNormals(FloatBuffer vertexBuffer, float length) {
        for (int ii = 0; ii < this.size; ++ii) {
            vect0.set(this.tangts[2 * ii], this.tangts[2 * ii + 1]);
            vect0.nor();
            vect0.scl(length);
            vertexBuffer.put(this.points[2 * ii]);
            vertexBuffer.put(this.points[2 * ii + 1]);
            vertexBuffer.put(this.points[2 * ii] - BezierBuffer.vect0.y);
            vertexBuffer.put(this.points[2 * ii + 1] + BezierBuffer.vect0.x);
        }
        return this.size;
    }
}

