/*
 * Decompiled with CFR 0.152.
 */
package playingfields.map;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import playingfields.map.MapObject;

public class Wall
extends MapObject {
    private static final long serialVersionUID = 5726389625693113863L;
    private static final int INFINITY = 10000;
    private int direction;
    private Point origin = new Point();
    private Point target = new Point();

    public Point getOrigin() {
        return new Point(this.origin);
    }

    public void setOrigin(Point point) {
        this.origin = new Point(point);
        this.computeBounds();
    }

    public Point getTarget() {
        return new Point(this.target);
    }

    public void setTarget(Point point) {
        this.target = new Point(point);
        this.computeBounds();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.origin.x < this.target.x) {
            this.origin.x = n;
            this.target.x = n + n3;
        } else {
            this.target.x = n;
            this.origin.x = n + n3;
        }
        if (this.origin.y < this.target.y) {
            this.origin.y = n2;
            this.target.y = n2 + n4;
        } else {
            this.target.y = n2;
            this.origin.y = n2 + n4;
        }
        this.computeBounds();
    }

    public void translate(int n, int n2) {
        this.origin.x += n;
        this.target.x += n;
        this.origin.y += n2;
        this.target.y += n2;
        this.computeBounds();
    }

    private void computeBounds() {
        int n = (this.origin.x < this.target.x ? this.origin.x : this.target.x) - 1;
        int n2 = (this.origin.y < this.target.y ? this.origin.y : this.target.y) - 1;
        int n3 = (this.origin.x < this.target.x ? this.target.x - this.origin.x : this.origin.x - this.target.x) + 2;
        int n4 = (this.origin.y < this.target.y ? this.target.y - this.origin.y : this.origin.y - this.target.y) + 2;
        this.bounds = new Rectangle(n, n2, n3, n4);
    }

    public boolean contains(int n, int n2) {
        float f = this.target.x - this.origin.x;
        float f2 = this.target.y - this.origin.y;
        if (f == 0.0f && f2 == 0.0f) {
            f = n - this.origin.x;
            f2 = n2 - this.origin.y;
            float f3 = this.origin.x;
            float f4 = this.origin.y;
            return Math.sqrt(f * f + f2 * f2) <= 2.5;
        }
        float f5 = ((float)(n - this.origin.x) * f + (float)(n2 - this.origin.y) * f2) / (f * f + f2 * f2);
        if (f5 < 0.0f) {
            f = n - this.origin.x;
            f2 = n2 - this.origin.y;
            float f6 = this.origin.x;
            float f7 = this.origin.y;
        } else if (f5 > 1.0f) {
            f = n - this.target.x;
            f2 = n2 - this.target.y;
            float f8 = this.target.x;
            float f9 = this.target.y;
        } else {
            float f10 = (float)this.origin.x + f5 * f;
            float f11 = (float)this.origin.y + f5 * f2;
            f = (float)n - f10;
            f2 = (float)n2 - f11;
        }
        return Math.sqrt(f * f + f2 * f2) <= 2.5;
    }

    public Area getObstruction(float f, float f2) {
        GeneralPath generalPath = new GeneralPath();
        float f3 = this.origin.x;
        float f4 = this.origin.y;
        float f5 = this.target.x;
        float f6 = this.target.y;
        if (f3 < f5) {
            f3 -= 1.0f;
            f5 += 1.0f;
        } else {
            f3 += 1.0f;
            f5 -= 1.0f;
        }
        if (f4 < f6) {
            f4 -= 1.0f;
            f6 += 1.0f;
        } else {
            f4 += 1.0f;
            f6 -= 1.0f;
        }
        float f7 = (f3 - f) * 10000.0f;
        float f8 = (f4 - f2) * 10000.0f;
        float f9 = (f5 - f) * 10000.0f;
        float f10 = (f6 - f2) * 10000.0f;
        generalPath.moveTo(f3, f4);
        generalPath.lineTo(f + f7, f2 + f8);
        generalPath.lineTo(f + f9, f2 + f10);
        generalPath.lineTo(f5, f6);
        generalPath.closePath();
        return new Area(generalPath);
    }

    public void draw(Graphics graphics, AffineTransform affineTransform) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Float float_ = new Point2D.Float(this.origin.x, this.origin.y);
        Point2D.Float float_2 = new Point2D.Float(this.target.x, this.target.y);
        affineTransform.transform(float_, float_);
        affineTransform.transform(float_2, float_2);
        int n = Math.round(float_.x);
        int n2 = Math.round(float_.y);
        int n3 = Math.round(float_2.x);
        int n4 = Math.round(float_2.y);
        graphics2D.setColor(this.foreground);
        graphics2D.setStroke(STROKE_WALL);
        graphics2D.drawLine(n, n2, n3, n4);
        graphics2D.setColor(this.background);
        graphics2D.setStroke(STROKE_THICK);
        graphics2D.drawLine(n, n2, n3, n4);
    }

    public String toString() {
        return super.toString() + "[" + this.origin + "," + this.target + "]";
    }
}

