/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.Color;
import java.awt.Graphics2D;
import potential.Constants;
import potential.DrawingContext;
import potential.TerrainObject;
import potential.Vector3d;

public class Vehicle
extends TerrainObject
implements Constants {
    public static int COUNTER = 1;
    public int id;
    public static final Color VEHICLE_LINE_COLOR = new Color(0.0f, 0.3f, 0.0f);
    public static final Color VEHICLE_FILL_COLOR = new Color(0.5f, 1.0f, 0.5f);
    public static final Color COLLIDE_LINE_COLOR = new Color(0.0f, 0.4f, 0.4f);
    public static final Color COLLIDE_FILL_COLOR = new Color(0.5f, 0.9f, 0.9f);
    public static final Color VELOCITY_LINE_COLOR = Color.magenta;
    public static final float VELOCITY_LINE_SCALE = 20.0f;
    protected float mass = 1.0f;
    protected float maxSpeed = 0.6f;
    protected float damping = 0.75f;
    protected Vector3d velocity = new Vector3d();
    protected Vector3d acceleration = new Vector3d();
    protected Vector3d forceCache = new Vector3d();

    public Vehicle() {
        this(new Vector3d(0.0f, 0.0f, 0.0f), 0.5f);
    }

    public Vehicle(Vector3d vector3d) {
        this(vector3d, 0.5f);
    }

    public Vehicle(Vector3d vector3d, float f) {
        super(vector3d, f);
        this.id = COUNTER++;
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }

    public Vector3d getAcceleration() {
        return this.acceleration;
    }

    public void setMass(float f) {
        this.mass = f;
    }

    public float getMass() {
        return this.mass;
    }

    public void setMaximumSpeed(float f) {
        this.maxSpeed = f;
    }

    public float getMaximumSpeed() {
        return this.maxSpeed;
    }

    public void setDamping(float f) {
        this.damping = f;
    }

    public float getDamping() {
        return this.damping;
    }

    public void applyForce(Vector3d vector3d) {
        this.forceCache.setScale(1.0f / this.mass, vector3d);
        this.acceleration.set(this.forceCache);
        this.velocity.setScale(this.damping, this.velocity);
        this.velocity.setSum(this.velocity, this.acceleration);
        this.velocity.setApproximateTruncate(this.maxSpeed);
        this.position.setSum(this.position, this.velocity);
    }

    public void draw(Graphics2D graphics2D, DrawingContext drawingContext) {
        Color color = this.touched ? COLLIDE_FILL_COLOR : VEHICLE_FILL_COLOR;
        Color color2 = this.touched ? COLLIDE_LINE_COLOR : VEHICLE_LINE_COLOR;
        drawingContext.setWeight(this.selected ? 2.0f : 1.0f);
        drawingContext.outlineCircle(graphics2D, this.position, this.radius, color, color2);
        drawingContext.drawVector(graphics2D, this.velocity, this.position, this.velocity.approximateLength() * 20.0f, VELOCITY_LINE_COLOR);
    }
}

