/*
 * Decompiled with CFR 0.152.
 */
package potential;

import potential.PotentialFunction;
import potential.TerrainObject;
import potential.Vector3d;

public class StandardAvoidancePotentialFunction
implements PotentialFunction {
    private double epsilon;
    private double coefficient;
    private double separation;

    public StandardAvoidancePotentialFunction() {
        this(1.0, 0.9, 1.4E-45f);
    }

    public StandardAvoidancePotentialFunction(double d, double d2, double d3) {
        this.setCoefficient(d);
        this.setSeparation(this.separation);
        this.setEpsilon(d3);
    }

    public double getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(double d) {
        this.coefficient = Math.max(d, this.epsilon);
    }

    public double getSeparation() {
        return this.separation;
    }

    public void setSeparation(double d) {
        this.separation = Math.min(Math.max(d, 0.0), 1.0);
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double d) {
        this.epsilon = Math.abs(d);
        this.coefficient = Math.max(this.coefficient, d);
    }

    public double computePotential(TerrainObject terrainObject, TerrainObject terrainObject2) {
        Vector3d vector3d = new Vector3d();
        vector3d.setDifference(terrainObject.getPosition(), terrainObject2.getPosition());
        double d = (double)vector3d.magnitude() - this.separation * (double)(terrainObject.radius + terrainObject2.radius);
        if (d <= this.epsilon) {
            d = this.epsilon;
        }
        double d2 = this.coefficient * terrainObject.getCharge() * terrainObject2.getCharge() / d;
        return d2;
    }
}

