/*
 * Decompiled with CFR 0.152.
 */
package potential;

import potential.PotentialFunction;
import potential.Target;
import potential.TerrainObject;
import potential.Vector3d;
import potential.Vehicle;

public class StandardAttractionPotentialFunction
implements PotentialFunction {
    private double coefficient;
    private double crossover;

    public StandardAttractionPotentialFunction() {
        this(0.36787944117144233, 1.0);
    }

    public StandardAttractionPotentialFunction(double d, double d2) {
        this.crossover = d2;
        this.setMaximumForce(d);
    }

    public void setBreakingDistance(double d) {
        this.crossover = d;
    }

    public double getBreakingDistance() {
        return this.crossover;
    }

    public void setMaximumForce(double d) {
        this.coefficient = 2.0 / (Math.E * d * this.crossover);
    }

    public double getMaximumForce() {
        return 2.0 / (this.coefficient * this.crossover * Math.E);
    }

    public double computePotential(TerrainObject terrainObject, TerrainObject terrainObject2) {
        if (terrainObject instanceof Vehicle && terrainObject2 instanceof Target) {
            return this.computeAttraction((Vehicle)terrainObject, (Target)terrainObject2);
        }
        if (terrainObject2 instanceof Vehicle && terrainObject instanceof Target) {
            return this.computeAttraction((Vehicle)terrainObject2, (Target)terrainObject);
        }
        return 0.0;
    }

    private double computeAttraction(Vehicle vehicle, Target target) {
        Vector3d vector3d = new Vector3d();
        vector3d.setDifference(vehicle.getPosition(), target.getPosition());
        double d = vector3d.magnitude();
        double d2 = d > this.crossover ? -2.0 / (this.crossover * Math.E) * (d - this.crossover) + 0.36787944117144233 : Math.exp(-d * d / (this.crossover * this.crossover));
        return -this.coefficient * vehicle.getCharge() * target.getCharge() * d2;
    }
}

