/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import potential.ObstaclePanelController;
import potential.TabComponent;
import potential.Vector3d;

public class ObstaclePanel
extends TabComponent {
    private ObstaclePanelController controller;
    private JTextField xCoordinateField;
    private JTextField yCoordinateField;
    private JButton deleteButton;
    private JSlider obstacleRadiusSlider;
    private JSlider obstacleChargeSlider;

    public ObstaclePanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        JLabel jLabel = new JLabel("Obstacle Location: ");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.xCoordinateField = this.addField("x  ", 3, jPanel2);
        this.xCoordinateField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ObstaclePanel.this.controller != null) {
                    try {
                        float f = Float.valueOf(ObstaclePanel.this.xCoordinateField.getText()).floatValue();
                        ObstaclePanel.this.xCoordinateField.setText(String.format("%.2f", Float.valueOf(f)));
                        ObstaclePanel.this.recalculatePosition();
                    }
                    catch (NumberFormatException numberFormatException) {
                        Vector3d vector3d = ObstaclePanel.this.controller.getSelectedObstaclePosition();
                        ObstaclePanel.this.xCoordinateField.setText(vector3d == null ? "" : String.format("%.2f", Float.valueOf(vector3d.x)));
                    }
                }
            }
        });
        this.yCoordinateField = this.addField("y  ", 3, jPanel2);
        this.yCoordinateField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ObstaclePanel.this.controller != null) {
                    try {
                        float f = Float.valueOf(ObstaclePanel.this.yCoordinateField.getText()).floatValue();
                        ObstaclePanel.this.yCoordinateField.setText(String.format("%.2f", Float.valueOf(f)));
                        ObstaclePanel.this.recalculatePosition();
                    }
                    catch (NumberFormatException numberFormatException) {
                        Vector3d vector3d = ObstaclePanel.this.controller.getSelectedObstaclePosition();
                        ObstaclePanel.this.yCoordinateField.setText(vector3d == null ? "" : String.format("%.2f", Float.valueOf(vector3d.y)));
                    }
                }
            }
        });
        this.deleteButton = new JButton("Clear");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ObstaclePanel.this.controller != null) {
                    ObstaclePanel.this.controller.deleteSelectedObstacle();
                    ObstaclePanel.this.xCoordinateField.setText("");
                    ObstaclePanel.this.yCoordinateField.setText("");
                }
            }
        });
        jPanel2.add(this.deleteButton);
        jPanel.add(jLabel);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.obstacleRadiusSlider = this.addSlider("Obstacle Radius: ", this.floatToTick(0.5f, 0.0f, 10.0f), jPanel3);
        this.obstacleRadiusSlider.setLabelTable(this.createLabels(0.0f, 10.0f));
        this.obstacleRadiusSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ObstaclePanel.this.controller != null) {
                    ObstaclePanel.this.controller.setSelectedObstacleRadius(ObstaclePanel.this.tickToFloat(ObstaclePanel.this.obstacleRadiusSlider.getValue(), 0.0f, 10.0f));
                }
            }
        });
        this.obstacleChargeSlider = this.addSlider("Obstacle Charge: ", this.doubleToTick(0.25, 0.0, 1.0), jPanel3);
        this.obstacleChargeSlider.setLabelTable(this.createLabels(0.0, 1.0));
        this.obstacleChargeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ObstaclePanel.this.controller != null) {
                    ObstaclePanel.this.controller.setSelectedObstacleCharge(ObstaclePanel.this.tickToDouble(ObstaclePanel.this.obstacleChargeSlider.getValue(), 0.0, 1.0));
                }
            }
        });
        this.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JTextArea jTextArea = this.addArea("Instructions: ", 9, 20, jPanel4);
        jTextArea.setText("To create a new obstacle, Control-click\non its desired position.  Use a regular\nclick to select an existing obstacle for\nediting. A selected obstacle is indicated\nby a heavier border.\n\nOnly one obstacle may be selected at a\ntime.  Obstacle selection has no effect\non the simulation.");
        jTextArea.setEditable(false);
        jTextArea.setEnabled(false);
        jTextArea.setDisabledTextColor(Color.black);
        this.add((Component)jPanel4, "South");
    }

    public void update() {
        if (this.controller != null) {
            this.obstacleRadiusSlider.setValue(this.floatToTick(this.controller.getSelectedObstacleRadius(), 0.0f, 10.0f));
            this.obstacleChargeSlider.setValue(this.doubleToTick(this.controller.getSelectedObstacleCharge(), 0.0, 1.0));
            Vector3d vector3d = this.controller.getSelectedObstaclePosition();
            if (vector3d == null) {
                this.xCoordinateField.setText("");
                this.yCoordinateField.setText("");
            } else {
                this.xCoordinateField.setText(String.format("%.2f", Float.valueOf(vector3d.x)));
                this.yCoordinateField.setText(String.format("%.2f", Float.valueOf(vector3d.y)));
            }
        }
    }

    public void setController(ObstaclePanelController obstaclePanelController) {
        this.controller = obstaclePanelController;
        this.update();
    }

    public ObstaclePanelController getController() {
        return this.controller;
    }

    private void recalculatePosition() {
        try {
            float f = Float.valueOf(this.xCoordinateField.getText()).floatValue();
            float f2 = Float.valueOf(this.yCoordinateField.getText()).floatValue();
            this.controller.setSelectedObstaclePosition(new Vector3d(f, f2, 0.0f));
        }
        catch (NumberFormatException numberFormatException) {
            this.controller.deleteSelectedObstacle();
        }
    }
}

