/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import potential.Constants;
import potential.ControlPanel;
import potential.ObstaclePanelController;
import potential.SettingsPanelController;
import potential.TargetPanelController;
import potential.Terrain;
import potential.TerrainObject;
import potential.TerrainPanel;
import potential.Vector3d;
import potential.Vehicle;
import potential.VehiclePanelController;

public class ApplicationController
implements Runnable,
Constants,
TargetPanelController,
VehiclePanelController,
ObstaclePanelController,
SettingsPanelController {
    private Terrain terrain;
    private TerrainPanel terrainPanel;
    private ControlPanel controlPanel;
    private boolean alive = true;
    private boolean pause = false;
    private long slice;
    private float vehicleRadiusCache = 0.5f;
    private float vehicleMassCache = 1.0f;
    private double vehicleChargeCache = 0.25;
    private float vehicleDampingCache = 0.75f;
    private float vehicleMaximumCache = 0.6f;
    private float obstacleRadiusCache = 0.5f;
    private double obstacleChargeCache = 0.25;
    private Vector3d previous = null;
    private Vector3d difference = new Vector3d();
    private MouseInputAdapter mouseController = new MouseInputAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent mouseEvent) {
            Vector3d vector3d = ApplicationController.this.terrainPanel.getPosition(mouseEvent.getPoint());
            switch (ApplicationController.this.controlPanel.getSelectedIndex()) {
                case 0: {
                    Terrain terrain = ApplicationController.this.terrain;
                    synchronized (terrain) {
                        ApplicationController.this.terrain.setAttractionPosition(vector3d);
                        break;
                    }
                }
                case 1: {
                    Terrain terrain = ApplicationController.this.terrain;
                    synchronized (terrain) {
                        Vehicle vehicle;
                        if (mouseEvent.isControlDown()) {
                            ApplicationController.this.terrain.addVehicle(vector3d);
                            vehicle = (Vehicle)ApplicationController.this.terrain.getSelection();
                            vehicle.setRadius(ApplicationController.this.vehicleRadiusCache);
                            vehicle.setMass(ApplicationController.this.vehicleMassCache);
                            vehicle.setCharge(ApplicationController.this.vehicleChargeCache);
                            vehicle.setDamping(ApplicationController.this.vehicleDampingCache);
                            vehicle.setMaximumSpeed(ApplicationController.this.vehicleMaximumCache);
                        } else {
                            ApplicationController.this.terrain.selectVehicle(vector3d);
                            vehicle = (Vehicle)ApplicationController.this.terrain.getSelection();
                        }
                        if (vehicle != null) {
                            ApplicationController.this.previous = new Vector3d(vehicle.getPosition());
                        }
                        break;
                    }
                }
                case 2: {
                    Terrain terrain = ApplicationController.this.terrain;
                    synchronized (terrain) {
                        TerrainObject terrainObject;
                        if (mouseEvent.isControlDown()) {
                            ApplicationController.this.terrain.addObstacle(vector3d);
                            terrainObject = ApplicationController.this.terrain.getSelection();
                            terrainObject.setRadius(ApplicationController.this.obstacleRadiusCache);
                            terrainObject.setCharge(ApplicationController.this.obstacleChargeCache);
                        } else {
                            ApplicationController.this.terrain.selectObstacle(vector3d);
                            terrainObject = ApplicationController.this.terrain.getSelection();
                        }
                        if (terrainObject != null) {
                            ApplicationController.this.previous = new Vector3d(terrainObject.getPosition());
                        }
                        break;
                    }
                }
            }
            ApplicationController.this.controlPanel.update();
            ApplicationController.this.terrainPanel.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent mouseEvent) {
            if (ApplicationController.this.previous != null) {
                Vector3d vector3d = ApplicationController.this.terrainPanel.getPosition(mouseEvent.getPoint());
                ApplicationController.this.difference.setDifference(vector3d, ApplicationController.this.previous);
                Terrain terrain = ApplicationController.this.terrain;
                synchronized (terrain) {
                    TerrainObject terrainObject = ApplicationController.this.terrain.getSelection();
                    if (terrainObject != null) {
                        terrainObject.getPosition().setSum(terrainObject.getPosition(), ApplicationController.this.difference);
                    }
                }
                ApplicationController.this.previous.set(vector3d);
                ApplicationController.this.controlPanel.update();
                ApplicationController.this.terrainPanel.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            if (ApplicationController.this.previous != null) {
                ApplicationController.this.difference.setDifference(ApplicationController.this.terrainPanel.getPosition(mouseEvent.getPoint()), ApplicationController.this.previous);
                Terrain terrain = ApplicationController.this.terrain;
                synchronized (terrain) {
                    TerrainObject terrainObject = ApplicationController.this.terrain.getSelection();
                    if (terrainObject != null) {
                        terrainObject.getPosition().setSum(terrainObject.getPosition(), ApplicationController.this.difference);
                    }
                }
                ApplicationController.this.previous = null;
                ApplicationController.this.controlPanel.update();
                ApplicationController.this.terrainPanel.repaint();
            }
        }
    };

    public ApplicationController() {
        this.setFrameRate(25.0);
    }

    public void setTerrain(Terrain terrain) {
        this.terrain = terrain;
    }

    public Terrain getTerrain() {
        return this.terrain;
    }

    public void setTerrainPanel(TerrainPanel terrainPanel) {
        this.terrainPanel = terrainPanel;
        this.terrainPanel.addMouseListener(this.mouseController);
        this.terrainPanel.addMouseMotionListener(this.mouseController);
    }

    public TerrainPanel getTerrainPanel() {
        return this.terrainPanel;
    }

    public void setControlPanel(ControlPanel controlPanel) {
        this.controlPanel = controlPanel;
        this.controlPanel.setTargetPanelController(this);
        this.controlPanel.setVehiclePanelController(this);
        this.controlPanel.setObstaclePanelController(this);
        this.controlPanel.setSettingsPanelController(this);
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttractionCharge(double d) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setAttractionCharge(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAttractionCharge() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            return this.terrain.getAttractionCharge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttractionMaximum(double d) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setAttractionMaximum(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAttractionMaximum() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            return this.terrain.getAttractionMaximum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttractionBreaking(double d) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setAttractionBreaking(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAttractionBreaking() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            return this.terrain.getAttractionBreaking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttractionPosition(Vector3d vector3d) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setAttractionPosition(vector3d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector3d getAttractionPosition() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            return this.terrain.getAttractionPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedVehicle() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.deleteSelectedVehicle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedVehiclePosition(Vector3d vector3d) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setSelectedVehiclePosition(vector3d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector3d getSelectedVehiclePosition() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            return this.terrain.getSelectedVehiclePosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedVehicleRadius(float f) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setSelectedVehicleRadius(f);
        }
        this.vehicleRadiusCache = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getSelectedVehicleRadius() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.vehicleRadiusCache = this.terrain.getSelectedVehicleRadius();
        }
        return this.vehicleRadiusCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedVehicleMass(float f) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setSelectedVehicleMass(f);
        }
        this.vehicleMassCache = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getSelectedVehicleMass() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.vehicleMassCache = this.terrain.getSelectedVehicleMass();
        }
        return this.vehicleMassCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedVehicleCharge(double d) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setSelectedVehicleCharge(d);
        }
        this.vehicleChargeCache = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSelectedVehicleCharge() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.vehicleChargeCache = this.terrain.getSelectedVehicleCharge();
        }
        return this.vehicleChargeCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedVehicleDamping(float f) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setSelectedVehicleDamping(f);
        }
        this.vehicleDampingCache = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getSelectedVehicleDamping() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.vehicleDampingCache = this.terrain.getSelectedVehicleDamping();
        }
        return this.vehicleDampingCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedVehicleMaximumSpeed(float f) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setSelectedVehicleMaximumSpeed(f);
        }
        this.vehicleMaximumCache = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getSelectedVehicleMaximumSpeed() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.vehicleMaximumCache = this.terrain.getSelectedVehicleMaximumSpeed();
        }
        return this.vehicleMaximumCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedObstacle() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.deleteSelectedObstacle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedObstaclePosition(Vector3d vector3d) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setSelectedObstaclePosition(vector3d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector3d getSelectedObstaclePosition() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            return this.terrain.getSelectedObstaclePosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedObstacleRadius(float f) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setSelectedObstacleRadius(f);
        }
        this.obstacleRadiusCache = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getSelectedObstacleRadius() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.obstacleRadiusCache = this.terrain.getSelectedObstacleRadius();
        }
        return this.obstacleRadiusCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedObstacleCharge(double d) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setSelectedObstacleCharge(d);
        }
        this.obstacleChargeCache = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSelectedObstacleCharge() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.obstacleChargeCache = this.terrain.getSelectedObstacleCharge();
        }
        return this.obstacleChargeCache;
    }

    public void setFrameRate(double d) {
        this.slice = (long)(1000.0 / d);
    }

    public double getFrameRate() {
        return 1000.0 / (double)this.slice;
    }

    public void setDrawingScale(float f) {
        this.terrainPanel.setScale(f);
    }

    public float getDrawingScale() {
        return this.terrainPanel.getScale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvoidanceCoefficient(double d) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setAvoidanceCoefficient(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAvoidanceCoefficient() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            return this.terrain.getAvoidanceCoefficient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvoidanceSeparation(double d) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setAvoidanceSeparation(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAvoidanceSeparation() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            return this.terrain.getAvoidanceSeparation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvoidanceEpsilon(byte by) {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            this.terrain.setAvoidanceEpsilon(by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getAvoidanceEpsilon() {
        Terrain terrain = this.terrain;
        synchronized (terrain) {
            return this.terrain.getAvoidanceEpsilon();
        }
    }

    public void setAnimated(boolean bl) {
        this.pause = !bl;
    }

    public boolean isAnimated() {
        return !this.pause;
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        this.alive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.alive) {
            long l;
            if (this.terrainPanel == null) {
                throw new IllegalStateException();
            }
            long l2 = System.currentTimeMillis();
            if (this.pause) {
                l = l2;
            } else {
                Terrain terrain = this.terrain;
                synchronized (terrain) {
                    this.terrain.update();
                }
                this.terrainPanel.repaint();
                l = System.currentTimeMillis();
            }
            l2 += this.slice - l;
            try {
                if (l2 <= 0L) continue;
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

