/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class FilmStrip
extends TextureRegion {
    private int cols;
    private int rwidth;
    private int rheight;
    private int size;
    private int frame;

    public FilmStrip(Texture texture, int rows, int cols) {
        this(texture, rows, cols, rows * cols);
    }

    public FilmStrip(Texture texture, int rows, int cols, int size) {
        super(texture);
        if (size > rows * cols) {
            Gdx.app.error("FilmStrip", "Invalid strip size", (Throwable)new IllegalArgumentException());
            return;
        }
        this.cols = cols;
        this.size = size;
        this.rwidth = texture.getWidth() / cols;
        this.rheight = texture.getHeight() / rows;
        this.setFrame(0);
    }

    public int getSize() {
        return this.size;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        if (frame < 0 || frame >= this.size) {
            Gdx.app.error("FilmStrip", "Invalid animation frame", (Throwable)new IllegalArgumentException());
            return;
        }
        this.frame = frame;
        int x = frame % this.cols * this.rwidth;
        int y = frame / this.cols * this.rheight;
        this.setRegion(x, y, this.rwidth, this.rheight);
    }
}

