/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.optimize.entity;

import com.badlogic.gdx.graphics.Color;
import edu.cornell.gdiac.optimize.GameCanvas;
import edu.cornell.gdiac.optimize.GameObject;
import edu.cornell.gdiac.optimize.RandomController;

public class Star
extends GameObject {
    private static final int STAR_AGE = 30;
    private static final int AGE_RANGE = 10;
    private int age = RandomController.rollInt(20, 40);
    private float angle;

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.STAR;
    }

    public float getAngle() {
        return this.angle;
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        if (--this.age == 0) {
            this.destroyed = true;
        }
        this.angle = (float)((double)(delta * 1000.0f) % (Math.PI * 8));
    }

    @Override
    public void draw(GameCanvas canvas) {
        canvas.draw(this.animator, Color.WHITE, this.origin.x, this.origin.y, this.position.x, this.position.y, this.angle, 1.0f, 1.0f);
    }
}

