/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.optimize.entity;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import edu.cornell.gdiac.optimize.GameCanvas;
import edu.cornell.gdiac.optimize.GameObject;
import edu.cornell.gdiac.util.FilmStrip;

public class Ship
extends GameObject {
    private static final float BEETLE_SPEED = 4.0f;
    private static final int COOLDOWN_TIME = 8;
    private static final int COOLDOWN_BONUS = 3;
    private static final float ANIMATION_SPEED = 0.25f;
    private static final int NUM_ANIM_FRAMES = 2;
    private static final int POWER_KILL = 20;
    private static final int POWER_TIME = 600;
    private float movement = 0.0f;
    private boolean firing = false;
    private int cooldown = 0;
    private float animeframe = 0.0f;
    private boolean powered = false;
    private int killcount = 0;
    private int powertime;

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.SHIP;
    }

    public float getMovement() {
        return this.movement;
    }

    public void setMovement(float value) {
        this.movement = value;
    }

    public boolean isFiring() {
        return this.firing && this.cooldown <= 0;
    }

    public void setFiring(boolean value) {
        this.firing = value;
    }

    public void resetCooldown() {
        this.cooldown = 8;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void registerKill() {
        if (!this.powered) {
            ++this.killcount;
        }
        if (this.killcount == 20) {
            this.powertime = 600;
            this.powered = true;
            this.killcount = 0;
        }
    }

    @Override
    public void setTexture(Texture texture) {
        this.animator = new FilmStrip(texture, 1, 2, 2);
        this.radius = (float)this.animator.getRegionHeight() / 2.0f;
        this.origin = new Vector2((float)this.animator.getRegionWidth() / 2.0f, (float)this.animator.getRegionHeight() / 2.0f);
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        if (this.movement != 0.0f) {
            this.animeframe += 0.25f;
            if (this.animeframe >= 2.0f) {
                this.animeframe -= 2.0f;
            }
            this.position.x += this.movement * 4.0f;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (!this.firing) {
            this.cooldown -= 3;
        }
        if (this.powered) {
            --this.powertime;
            if (this.powertime == 0) {
                this.powered = false;
            }
        }
    }

    @Override
    public void draw(GameCanvas canvas) {
        float x = (float)this.animator.getRegionWidth() / 2.0f;
        float y = (float)this.animator.getRegionHeight() / 2.0f;
        this.animator.setFrame((int)this.animeframe);
        canvas.draw(this.animator, Color.WHITE, x, y, this.position.x, this.position.y, 0.0f, 1.0f, 1.0f);
    }
}

