/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.optimize.entity;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import edu.cornell.gdiac.optimize.GameCanvas;
import edu.cornell.gdiac.optimize.GameObject;
import edu.cornell.gdiac.optimize.RandomController;
import edu.cornell.gdiac.util.FilmStrip;

public class Shell
extends GameObject {
    private static final float MAX_FRICTION_MULT = 0.95f;
    private static final float MIN_FRICTION_MULT = 0.85f;
    private static final float MAX_MIN_Y_VELOC = 20.0f;
    private static final float MIN_MIN_Y_VELOC = 10.0f;
    private static final float GRAVITY = 0.5f;
    private static final float SHELL_SIZE_MULTIPLE = 2.0f;
    private static final float ANIMATION_SPEED = 0.25f;
    private static final int NUM_ANIM_FRAMES = 4;
    private float friction = RandomController.rollFloat(0.85f, 0.95f);
    private float minvelocy = RandomController.rollFloat(10.0f, 20.0f);
    private float animeframe = 0.0f;
    private boolean damaged;
    private Texture dmgTexture;
    private boolean shooter;
    private boolean firing;
    private int cooldown;

    @Override
    public GameObject.ObjectType getType() {
        return GameObject.ObjectType.SHELL;
    }

    public float getFriction() {
        return this.friction;
    }

    public float getMinVY() {
        return this.minvelocy;
    }

    @Override
    public void setDestroyed(boolean value) {
        if (value) {
            if (!this.damaged && this.dmgTexture != null) {
                this.animator.setTexture(this.dmgTexture);
                this.dmgTexture = null;
            } else {
                this.destroyed = value;
            }
        } else {
            this.destroyed = value;
        }
    }

    public void initShooter() {
        this.damaged = true;
        this.shooter = true;
        this.cooldown = 0;
    }

    public boolean isShooter() {
        return this.shooter;
    }

    public boolean isFiring() {
        return this.shooter && this.firing;
    }

    public void resetCooldown() {
        this.cooldown = 50;
    }

    @Override
    public void setTexture(Texture texture) {
        this.animator = new FilmStrip(texture, 1, 4, 4);
        this.origin = new Vector2((float)this.animator.getRegionWidth() / 2.0f, (float)this.animator.getRegionHeight() / 2.0f);
        this.radius = (float)this.animator.getRegionHeight() / 2.0f;
    }

    public void setDamagedTexture(Texture texture) {
        this.dmgTexture = texture;
    }

    public Texture getDamagedTexture() {
        return this.dmgTexture;
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        this.animeframe += 0.25f;
        if (this.animeframe >= 4.0f) {
            this.animeframe -= 4.0f;
        }
        this.velocity.y -= 0.5f;
        if (this.shooter) {
            this.velocity.y += 0.25f;
            if (this.cooldown > 0) {
                --this.cooldown;
                this.firing = false;
            } else {
                this.firing = true;
            }
        }
    }

    @Override
    public void draw(GameCanvas canvas) {
        this.animator.setFrame((int)this.animeframe);
        canvas.draw(this.animator, Color.WHITE, this.origin.x, this.origin.y, this.position.x, this.position.y, 0.0f, 2.0f, 2.0f);
    }
}

