/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.optimize;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.ControllerMapping;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.optimize.GameCanvas;
import edu.cornell.gdiac.util.Controllers;
import edu.cornell.gdiac.util.ScreenListener;
import edu.cornell.gdiac.util.XBoxController;

public class LoadingMode
implements Screen,
InputProcessor,
ControllerListener {
    private AssetDirectory internal;
    private AssetDirectory assets;
    private Texture background;
    private Texture playButton;
    private Texture statusBar;
    private TextureRegion statusBkgLeft;
    private TextureRegion statusBkgMiddle;
    private TextureRegion statusBkgRight;
    private TextureRegion statusFrgLeft;
    private TextureRegion statusFrgMiddle;
    private TextureRegion statusFrgRight;
    private static int DEFAULT_BUDGET = 15;
    private static int STANDARD_WIDTH = 800;
    private static int STANDARD_HEIGHT = 700;
    private static float BAR_WIDTH_RATIO = 0.66f;
    private static float BAR_HEIGHT_RATIO = 0.25f;
    private static int PROGRESS_HEIGHT = 30;
    private static int PROGRESS_CAP = 15;
    private static int PROGRESS_MIDDLE = 200;
    private static float BUTTON_SCALE = 0.75f;
    private GameCanvas canvas;
    private ScreenListener listener;
    private int width;
    private int centerY;
    private int centerX;
    private int heightY;
    private float scale;
    private float progress;
    private int pressState;
    private int budget;
    private boolean active;

    public int getBudget() {
        return this.budget;
    }

    public void setBudget(int millis) {
        this.budget = millis;
    }

    public boolean isReady() {
        return this.pressState == 2;
    }

    public AssetDirectory getAssets() {
        return this.assets;
    }

    public LoadingMode(String file, GameCanvas canvas) {
        this(file, canvas, DEFAULT_BUDGET);
    }

    public LoadingMode(String file, GameCanvas canvas, int millis) {
        this.canvas = canvas;
        this.budget = millis;
        this.resize(canvas.getWidth(), canvas.getHeight());
        this.internal = new AssetDirectory("loading.json");
        this.internal.loadAssets();
        this.internal.finishLoading();
        this.playButton = null;
        this.background = this.internal.getEntry("background", Texture.class);
        this.background.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.statusBar = this.internal.getEntry("progress", Texture.class);
        this.statusBkgLeft = this.internal.getEntry("progress.backleft", TextureRegion.class);
        this.statusBkgRight = this.internal.getEntry("progress.backright", TextureRegion.class);
        this.statusBkgMiddle = this.internal.getEntry("progress.background", TextureRegion.class);
        this.statusFrgLeft = this.internal.getEntry("progress.foreleft", TextureRegion.class);
        this.statusFrgRight = this.internal.getEntry("progress.foreright", TextureRegion.class);
        this.statusFrgMiddle = this.internal.getEntry("progress.foreground", TextureRegion.class);
        this.progress = 0.0f;
        this.pressState = 0;
        Gdx.input.setInputProcessor((InputProcessor)this);
        for (XBoxController controller : Controllers.get().getXBoxControllers()) {
            controller.addListener(this);
        }
        this.assets = new AssetDirectory(file);
        this.assets.loadAssets();
        this.active = true;
    }

    public void dispose() {
        this.internal.unloadAssets();
        this.internal.dispose();
    }

    private void update(float delta) {
        if (this.playButton == null) {
            this.assets.update(this.budget);
            this.progress = this.assets.getProgress();
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
                this.playButton = this.internal.getEntry("play", Texture.class);
            }
        }
    }

    private void draw() {
        this.canvas.begin();
        this.canvas.draw(this.background, 0.0f, -100.0f);
        if (this.playButton == null) {
            this.drawProgress(this.canvas);
        } else {
            Color tint = this.pressState == 1 ? Color.GRAY : Color.WHITE;
            this.canvas.draw(this.playButton, tint, (float)(this.playButton.getWidth() / 2), (float)(this.playButton.getHeight() / 2), (float)this.centerX, (float)this.centerY, 0.0f, BUTTON_SCALE * this.scale, BUTTON_SCALE * this.scale);
        }
        this.canvas.end();
    }

    private void drawProgress(GameCanvas canvas) {
        canvas.draw(this.statusBkgLeft, (float)(this.centerX - this.width / 2), (float)this.centerY, this.scale * (float)PROGRESS_CAP, this.scale * (float)PROGRESS_HEIGHT);
        canvas.draw(this.statusBkgRight, (float)(this.centerX + this.width / 2) - this.scale * (float)PROGRESS_CAP, (float)this.centerY, this.scale * (float)PROGRESS_CAP, this.scale * (float)PROGRESS_HEIGHT);
        canvas.draw(this.statusBkgMiddle, (float)(this.centerX - this.width / 2) + this.scale * (float)PROGRESS_CAP, (float)this.centerY, (float)this.width - 2.0f * this.scale * (float)PROGRESS_CAP, this.scale * (float)PROGRESS_HEIGHT);
        canvas.draw(this.statusFrgLeft, (float)(this.centerX - this.width / 2), (float)this.centerY, this.scale * (float)PROGRESS_CAP, this.scale * (float)PROGRESS_HEIGHT);
        if (this.progress > 0.0f) {
            float span = this.progress * ((float)this.width - 2.0f * this.scale * (float)PROGRESS_CAP) / 2.0f;
            canvas.draw(this.statusFrgRight, (float)(this.centerX - this.width / 2) + this.scale * (float)PROGRESS_CAP + span, (float)this.centerY, this.scale * (float)PROGRESS_CAP, this.scale * (float)PROGRESS_HEIGHT);
            canvas.draw(this.statusFrgMiddle, (float)(this.centerX - this.width / 2) + this.scale * (float)PROGRESS_CAP, (float)this.centerY, span, this.scale * (float)PROGRESS_HEIGHT);
        } else {
            canvas.draw(this.statusFrgRight, (float)(this.centerX - this.width / 2) + this.scale * (float)PROGRESS_CAP, (float)this.centerY, this.scale * (float)PROGRESS_CAP, this.scale * (float)PROGRESS_HEIGHT);
        }
    }

    public void render(float delta) {
        if (this.active) {
            this.update(delta);
            this.draw();
            if (this.isReady() && this.listener != null) {
                this.listener.exitScreen(this, 0);
            }
        }
    }

    public void resize(int width, int height) {
        float sx = (float)width / (float)STANDARD_WIDTH;
        float sy = (float)height / (float)STANDARD_HEIGHT;
        this.scale = sx < sy ? sx : sy;
        this.width = (int)(BAR_WIDTH_RATIO * (float)width);
        this.centerY = (int)(BAR_HEIGHT_RATIO * (float)height);
        this.centerX = width / 2;
        this.heightY = height;
    }

    public void pause() {
    }

    public void resume() {
    }

    public void show() {
        this.active = true;
    }

    public void hide() {
        this.active = false;
    }

    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.playButton == null || this.pressState == 2) {
            return true;
        }
        float dist = (screenX - this.centerX) * (screenX - this.centerX) + ((screenY = this.heightY - screenY) - this.centerY) * (screenY - this.centerY);
        float radius = BUTTON_SCALE * this.scale * (float)this.playButton.getWidth() / 2.0f;
        if (dist < radius * radius) {
            this.pressState = 1;
        }
        return false;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.pressState == 1) {
            this.pressState = 2;
            return false;
        }
        return true;
    }

    public boolean buttonDown(Controller controller, int buttonCode) {
        ControllerMapping mapping;
        if (this.pressState == 0 && (mapping = controller.getMapping()) != null && buttonCode == mapping.buttonStart) {
            this.pressState = 1;
            return false;
        }
        return true;
    }

    public boolean buttonUp(Controller controller, int buttonCode) {
        ControllerMapping mapping;
        if (this.pressState == 1 && (mapping = controller.getMapping()) != null && buttonCode == mapping.buttonStart) {
            this.pressState = 2;
            return false;
        }
        return true;
    }

    public boolean keyDown(int keycode) {
        return true;
    }

    public boolean keyTyped(char character) {
        return true;
    }

    public boolean keyUp(int keycode) {
        return true;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        return true;
    }

    public boolean scrolled(float dx, float dy) {
        return true;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return true;
    }

    public void connected(Controller controller) {
    }

    public void disconnected(Controller controller) {
    }

    public boolean axisMoved(Controller controller, int axisCode, float value) {
        return true;
    }
}

