/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.optimize;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.optimize.GameObject;
import edu.cornell.gdiac.optimize.InputController;
import edu.cornell.gdiac.optimize.RandomController;
import edu.cornell.gdiac.optimize.entity.Bullet;
import edu.cornell.gdiac.optimize.entity.Shell;
import edu.cornell.gdiac.optimize.entity.Ship;
import edu.cornell.gdiac.optimize.entity.Star;

public class GameplayController {
    private Texture beetleTexture;
    private Texture starTexture;
    private Texture bulletTexture;
    private Texture greenTexture;
    private Texture redTexture;
    private static final float MIN_SHELL_VX = 3.0f;
    private static final float MAX_SHELL_VX = 10.0f;
    private static final float BULLET_OFFSET = 5.0f;
    private static final float BULLET_SPEED = 10.0f;
    private static final float MIN_STAR_FACTOR = 0.1f;
    private static final float MAX_STAR_FACTOR = 0.2f;
    private static final float MIN_STAR_OFFSET = -3.0f;
    private static final float MAX_STAR_OFFSET = 3.0f;
    private Ship player = null;
    private int shellCount = 0;
    private Array<GameObject> objects = new Array();
    private Array<GameObject> backing = new Array();

    public void populate(AssetDirectory directory) {
        this.beetleTexture = directory.getEntry("beetle", Texture.class);
        this.bulletTexture = directory.getEntry("bullet", Texture.class);
        this.starTexture = directory.getEntry("star", Texture.class);
        this.redTexture = directory.getEntry("red", Texture.class);
        this.greenTexture = directory.getEntry("green", Texture.class);
    }

    public Array<GameObject> getObjects() {
        return this.objects;
    }

    public Ship getPlayer() {
        return this.player;
    }

    public boolean isAlive() {
        return this.player != null;
    }

    public int getShellCount() {
        return this.shellCount;
    }

    public void start(float x, float y) {
        this.player = new Ship();
        this.player.setTexture(this.beetleTexture);
        this.player.getPosition().set(x, y);
        this.objects.add((Object)this.player);
    }

    public void reset() {
        this.player = null;
        this.shellCount = 0;
        this.objects.clear();
    }

    public void addShell(float width, float height) {
        Shell b = new Shell();
        if (RandomController.rollInt(0, 2) == 0) {
            b.setTexture(this.redTexture);
            b.setDamagedTexture(this.greenTexture);
        } else {
            b.setTexture(this.greenTexture);
            b.setDamagedTexture(null);
        }
        float vx = RandomController.rollFloat(3.0f, 10.0f);
        b.setX(RandomController.rollFloat(0.0f, width));
        b.setY(height);
        b.setVX(vx *= (float)RandomController.rollInt(0, 1) * 2.0f - 1.0f);
        this.objects.add((Object)b);
        ++this.shellCount;
    }

    public void garbageCollect() {
        for (GameObject o : this.objects) {
            if (o.isDestroyed()) {
                this.destroy(o);
                continue;
            }
            this.backing.add((Object)o);
        }
        Array<GameObject> tmp = this.backing;
        this.backing = this.objects;
        this.objects = tmp;
        this.backing.clear();
    }

    protected void destroy(GameObject o) {
        switch (o.getType()) {
            case SHIP: {
                this.player = null;
                break;
            }
            case SHELL: {
                for (int j = 0; j < 6; ++j) {
                    Star s = new Star();
                    s.setTexture(this.starTexture);
                    s.getPosition().set(o.getPosition());
                    float vx = o.getVX() * RandomController.rollFloat(0.1f, 0.2f) + RandomController.rollFloat(-3.0f, 3.0f);
                    float vy = o.getVY() * RandomController.rollFloat(0.1f, 0.2f) + RandomController.rollFloat(-3.0f, 3.0f);
                    s.getVelocity().set(vx, vy);
                    this.backing.add((Object)s);
                }
                --this.shellCount;
                break;
            }
        }
    }

    public void resolveActions(InputController input, float delta) {
        if (this.player != null) {
            this.resolvePlayer(input, delta);
        }
        for (GameObject o : this.objects) {
            o.update(delta);
        }
    }

    public void resolvePlayer(InputController input, float delta) {
        this.player.setMovement(input.getMovement());
        this.player.setFiring(input.didFire());
        this.player.update(delta);
        if (!this.player.isFiring()) {
            return;
        }
        Bullet b = new Bullet();
        b.setTexture(this.bulletTexture);
        b.setX(this.player.getX());
        b.setY(this.player.getY() + this.player.getRadius() + 5.0f);
        b.setVY(10.0f);
        this.backing.add((Object)b);
        this.player.resetCooldown();
    }
}

