/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.optimize;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import edu.cornell.gdiac.optimize.GameCanvas;
import edu.cornell.gdiac.util.FilmStrip;

public abstract class GameObject {
    protected Vector2 position = new Vector2(0.0f, 0.0f);
    protected Vector2 velocity = new Vector2(0.0f, 0.0f);
    protected Vector2 origin;
    protected float radius = 0.0f;
    protected boolean destroyed = false;
    protected FilmStrip animator;

    public void setTexture(Texture texture) {
        this.animator = new FilmStrip(texture, 1, 1, 1);
        this.radius = (float)this.animator.getRegionHeight() / 2.0f;
        this.origin = new Vector2((float)this.animator.getRegionWidth() / 2.0f, (float)this.animator.getRegionHeight() / 2.0f);
    }

    public Texture getTexture() {
        return this.animator == null ? null : this.animator.getTexture();
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public float getX() {
        return this.position.x;
    }

    public void setX(float value) {
        this.position.x = value;
    }

    public float getY() {
        return this.position.y;
    }

    public void setY(float value) {
        this.position.y = value;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public float getVX() {
        return this.velocity.x;
    }

    public void setVX(float value) {
        this.velocity.x = value;
    }

    public float getVY() {
        return this.velocity.y;
    }

    public void setVY(float value) {
        this.velocity.y = value;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean value) {
        this.destroyed = value;
    }

    public float getRadius() {
        return this.radius;
    }

    public abstract ObjectType getType();

    public void update(float delta) {
        this.position.add(this.velocity);
    }

    public void draw(GameCanvas canvas) {
        canvas.draw(this.animator, Color.WHITE, this.origin.x, this.origin.y, this.position.x, this.position.y, 0.0f, 1.0f, 1.0f);
    }

    public static enum ObjectType {
        SHELL,
        SHIP,
        BULLET,
        STAR;

    }
}

