/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.optimize;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.optimize.CollisionController;
import edu.cornell.gdiac.optimize.GameCanvas;
import edu.cornell.gdiac.optimize.GameObject;
import edu.cornell.gdiac.optimize.GameplayController;
import edu.cornell.gdiac.optimize.InputController;
import edu.cornell.gdiac.optimize.RandomController;
import edu.cornell.gdiac.util.ScreenListener;

public class GameMode
implements Screen {
    private Texture background;
    private BitmapFont displayFont;
    private static final float TIME_MODIFIER = 0.06f;
    private static final float COUNTER_OFFSET = 5.0f;
    private static final float GAME_OVER_OFFSET = 40.0f;
    private GameCanvas canvas;
    private InputController inputController;
    private CollisionController physicsController;
    private GameplayController gameplayController;
    private GameState gameState;
    private float totalTime = 0.0f;
    private boolean active;
    private ScreenListener listener;
    int done = 0;

    public GameMode(GameCanvas canvas) {
        this.canvas = canvas;
        this.active = false;
        this.gameState = GameState.INTRO;
        this.inputController = new InputController();
        this.gameplayController = new GameplayController();
        this.physicsController = new CollisionController(canvas.getWidth(), canvas.getHeight());
    }

    public void dispose() {
        this.inputController = null;
        this.gameplayController = null;
        this.physicsController = null;
        this.canvas = null;
    }

    public void populate(AssetDirectory directory) {
        this.background = directory.getEntry("background", Texture.class);
        this.displayFont = directory.getEntry("times", BitmapFont.class);
        this.gameplayController.populate(directory);
    }

    private void update(float delta) {
        this.inputController.readInput();
        switch (this.gameState) {
            case INTRO: {
                this.gameState = GameState.PLAY;
                this.gameplayController.start((float)this.canvas.getWidth() / 2.0f, this.physicsController.getFloorLedge());
                break;
            }
            case OVER: {
                if (this.inputController.didReset()) {
                    this.gameState = GameState.PLAY;
                    this.gameplayController.reset();
                    this.gameplayController.start((float)this.canvas.getWidth() / 2.0f, this.physicsController.getFloorLedge());
                    break;
                }
                this.play(delta);
                break;
            }
            case PLAY: {
                this.play(delta);
                break;
            }
        }
    }

    protected void play(float delta) {
        if (!this.gameplayController.isAlive()) {
            this.gameState = GameState.OVER;
        }
        if (RandomController.rollInt(0, 25) == 0 || this.inputController.didFlood()) {
            this.gameplayController.addShell(this.canvas.getWidth(), this.canvas.getHeight());
        }
        this.gameplayController.resolveActions(this.inputController, delta);
        this.totalTime += delta * 1000.0f;
        float offset = (float)this.canvas.getWidth() - this.totalTime * 0.06f % (float)this.canvas.getWidth();
        this.physicsController.processCollisions(this.gameplayController.getObjects(), (int)offset);
        this.gameplayController.garbageCollect();
    }

    private void draw(float delta) {
        float offset = -(this.totalTime * 0.06f % (float)this.canvas.getWidth());
        this.canvas.begin();
        this.canvas.drawBackground(this.background, offset, -100.0f);
        for (GameObject o : this.gameplayController.getObjects()) {
            o.draw(this.canvas);
        }
        String message = "Current shells: " + this.gameplayController.getShellCount();
        this.canvas.drawText(message, this.displayFont, 5.0f, (float)this.canvas.getHeight() - 5.0f);
        if (this.gameState == GameState.OVER) {
            this.canvas.drawTextCentered("Game Over!", this.displayFont, 40.0f);
            this.canvas.drawTextCentered("Press R to Restart", this.displayFont, 0.0f);
        }
        this.canvas.end();
    }

    public void resize(int width, int height) {
    }

    public void render(float delta) {
        if (this.active) {
            this.update(delta);
            this.draw(delta);
            if (this.inputController.didExit() && this.listener != null) {
                this.listener.exitScreen(this, 0);
            }
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void show() {
        this.active = true;
    }

    public void hide() {
        this.active = false;
    }

    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }

    public static enum GameState {
        INTRO,
        PLAY,
        OVER;

    }
}

