/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.optimize;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Vector2;

public class GameCanvas {
    private PolygonSpriteBatch spriteBatch = new PolygonSpriteBatch();
    private boolean active = false;
    private BlendState blend;
    int width;
    int height;
    private Affine2 local;
    private TextureRegion holder;

    public GameCanvas() {
        this.spriteBatch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        this.holder = new TextureRegion();
        this.local = new Affine2();
    }

    public void dispose() {
        if (this.active) {
            Gdx.app.error("GameCanvas", "Cannot dispose while drawing active", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.dispose();
        this.spriteBatch = null;
        this.local = null;
        this.holder = null;
    }

    public int getWidth() {
        return Gdx.graphics.getWidth();
    }

    public void setWidth(int width) {
        if (this.active) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", (Throwable)new IllegalStateException());
            return;
        }
        this.width = width;
        if (!this.isFullscreen()) {
            Gdx.graphics.setWindowedMode(width, this.getHeight());
        }
        this.resize();
    }

    public int getHeight() {
        return Gdx.graphics.getHeight();
    }

    public void setHeight(int height) {
        if (this.active) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", (Throwable)new IllegalStateException());
            return;
        }
        this.height = height;
        if (!this.isFullscreen()) {
            Gdx.graphics.setWindowedMode(this.getWidth(), height);
        }
        this.resize();
    }

    public Vector2 getSize() {
        return new Vector2((float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
    }

    public void setSize(int width, int height) {
        if (this.active) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", (Throwable)new IllegalStateException());
            return;
        }
        this.width = width;
        this.height = height;
        if (!this.isFullscreen()) {
            Gdx.graphics.setWindowedMode(width, height);
        }
        this.resize();
    }

    public boolean isFullscreen() {
        return Gdx.graphics.isFullscreen();
    }

    public void setFullscreen(boolean value) {
        if (this.active) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", (Throwable)new IllegalStateException());
            return;
        }
        if (value) {
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
        } else {
            Gdx.graphics.setWindowedMode(this.width, this.height);
        }
    }

    public void resize() {
        this.spriteBatch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
    }

    public BlendState getBlendState() {
        return this.blend;
    }

    public void setBlendState(BlendState state) {
        if (state == this.blend) {
            return;
        }
        switch (state) {
            case NO_PREMULT: {
                this.spriteBatch.setBlendFunction(770, 771);
                break;
            }
            case ALPHA_BLEND: {
                this.spriteBatch.setBlendFunction(1, 771);
                break;
            }
            case ADDITIVE: {
                this.spriteBatch.setBlendFunction(770, 1);
                break;
            }
            case OPAQUE: {
                this.spriteBatch.setBlendFunction(1, 0);
            }
        }
        this.blend = state;
    }

    public void begin() {
        this.spriteBatch.begin();
        this.active = true;
        Gdx.gl.glClearColor(0.39f, 0.58f, 0.93f, 1.0f);
        Gdx.gl.glClear(16384);
    }

    public void end() {
        this.spriteBatch.end();
        this.active = false;
    }

    public void drawBackground(Texture image, float x, float y) {
        if (!this.active) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        float w = image.getWidth();
        this.spriteBatch.draw(image, x, y);
        this.spriteBatch.draw(image, x + w, y);
    }

    public void draw(Texture image, float x, float y) {
        if (!this.active) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(image, x, y);
    }

    public void draw(Texture image, float x, float y, float width, float height) {
        if (!this.active) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(image, x, y, width, height);
    }

    public void draw(Texture image, Color tint, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        if (!this.active) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.holder.setRegion(image);
        this.draw(this.holder, tint, ox, oy, x, y, angle, sx, sy);
    }

    public void draw(TextureRegion region, float x, float y) {
        if (!this.active) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(region, x, y);
    }

    public void draw(TextureRegion region, float x, float y, float width, float height) {
        if (!this.active) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(region, x, y, width, height);
    }

    public void draw(TextureRegion region, Color tint, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        if (!this.active) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.computeTransform(ox, oy, x, y, angle, sx, sy);
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, (float)region.getRegionWidth(), (float)region.getRegionHeight(), this.local);
    }

    private void computeTransform(float ox, float oy, float x, float y, float angle, float sx, float sy) {
        this.local.setToTranslation(x, y);
        this.local.rotate(angle);
        this.local.scale(sx, sy);
        this.local.translate(-ox, -oy);
    }

    public void drawText(String text, BitmapFont font, float x, float y) {
        if (!this.active) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        GlyphLayout layout = new GlyphLayout(font, (CharSequence)text);
        font.setColor(Color.WHITE);
        font.draw((Batch)this.spriteBatch, layout, x, y);
    }

    public void drawTextCentered(String text, BitmapFont font, float offset) {
        if (!this.active) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        GlyphLayout layout = new GlyphLayout(font, (CharSequence)text);
        float x = ((float)this.getWidth() - layout.width) / 2.0f;
        float y = ((float)this.getHeight() + layout.height) / 2.0f;
        font.setColor(Color.WHITE);
        font.draw((Batch)this.spriteBatch, layout, x, y + offset);
    }

    public static enum BlendState {
        ALPHA_BLEND,
        NO_PREMULT,
        ADDITIVE,
        OPAQUE;

    }
}

