/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.optimize;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.optimize.GameCanvas;
import edu.cornell.gdiac.optimize.GameMode;
import edu.cornell.gdiac.optimize.LoadingMode;
import edu.cornell.gdiac.util.ScreenListener;

public class GDXRoot
extends Game
implements ScreenListener {
    AssetDirectory directory;
    private GameCanvas canvas;
    private LoadingMode loading;
    private GameMode playing;

    public void create() {
        this.canvas = new GameCanvas();
        this.loading = new LoadingMode("assets.json", this.canvas, 1);
        this.playing = new GameMode(this.canvas);
        this.loading.setScreenListener(this);
        this.setScreen(this.loading);
    }

    public void dispose() {
        Screen screen = this.getScreen();
        this.setScreen(null);
        screen.dispose();
        this.canvas.dispose();
        this.canvas = null;
        if (this.directory != null) {
            this.directory.unloadAssets();
            this.directory.dispose();
            this.directory = null;
        }
        super.dispose();
    }

    public void resize(int width, int height) {
        this.canvas.resize();
        super.resize(width, height);
    }

    @Override
    public void exitScreen(Screen screen, int exitCode) {
        if (exitCode != 0) {
            Gdx.app.error("GDXRoot", "Exit with error code " + exitCode, (Throwable)new RuntimeException());
            Gdx.app.exit();
        } else if (screen == this.loading) {
            this.playing.setScreenListener(this);
            this.directory = this.loading.getAssets();
            this.playing.populate(this.directory);
            this.setScreen(this.playing);
            this.loading.dispose();
            this.loading = null;
        } else {
            Gdx.app.exit();
        }
    }
}

