/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.optimize;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.optimize.GameObject;
import edu.cornell.gdiac.optimize.entity.Bullet;
import edu.cornell.gdiac.optimize.entity.Shell;
import edu.cornell.gdiac.optimize.entity.Ship;
import edu.cornell.gdiac.optimize.entity.Star;

public class CollisionController {
    protected static final float BOX_COEFF_REST = 0.95f;
    protected static final float BUMP_COEFF_REST = 1.95f;
    protected static final float DAMPENING_FACTOR = 0.95f;
    protected static final float BOTTOM_OFFSET = 0.075f;
    protected static final float BOX_X_POSITION = 0.141f;
    protected static final float BOX_HALF_WIDTH = 0.133f;
    protected static final float BOX_FULL_HEIGHT = 0.2f;
    protected static final float BUMP_X_POSITION = 0.734f;
    protected static final float BUMP_RADIUS = 0.11f;
    private float width;
    private float height;
    private Vector2 temp1;
    private Vector2 temp2;

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getFloorLedge() {
        return 0.075f * this.height;
    }

    public float getBoxX() {
        return 0.141f * this.width;
    }

    public float getBoxRadius() {
        return 0.133f * this.width;
    }

    public float getBoxHeight() {
        return 0.2f * this.height;
    }

    protected float getBumpX() {
        return 0.734f * this.width;
    }

    protected float getBumpRadius() {
        return 0.11f * this.width;
    }

    public CollisionController(float width, float height) {
        this.width = width;
        this.height = height;
        this.temp1 = new Vector2();
        this.temp2 = new Vector2();
    }

    public void processCollisions(Array<GameObject> objects, int offset) {
        for (GameObject o : objects) {
            this.processBounds(o, offset);
            for (int ii = 0; ii < objects.size; ++ii) {
                if (objects.get(ii) == o) continue;
                this.processCollision(o, (GameObject)objects.get(ii));
            }
        }
    }

    private void processBounds(GameObject o, int offset) {
        switch (o.getType()) {
            case SHELL: {
                this.handleBounds((Shell)o, offset);
                break;
            }
            case STAR: {
                this.handleBounds((Star)o);
                break;
            }
            case BULLET: {
                this.handleBounds((Bullet)o);
                break;
            }
            case SHIP: {
                this.handleBounds((Ship)o);
                break;
            }
        }
    }

    private void handleBounds(Shell sh, int offset) {
        this.hitBox(sh, (float)offset + this.getBoxX() - this.getWidth());
        this.hitBox(sh, (float)offset + this.getBoxX());
        this.hitBox(sh, (float)offset + this.getBoxX() + this.getWidth());
        this.hitBump(sh, (float)offset + this.getBumpX() - this.getWidth());
        this.hitBump(sh, (float)offset + this.getBumpX());
        this.hitBump(sh, (float)offset + this.getBumpX() + this.getWidth());
        if (sh.getX() > this.getWidth() - sh.getRadius()) {
            sh.setX(2.0f * (this.getWidth() - sh.getRadius()) - sh.getX());
            sh.setVX(-sh.getVX());
        } else if (sh.getX() < sh.getRadius()) {
            sh.setX(2.0f * sh.getRadius() - sh.getX());
            sh.setVX(-sh.getVX());
        }
        if (sh.getY() - sh.getRadius() < this.getFloorLedge()) {
            sh.setY(this.getFloorLedge() + sh.getRadius());
            sh.setVY(-sh.getVY());
            sh.setVY(Math.max(sh.getMinVY(), sh.getVY() * sh.getFriction()));
        }
    }

    private void handleBounds(Star st) {
    }

    private void handleBounds(Bullet bu) {
        if (bu.getY() <= 0.0f) {
            bu.setDestroyed(true);
        }
    }

    private void handleBounds(Ship sh) {
        if (sh.getX() <= sh.getRadius()) {
            sh.setX(sh.getRadius());
        } else if (sh.getX() >= this.getWidth() - sh.getRadius()) {
            sh.setX(this.getWidth() - sh.getRadius());
        }
    }

    private void hitBox(GameObject o, float x) {
        if (Math.abs(o.getX() - x) < this.getBoxRadius() && o.getY() < this.getBoxHeight()) {
            if (o.getX() + o.getRadius() > x + this.getBoxRadius()) {
                o.setX(x + this.getBoxRadius() + o.getRadius());
                o.setVX(-o.getVX());
            } else if (o.getX() - o.getRadius() < x - this.getBoxRadius()) {
                o.setX(x - this.getBoxRadius() - o.getRadius());
                o.setVX(-o.getVX());
            } else {
                o.setVY(-o.getVY() * 0.95f);
                o.setY(this.getBoxHeight() + o.getRadius());
            }
        }
    }

    public void hitBump(GameObject o, float x) {
        float dy;
        float dx = o.getX() - x;
        float dist = (float)Math.sqrt(dx * dx + (dy = o.getY() - this.getFloorLedge()) * dy);
        if (dist < 0.1f * this.width) {
            float norm_x = dx / dist;
            float norm_y = Math.abs(dy / dist);
            float tmp = (o.getVX() * norm_x + o.getVY() * norm_y) * 1.95f;
            o.getVelocity().sub(norm_x * tmp, norm_y * tmp);
            o.setY(this.getFloorLedge() + norm_y * this.getBumpRadius());
        }
    }

    private void processCollision(GameObject o1, GameObject o2) {
        block0 : switch (o1.getType()) {
            case SHELL: {
                switch (o2.getType()) {
                    case SHELL: {
                        this.handleCollision((Shell)o1, (Shell)o2);
                        break block0;
                    }
                    case STAR: {
                        this.handleCollision((Shell)o1, (Star)o2);
                        break block0;
                    }
                    case BULLET: {
                        this.handleCollision((Shell)o1, (Bullet)o2);
                        break block0;
                    }
                    case SHIP: {
                        this.handleCollision((Shell)o1, (Ship)o2);
                        break block0;
                    }
                }
                break;
            }
            case STAR: {
                switch (o2.getType()) {
                    case SHELL: {
                        this.handleCollision((Shell)o2, (Star)o1);
                        break block0;
                    }
                    case STAR: {
                        this.handleCollision((Star)o1, (Star)o2);
                        break block0;
                    }
                    case BULLET: {
                        this.handleCollision((Star)o1, (Bullet)o2);
                        break block0;
                    }
                    case SHIP: {
                        this.handleCollision((Star)o1, (Ship)o2);
                        break block0;
                    }
                }
                break;
            }
            case BULLET: {
                switch (o2.getType()) {
                    case SHELL: {
                        this.handleCollision((Shell)o2, (Bullet)o1);
                        break block0;
                    }
                    case STAR: {
                        this.handleCollision((Star)o2, (Bullet)o1);
                        break block0;
                    }
                    case BULLET: {
                        this.handleCollision((Bullet)o1, (Bullet)o2);
                        break block0;
                    }
                    case SHIP: {
                        this.handleCollision((Bullet)o1, (Ship)o2);
                        break block0;
                    }
                }
                break;
            }
            case SHIP: {
                switch (o2.getType()) {
                    case SHELL: {
                        this.handleCollision((Shell)o2, (Ship)o1);
                        break block0;
                    }
                    case STAR: {
                        this.handleCollision((Star)o2, (Ship)o1);
                        break block0;
                    }
                    case BULLET: {
                        this.handleCollision((Bullet)o2, (Ship)o1);
                        break block0;
                    }
                    case SHIP: {
                        this.handleCollision((Ship)o1, (Ship)o2);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void handleCollision(Shell s1, Shell s2) {
        if (s1.isDestroyed() || s2.isDestroyed()) {
            return;
        }
        this.temp1.set(s1.getPosition()).sub(s2.getPosition());
        float dist = this.temp1.len();
        if (dist > s1.getRadius() + s2.getRadius()) {
            return;
        }
        float distToPush = 0.01f + (s1.getRadius() + s2.getRadius() - dist) / 2.0f;
        this.temp1.nor();
        this.temp1.scl(distToPush);
        s1.getPosition().add(this.temp1);
        s2.getPosition().sub(this.temp1);
        this.temp1.set(s2.getPosition()).sub(s1.getPosition()).nor();
        this.temp2.set(s1.getPosition()).sub(s2.getPosition()).nor();
        this.temp1.scl(this.temp1.dot(s1.getVelocity()));
        this.temp2.scl(this.temp2.dot(s2.getVelocity()));
        s1.getVelocity().sub(this.temp1).add(this.temp2);
        s2.getVelocity().sub(this.temp2).add(this.temp1);
    }

    private void handleCollision(Shell se, Star st) {
        if (se.isDestroyed() || st.isDestroyed()) {
            return;
        }
        this.temp1.set(se.getPosition()).sub(st.getPosition());
        float dist = this.temp1.len();
        if (dist > se.getRadius() + st.getRadius()) {
            return;
        }
        this.temp1.nor();
        float dot = this.temp1.dot(se.getVelocity());
        this.temp1.scl(dot);
        se.getVelocity().sub(this.temp1.scl(1.95f));
        se.setDestroyed(true);
        st.setDestroyed(true);
    }

    private void handleCollision(Shell se, Bullet bu) {
        if (se.isDestroyed() || bu.isDestroyed()) {
            return;
        }
        this.temp1.set(se.getPosition()).sub(bu.getPosition());
        float dist = this.temp1.len();
        if (dist > se.getRadius() + bu.getRadius()) {
            return;
        }
        this.temp1.nor();
        float dot = this.temp1.dot(se.getVelocity());
        this.temp1.scl(dot);
        se.getVelocity().sub(this.temp1.scl(1.95f));
        se.setDestroyed(true);
        bu.setDestroyed(true);
    }

    private void handleCollision(Shell se, Ship sh) {
        if (se.isDestroyed() || sh.isDestroyed()) {
            return;
        }
        this.temp1.set(se.getPosition()).sub(sh.getPosition());
        float dist = this.temp1.len();
        if (dist > se.getRadius() + sh.getRadius()) {
            return;
        }
        se.setDestroyed(true);
        sh.setDestroyed(true);
    }

    private void handleCollision(Star s1, Star s2) {
    }

    private void handleCollision(Star st, Bullet bu) {
    }

    private void handleCollision(Star st, Ship sh) {
    }

    private void handleCollision(Bullet b1, Bullet b2) {
    }

    private void handleCollision(Bullet bu, Ship sh) {
    }

    private void handleCollision(Ship s1, Ship s2) {
    }
}

