/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;

public class ResourceManager {
    private static ResourceManager instance = null;
    final ObjectMap<Class, ObjectMap<String, Disposable>> resources = new ObjectMap();
    final ObjectMap<String, Class> resourceTypes = new ObjectMap();

    private ResourceManager() {
    }

    public void finalize() throws Throwable {
        this.clear();
    }

    public static ResourceManager get() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public static void dispose() {
        if (instance != null) {
            instance.clear();
            instance = null;
        }
    }

    public synchronized <T> T get(String key) {
        Class type = (Class)this.resourceTypes.get((Object)key);
        if (type == null) {
            throw new GdxRuntimeException(String.format("Resource '%s' is not active.", key));
        }
        ObjectMap rsrcByType = (ObjectMap)this.resources.get((Object)type);
        if (rsrcByType == null) {
            throw new GdxRuntimeException(String.format("Resource '%s' is not active.", key));
        }
        Object resource = rsrcByType.get((Object)key);
        if (resource == null) {
            throw new GdxRuntimeException(String.format("Resource '%s' is not active.", key));
        }
        return (T)resource;
    }

    public synchronized <T> T get(String key, Class<T> type) {
        ObjectMap rsrcByType = (ObjectMap)this.resources.get(type);
        if (rsrcByType == null) {
            throw new GdxRuntimeException(String.format("Resource '%s' is not active.", key));
        }
        Object resource = rsrcByType.get((Object)key);
        if (resource == null) {
            throw new GdxRuntimeException(String.format("Resource '%s' is not active.", key));
        }
        return (T)resource;
    }

    public synchronized <T> String getKey(T resource) {
        for (Class rsrcType : this.resources.keys()) {
            ObjectMap rsrcByType = (ObjectMap)this.resources.get((Object)rsrcType);
            for (String key : rsrcByType.keys()) {
                Object other = rsrcByType.get((Object)key);
                if (other != resource && !resource.equals(other)) continue;
                return key;
            }
        }
        return null;
    }

    public synchronized <T> Array<T> getAll(Class<T> type, Array<T> out) {
        ObjectMap rsrcByType = (ObjectMap)this.resources.get(type);
        if (rsrcByType != null) {
            for (ObjectMap.Entry resource : rsrcByType.entries()) {
                out.add(resource.value);
            }
        }
        return out;
    }

    public synchronized boolean contains(String key) {
        if (key == null) {
            return false;
        }
        return this.resourceTypes.containsKey((Object)key);
    }

    public synchronized boolean contains(String key, Class type) {
        ObjectMap resourcesByType = (ObjectMap)this.resources.get((Object)type);
        if (resourcesByType == null) {
            return false;
        }
        return resourcesByType.get((Object)key) != null;
    }

    public synchronized <T> boolean contains(T resource) {
        ObjectMap rsrcByType = (ObjectMap)this.resources.get(resource.getClass());
        if (rsrcByType == null) {
            return false;
        }
        for (String key : rsrcByType.keys()) {
            Object other = rsrcByType.get((Object)key);
            if (other != resource && !resource.equals(other)) continue;
            return true;
        }
        return false;
    }

    public synchronized void dispose(String key) {
        Class type = (Class)this.resourceTypes.get((Object)key);
        if (type == null) {
            throw new GdxRuntimeException(String.format("Pipeline resource '%s' not active.", key));
        }
        ObjectMap resourcesByType = (ObjectMap)this.resources.get((Object)type);
        if (resourcesByType == null) {
            throw new GdxRuntimeException(String.format("Pipeline resource '%s' not active.", key));
        }
        Disposable resource = (Disposable)resourcesByType.get((Object)key);
        if (resource == null) {
            throw new GdxRuntimeException(String.format("Pipeline resource '%s' not active.", key));
        }
        resource.dispose();
        resourcesByType.remove((Object)key);
    }

    public synchronized void dispose(String key, Class type) {
        ObjectMap resourcesByType = (ObjectMap)this.resources.get((Object)type);
        if (resourcesByType == null) {
            throw new GdxRuntimeException(String.format("Pipeline resource '%s' not active.", key));
        }
        Disposable resource = (Disposable)resourcesByType.get((Object)key);
        if (resource == null) {
            throw new GdxRuntimeException(String.format("Pipeline resource '%s' not active.", key));
        }
        resource.dispose();
        resourcesByType.remove((Object)key);
    }

    public synchronized <T> void dispose(T resource) {
        String key = this.getKey(resource);
        this.dispose(key);
    }

    public synchronized void clear() {
        for (ObjectMap resourcesByType : this.resources.values()) {
            for (Disposable resource : resourcesByType.values()) {
                resource.dispose();
            }
        }
        this.resources.clear();
        this.resourceTypes.clear();
    }

    public synchronized <T> T remove(String key) {
        Class type = (Class)this.resourceTypes.get((Object)key);
        if (type == null) {
            throw new GdxRuntimeException(String.format("Pipeline resource '%s' not active.", key));
        }
        ObjectMap resourcesByType = (ObjectMap)this.resources.get((Object)type);
        if (resourcesByType == null) {
            throw new GdxRuntimeException(String.format("Pipeline resource '%s' not active.", key));
        }
        Disposable resource = (Disposable)resourcesByType.get((Object)key);
        if (resource == null) {
            throw new GdxRuntimeException(String.format("Pipeline resource '%s' not active.", key));
        }
        resourcesByType.remove((Object)key);
        return (T)resource;
    }

    public synchronized <T> T remove(String key, Class type) {
        ObjectMap resourcesByType = (ObjectMap)this.resources.get((Object)type);
        if (resourcesByType == null) {
            throw new GdxRuntimeException(String.format("Pipeline resource '%s' not active.", key));
        }
        Disposable resource = (Disposable)resourcesByType.get((Object)key);
        if (resource == null) {
            throw new GdxRuntimeException(String.format("Pipeline resource '%s' not active.", key));
        }
        resourcesByType.remove((Object)key);
        return (T)resource;
    }

    public synchronized <T> T remove(T resource) {
        String key = this.getKey(resource);
        return (T)this.remove((T)key);
    }

    public <T> void add(String key, Class<T> type, T resource) {
        this.resourceTypes.put((Object)key, type);
        ObjectMap typeToRsrc = (ObjectMap)this.resources.get(type);
        if (typeToRsrc == null) {
            typeToRsrc = new ObjectMap();
            this.resources.put(type, (Object)typeToRsrc);
        }
        typeToRsrc.put((Object)key, (Object)((Disposable)resource));
    }
}

