/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.utils.JsonValue;

public class ParserUtils {
    public static Color parseColor(JsonValue json, Color defaultColor) {
        if (json == null) {
            return defaultColor;
        }
        if (json.size > 0) {
            Color result = new Color();
            result.r = json.getFloat(0);
            result.g = json.size > 1 ? json.getFloat(1) : 0.0f;
            result.b = json.size > 2 ? json.getFloat(2) : 0.0f;
            result.a = json.size > 3 ? json.getFloat(3) : 1.0f;
            return result;
        }
        String code = json.asString();
        if (code != null && code.length() > 0) {
            if (code.charAt(0) == '#') {
                return Color.valueOf((String)code);
            }
            try {
                return (Color)Color.class.getField(code.toUpperCase()).get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultColor;
    }

    public static Texture.TextureFilter parseFilter(JsonValue json, Texture.TextureFilter defaultFilter) {
        if (json == null || json.asString() == null) {
            return defaultFilter;
        }
        String filter = json.asString().toLowerCase();
        if (filter.equals("linear")) {
            return Texture.TextureFilter.Linear;
        }
        if (filter.equals("nearest")) {
            return Texture.TextureFilter.Nearest;
        }
        if (filter.equals("nearest mipmap nearest")) {
            return Texture.TextureFilter.MipMapNearestNearest;
        }
        if (filter.equals("linear mipmap nearest")) {
            return Texture.TextureFilter.MipMapLinearNearest;
        }
        if (filter.equals("nearest mipmap linear")) {
            return Texture.TextureFilter.MipMapNearestLinear;
        }
        if (filter.equals("linear mipmap linear")) {
            return Texture.TextureFilter.MipMapLinearLinear;
        }
        return defaultFilter;
    }

    public static Texture.TextureWrap parseWrap(JsonValue json, Texture.TextureWrap defaultWrap) {
        if (json == null || json.asString() == null) {
            return defaultWrap;
        }
        String wrapper = json.asString().toLowerCase();
        if (wrapper.equals("clamped")) {
            return Texture.TextureWrap.ClampToEdge;
        }
        if (wrapper.equals("mirrored")) {
            return Texture.TextureWrap.MirroredRepeat;
        }
        if (wrapper.equals("repeated")) {
            return Texture.TextureWrap.Repeat;
        }
        return defaultWrap;
    }

    public static FreeTypeFontGenerator.Hinting parseHinting(JsonValue json, FreeTypeFontGenerator.Hinting defaultHinting) {
        if (json == null || json.asString() == null) {
            return defaultHinting;
        }
        String hinting = json.asString().toLowerCase();
        if (hinting.equals("auto medium")) {
            return FreeTypeFontGenerator.Hinting.AutoMedium;
        }
        if (hinting.equals("auto full")) {
            return FreeTypeFontGenerator.Hinting.AutoFull;
        }
        if (hinting.equals("auto slight")) {
            return FreeTypeFontGenerator.Hinting.AutoSlight;
        }
        if (hinting.equals("medium")) {
            return FreeTypeFontGenerator.Hinting.Medium;
        }
        if (hinting.equals("full")) {
            return FreeTypeFontGenerator.Hinting.Full;
        }
        if (hinting.equals("slight")) {
            return FreeTypeFontGenerator.Hinting.Slight;
        }
        if (hinting.equals("none")) {
            return FreeTypeFontGenerator.Hinting.None;
        }
        return defaultHinting;
    }
}

