/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.util;

import com.badlogic.gdx.utils.Pool;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class PooledList<E>
extends AbstractSequentialList<E>
implements Iterable<E> {
    private Pool<Entry> memory;
    private Entry head = null;
    private Entry tail = null;
    private int size = 0;
    private ValueIterator values = new ValueIterator();
    private EntryIterator entries = new EntryIterator();

    public PooledList() {
        this.memory = new EntryPool();
    }

    @Override
    public int size() {
        return this.size;
    }

    public E poll() {
        return this.removeHead();
    }

    public E pop() {
        return this.removeTail();
    }

    public boolean push(E e) {
        return this.add(e);
    }

    public E getHead() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException();
        }
        return (E)this.head.value;
    }

    public E getTail() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException();
        }
        return (E)this.tail.value;
    }

    public E removeHead() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException();
        }
        Entry last = this.head;
        Object value = this.head.value;
        this.head = this.head.next;
        if (this.size > 1) {
            this.head.prev = null;
        }
        --this.size;
        this.memory.free((Object)last);
        return (E)value;
    }

    public E removeTail() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException();
        }
        Entry last = this.tail;
        Object value = this.tail.value;
        this.tail = this.tail.prev;
        if (this.size > 1) {
            this.tail.next = null;
        }
        --this.size;
        this.memory.free((Object)last);
        return (E)value;
    }

    @Override
    public boolean add(E e) {
        Entry entry = (Entry)this.memory.obtain();
        if (entry == null) {
            return false;
        }
        entry.value = e;
        entry.prev = this.tail;
        if (this.size > 0) {
            this.tail.next = entry;
        } else {
            this.head = entry;
        }
        this.tail = entry;
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Entry entry = (Entry)this.memory.obtain();
        if (entry == null) {
            return;
        }
        entry.value = element;
        if (index == 0) {
            entry.next = this.head;
            if (this.size > 0) {
                this.head.prev = entry;
            } else {
                this.tail = entry;
            }
            this.head = entry;
        } else if (index == this.size) {
            entry.prev = this.tail;
            if (this.size > 0) {
                this.tail.next = entry;
            } else {
                this.head = entry;
            }
            this.tail = entry;
        } else {
            Entry curr = this.head;
            for (int ii = 1; ii < index; ++ii) {
                curr = curr.next;
            }
            curr.prev.next = entry;
            entry.prev = curr.prev;
            curr.prev = entry;
            entry.next = curr;
        }
        ++this.size;
    }

    @Override
    public E get(int index) {
        if (index == 0) {
            return (E)this.head.value;
        }
        if (index == this.size - 1) {
            return (E)this.tail.value;
        }
        Entry curr = this.head;
        for (int ii = 1; ii < index; ++ii) {
            curr = curr.next;
        }
        return (E)curr.value;
    }

    @Override
    public E remove(int index) {
        Object value;
        Entry last;
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            last = this.head;
            value = last.value;
            this.head = this.head.next;
            if (this.size > 1) {
                this.head.prev = null;
            }
        } else if (index == this.size) {
            last = this.tail;
            value = last.value;
            this.tail = this.tail.prev;
            if (this.size > 1) {
                this.tail.next = null;
            }
        } else {
            Entry curr = this.head;
            for (int ii = 1; ii < index; ++ii) {
                curr = curr.next;
            }
            last = curr;
            value = last.value;
            curr.prev.next = curr.next;
            curr.next.prev = curr.prev;
        }
        --this.size;
        this.memory.free((Object)last);
        return (E)value;
    }

    @Override
    public E set(int index, E element) {
        Object value;
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            value = this.head.value;
            this.head.value = element;
        } else if (index == this.size) {
            value = this.tail.value;
            this.tail.value = element;
        } else {
            Entry curr = this.head;
            for (int ii = 1; ii < index; ++ii) {
                curr = curr.next;
            }
            value = curr.value;
            curr.value = element;
        }
        return (E)value;
    }

    @Override
    public Iterator<E> iterator() {
        this.values.reset();
        return this.values;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.values.reset(index);
        return this.values;
    }

    public Iterator<Entry> entryIterator() {
        this.entries.reset();
        return this.entries;
    }

    private class EntryIterator
    implements ListIterator<Entry> {
        private Entry next;
        private Entry last;

        public EntryIterator() {
            this.reset();
        }

        public void reset() {
            this.next = PooledList.this.head;
            this.last = null;
        }

        @Override
        public void add(Entry entry) {
            if (this.next == PooledList.this.head) {
                entry.next = PooledList.this.head;
                if (this.next != null) {
                    this.next.prev = entry;
                }
                PooledList.this.head = entry;
                this.next = PooledList.this.head;
            } else if (this.next != null) {
                this.next.prev.next = entry;
                entry.prev = this.next.prev;
                entry.next = this.next;
                this.next.prev = entry;
            } else {
                entry.prev = PooledList.this.tail;
                if (PooledList.this.tail != null) {
                    PooledList.this.tail.next = entry;
                }
                PooledList.this.tail = entry;
            }
            PooledList.this.size++;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.next != null && this.next.prev != null;
        }

        @Override
        public Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = this.next.next;
            return this.last;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry curr = PooledList.this.head;
            int index = 0;
            while (curr != this.next) {
                curr = curr.next;
                ++index;
            }
            return index;
        }

        @Override
        public Entry previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.last = this.next = this.next.prev;
            return this.next;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Entry curr = PooledList.this.head;
            int index = 0;
            while (curr != this.next.prev) {
                curr = curr.next;
                ++index;
            }
            return index;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            if (this.last.prev == null) {
                PooledList.this.head = this.last.next;
                if (PooledList.this.head != null) {
                    PooledList.this.head.prev = null;
                }
            } else {
                this.last.prev.next = this.last.next;
            }
            if (this.last.next == null) {
                PooledList.this.tail = this.last.prev;
                if (PooledList.this.tail != null) {
                    PooledList.this.tail.next = null;
                }
            } else {
                this.last.next.prev = this.last.prev;
            }
            PooledList.this.memory.free((Object)this.last);
            this.last = null;
            PooledList.this.size--;
        }

        @Override
        public void set(Entry entry) {
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            entry.prev = this.last.prev;
            entry.next = this.last.next;
            if (this.last.prev != null) {
                this.last.prev.next = entry;
            } else {
                PooledList.this.head = this.last;
            }
            if (this.last.next != null) {
                this.last.next.prev = entry;
            } else {
                PooledList.this.tail = this.last;
            }
            PooledList.this.memory.free((Object)this.last);
            this.last = entry;
        }
    }

    private class ValueIterator
    implements ListIterator<E> {
        private Entry next;
        private Entry last;

        public ValueIterator() {
            this.reset();
        }

        public void reset() {
            this.next = PooledList.this.head;
            this.last = null;
        }

        public void reset(int index) {
            if (index > PooledList.this.size) {
                throw new IndexOutOfBoundsException();
            }
            this.last = null;
            this.next = PooledList.this.head;
            for (int ii = 1; ii < index; ++ii) {
                this.next = this.next.next;
            }
        }

        @Override
        public void add(E e) {
            Entry entry = (Entry)PooledList.this.memory.obtain();
            if (entry == null) {
                return;
            }
            entry.value = e;
            if (this.next == PooledList.this.head) {
                entry.next = PooledList.this.head;
                if (this.next != null) {
                    this.next.prev = entry;
                }
                PooledList.this.head = entry;
                this.next = PooledList.this.head;
            } else if (this.next != null) {
                this.next.prev.next = entry;
                entry.prev = this.next.prev;
                entry.next = this.next;
                this.next.prev = entry;
            } else {
                entry.prev = PooledList.this.tail;
                if (PooledList.this.tail != null) {
                    PooledList.this.tail.next = entry;
                }
                PooledList.this.tail = entry;
            }
            PooledList.this.size++;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.next != null && this.next.prev != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = this.next.next;
            return this.last.value;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry curr = PooledList.this.head;
            int index = 0;
            while (curr != this.next) {
                curr = curr.next;
                ++index;
            }
            return index;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.last = this.next = this.next.prev;
            return this.next.value;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Entry curr = PooledList.this.head;
            int index = 0;
            while (curr != this.next.prev) {
                curr = curr.next;
                ++index;
            }
            return index;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            if (this.last.prev == null) {
                PooledList.this.head = this.last.next;
                if (PooledList.this.head != null) {
                    PooledList.this.head.prev = null;
                }
            } else {
                this.last.prev.next = this.last.next;
            }
            if (this.last.next == null) {
                PooledList.this.tail = this.last.prev;
                if (PooledList.this.tail != null) {
                    PooledList.this.tail.next = null;
                }
            } else {
                this.last.next.prev = this.last.prev;
            }
            PooledList.this.memory.free((Object)this.last);
            this.last = null;
            PooledList.this.size--;
        }

        @Override
        public void set(E e) {
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            this.last.value = e;
        }
    }

    private class EntryPool
    extends Pool<Entry> {
        protected Entry newObject() {
            return new Entry();
        }
    }

    public class Entry
    implements Pool.Poolable {
        private E value;
        private Entry next;
        private Entry prev;

        public Entry() {
            this.reset();
        }

        public E getValue() {
            return this.value;
        }

        public void remove() {
            if (this.prev != null) {
                this.prev.next = this.next;
            } else {
                PooledList.this.head = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            } else {
                PooledList.this.tail = this.prev;
            }
            PooledList.this.size--;
            PooledList.this.memory.free((Object)this);
        }

        public void reset() {
            this.value = null;
            this.next = null;
            this.prev = null;
        }
    }
}

