/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class FilmStrip
extends TextureRegion {
    private int rows;
    private int cols;
    private int fwidth;
    private int fheight;
    private int x;
    private int y;
    private int width;
    private int height;
    private int size;
    private int frame;

    public FilmStrip(Texture texture, int rows, int cols) {
        this(texture, rows, cols, rows * cols);
    }

    public FilmStrip(Texture texture, int rows, int cols, int size) {
        this(texture, rows, cols, size, 0, 0, texture.getWidth(), texture.getHeight());
    }

    public FilmStrip(Texture texture, int rows, int cols, int size, int x, int y, int width, int height) {
        super(texture);
        if (size > rows * cols) {
            Gdx.app.error("FilmStrip", "Invalid strip size", (Throwable)new IllegalArgumentException());
            return;
        }
        this.rows = rows;
        this.cols = cols;
        this.size = size;
        this.width = width;
        this.height = height;
        this.fwidth = width / cols;
        this.fheight = height / rows;
        this.setFrame(0);
    }

    public int getSize() {
        return this.size;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        if (frame < 0 || frame >= this.size) {
            Gdx.app.error("FilmStrip", "Invalid animation frame", (Throwable)new IllegalArgumentException());
            return;
        }
        this.frame = frame;
        int x = this.x + frame % this.cols * this.fwidth;
        int y = this.y + frame / this.cols * this.fheight;
        this.setRegion(x, y, this.fwidth, this.fheight);
    }

    public FilmStrip copy() {
        return new FilmStrip(this.getTexture(), this.rows, this.cols, this.size);
    }
}

