/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics.obstacle;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import edu.cornell.gdiac.physics.obstacle.ObstacleCanvas;
import edu.cornell.gdiac.physics.obstacle.SimpleObstacle;

public class WheelObstacle
extends SimpleObstacle {
    protected CircleShape shape;
    private Fixture geometry;
    private Color debugColor = Color.YELLOW;

    public float getRadius() {
        return this.shape.getRadius();
    }

    public void setRadius(float value) {
        this.shape.setRadius(value);
        this.markDirty(true);
    }

    public Color getDebugColor() {
        return this.debugColor;
    }

    public void setDebugColor(Color value) {
        this.debugColor = value;
    }

    public WheelObstacle(float radius) {
        this(0.0f, 0.0f, radius);
    }

    public WheelObstacle(float x, float y, float radius) {
        super(x, y);
        this.shape = new CircleShape();
        this.shape.setRadius(radius);
    }

    @Override
    public void dispose() {
        if (this.shape != null) {
            this.shape.dispose();
            this.shape = null;
        }
    }

    @Override
    protected void createFixtures() {
        if (this.body == null) {
            return;
        }
        this.releaseFixtures();
        this.fixture.shape = this.shape;
        this.geometry = this.body.createFixture(this.fixture);
        this.markDirty(false);
    }

    @Override
    protected void releaseFixtures() {
        if (this.geometry != null) {
            this.body.destroyFixture(this.geometry);
            this.geometry = null;
        }
    }

    @Override
    public void drawDebug(ObstacleCanvas canvas) {
        if (this.debugColor != null) {
            canvas.drawPhysics(this.shape, this.debugColor, this.getX(), this.getY(), this.drawScale.x, this.drawScale.y);
        }
    }
}

