/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics.obstacle;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.World;
import edu.cornell.gdiac.physics.obstacle.Obstacle;
import edu.cornell.gdiac.physics.obstacle.ObstacleCanvas;

public abstract class SimpleObstacle
extends Obstacle {
    protected Body body = null;
    protected TextureRegion texture;
    protected Vector2 origin = new Vector2();

    @Override
    public BodyDef.BodyType getBodyType() {
        return this.body != null ? this.body.getType() : super.getBodyType();
    }

    @Override
    public void setBodyType(BodyDef.BodyType value) {
        if (this.body != null) {
            this.body.setType(value);
        } else {
            super.setBodyType(value);
        }
    }

    @Override
    public Vector2 getPosition() {
        return this.body != null ? this.body.getPosition() : super.getPosition();
    }

    @Override
    public void setPosition(Vector2 value) {
        if (this.body != null) {
            this.body.setTransform(value, this.body.getAngle());
        } else {
            super.setPosition(value);
        }
    }

    @Override
    public void setPosition(float x, float y) {
        if (this.body != null) {
            this.positionCache.set(x, y);
            this.body.setTransform(this.positionCache, this.body.getAngle());
        } else {
            super.setPosition(x, y);
        }
    }

    @Override
    public float getX() {
        return this.body != null ? this.body.getPosition().x : super.getX();
    }

    @Override
    public void setX(float value) {
        if (this.body != null) {
            this.positionCache.set(value, this.body.getPosition().y);
            this.body.setTransform(this.positionCache, this.body.getAngle());
        } else {
            super.setX(value);
        }
    }

    @Override
    public float getY() {
        return this.body != null ? this.body.getPosition().y : super.getY();
    }

    @Override
    public void setY(float value) {
        if (this.body != null) {
            this.positionCache.set(this.body.getPosition().x, value);
            this.body.setTransform(this.positionCache, this.body.getAngle());
        } else {
            super.setY(value);
        }
    }

    @Override
    public float getAngle() {
        return this.body != null ? this.body.getAngle() : super.getAngle();
    }

    @Override
    public void setAngle(float value) {
        if (this.body != null) {
            this.body.setTransform(this.body.getPosition(), value);
        } else {
            super.setAngle(value);
        }
    }

    @Override
    public Vector2 getLinearVelocity() {
        return this.body != null ? this.body.getLinearVelocity() : super.getLinearVelocity();
    }

    @Override
    public void setLinearVelocity(Vector2 value) {
        if (this.body != null) {
            this.body.setLinearVelocity(value);
        } else {
            super.setLinearVelocity(value);
        }
    }

    @Override
    public float getVX() {
        return this.body != null ? this.body.getLinearVelocity().x : super.getVX();
    }

    @Override
    public void setVX(float value) {
        if (this.body != null) {
            this.velocityCache.set(value, this.body.getLinearVelocity().y);
            this.body.setLinearVelocity(this.velocityCache);
        } else {
            super.setVX(value);
        }
    }

    @Override
    public float getVY() {
        return this.body != null ? this.body.getLinearVelocity().y : super.getVY();
    }

    @Override
    public void setVY(float value) {
        if (this.body != null) {
            this.velocityCache.set(this.body.getLinearVelocity().x, value);
            this.body.setLinearVelocity(this.velocityCache);
        } else {
            super.setVY(value);
        }
    }

    @Override
    public float getAngularVelocity() {
        return this.body != null ? this.body.getAngularVelocity() : super.getAngularVelocity();
    }

    @Override
    public void setAngularVelocity(float value) {
        if (this.body != null) {
            this.body.setAngularVelocity(value);
        } else {
            super.setAngularVelocity(value);
        }
    }

    @Override
    public boolean isActive() {
        return this.body != null ? this.body.isActive() : super.isActive();
    }

    @Override
    public void setActive(boolean value) {
        if (this.body != null) {
            this.body.setActive(value);
        } else {
            super.setActive(value);
        }
    }

    @Override
    public boolean isAwake() {
        return this.body != null ? this.body.isAwake() : super.isAwake();
    }

    @Override
    public void setAwake(boolean value) {
        if (this.body != null) {
            this.body.setAwake(value);
        } else {
            super.setAwake(value);
        }
    }

    @Override
    public boolean isSleepingAllowed() {
        return this.body != null ? this.body.isSleepingAllowed() : super.isSleepingAllowed();
    }

    @Override
    public void setSleepingAllowed(boolean value) {
        if (this.body != null) {
            this.body.setSleepingAllowed(value);
        } else {
            super.setSleepingAllowed(value);
        }
    }

    @Override
    public boolean isBullet() {
        return this.body != null ? this.body.isBullet() : super.isBullet();
    }

    @Override
    public void setBullet(boolean value) {
        if (this.body != null) {
            this.body.setBullet(value);
        } else {
            super.setBullet(value);
        }
    }

    @Override
    public boolean isFixedRotation() {
        return this.body != null ? this.body.isFixedRotation() : super.isFixedRotation();
    }

    @Override
    public void setFixedRotation(boolean value) {
        if (this.body != null) {
            this.body.setFixedRotation(value);
        } else {
            super.setFixedRotation(value);
        }
    }

    @Override
    public float getGravityScale() {
        return this.body != null ? this.body.getGravityScale() : super.getGravityScale();
    }

    @Override
    public void setGravityScale(float value) {
        if (this.body != null) {
            this.body.setGravityScale(value);
        } else {
            super.setGravityScale(value);
        }
    }

    @Override
    public float getLinearDamping() {
        return this.body != null ? this.body.getLinearDamping() : super.getLinearDamping();
    }

    @Override
    public void setLinearDamping(float value) {
        if (this.body != null) {
            this.body.setLinearDamping(value);
        } else {
            super.setLinearDamping(value);
        }
    }

    @Override
    public float getAngularDamping() {
        return this.body != null ? this.body.getAngularDamping() : super.getAngularDamping();
    }

    @Override
    public void setAngularDamping(float value) {
        if (this.body != null) {
            this.body.setAngularDamping(value);
        } else {
            super.setAngularDamping(value);
        }
    }

    @Override
    public void setDensity(float value) {
        super.setDensity(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setDensity(value);
            }
        }
    }

    @Override
    public void setFriction(float value) {
        super.setFriction(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setFriction(value);
            }
        }
    }

    @Override
    public void setRestitution(float value) {
        super.setRestitution(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setRestitution(value);
            }
        }
    }

    @Override
    public void setSensor(boolean value) {
        super.setSensor(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setSensor(value);
            }
        }
    }

    @Override
    public void setFilterData(Filter value) {
        super.setFilterData(value);
        if (this.body != null) {
            for (Fixture f : this.body.getFixtureList()) {
                f.setFilterData(value);
            }
        }
    }

    @Override
    public Vector2 getCentroid() {
        return this.body != null ? this.body.getLocalCenter() : super.getCentroid();
    }

    @Override
    public void setCentroid(Vector2 value) {
        super.setCentroid(value);
        if (this.body != null) {
            this.body.setMassData(this.massdata);
        }
    }

    @Override
    public float getInertia() {
        return this.body != null ? this.body.getInertia() : super.getInertia();
    }

    @Override
    public void setInertia(float value) {
        super.setInertia(value);
        if (this.body != null) {
            this.body.setMassData(this.massdata);
        }
    }

    @Override
    public float getMass() {
        return this.body != null ? this.body.getMass() : super.getMass();
    }

    @Override
    public void setMass(float value) {
        super.setMass(value);
        if (this.body != null) {
            this.body.setMassData(this.massdata);
        }
    }

    @Override
    public void resetMass() {
        super.resetMass();
        if (this.body != null) {
            this.body.resetMassData();
        }
    }

    public TextureRegion getTexture() {
        return this.texture;
    }

    public void setTexture(TextureRegion value) {
        this.texture = value;
        this.origin.set((float)this.texture.getRegionWidth() / 2.0f, (float)this.texture.getRegionHeight() / 2.0f);
    }

    @Override
    public void draw(ObstacleCanvas canvas) {
        if (this.texture != null) {
            canvas.draw(this.texture, Color.WHITE, this.origin.x, this.origin.y, this.getX() * this.drawScale.x, this.getY() * this.drawScale.x, this.getAngle(), 1.0f, 1.0f);
        }
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    protected SimpleObstacle() {
        this(0.0f, 0.0f);
    }

    protected SimpleObstacle(float x, float y) {
        super(x, y);
    }

    @Override
    public boolean activatePhysics(World world) {
        this.bodyinfo.active = true;
        this.body = world.createBody(this.bodyinfo);
        this.body.setUserData((Object)this);
        if (this.body != null) {
            this.createFixtures();
            return true;
        }
        this.bodyinfo.active = false;
        return false;
    }

    @Override
    public void deactivatePhysics(World world) {
        if (this.body != null) {
            this.setBodyState(this.body);
            world.destroyBody(this.body);
            this.body = null;
            this.bodyinfo.active = false;
        }
    }

    protected abstract void createFixtures();

    protected abstract void releaseFixtures();

    @Override
    public void update(float delta) {
        if (this.isDirty()) {
            this.createFixtures();
        }
    }
}

