/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics.obstacle;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.utils.ShortArray;
import edu.cornell.gdiac.physics.obstacle.ObstacleCanvas;
import edu.cornell.gdiac.physics.obstacle.SimpleObstacle;

public class PolygonObstacle
extends SimpleObstacle {
    protected static final EarClippingTriangulator TRIANGULATOR = new EarClippingTriangulator();
    protected PolygonShape[] shapes;
    protected PolygonRegion region;
    protected float[] scaled;
    protected short[] tridx;
    protected Fixture[] geoms;
    private Vector2 dimension;
    private Vector2 sizeCache;
    protected float[] vertices;
    private Color debugColor;

    public Vector2 getDimension() {
        return this.sizeCache.set(this.dimension);
    }

    public void setDimension(Vector2 value) {
        this.setDimension(value.x, value.y);
    }

    public void setDimension(float width, float height) {
        this.resize(width, height);
        this.markDirty(true);
    }

    public float getWidth() {
        return this.dimension.x;
    }

    public void setWidth(float value) {
        this.sizeCache.set(value, this.dimension.y);
        this.setDimension(this.sizeCache);
    }

    public float getHeight() {
        return this.dimension.y;
    }

    public void setHeight(float value) {
        this.sizeCache.set(this.dimension.x, value);
        this.setDimension(this.sizeCache);
    }

    public Color getDebugColor() {
        return this.debugColor;
    }

    public void setDebugColor(Color value) {
        this.debugColor = value;
    }

    public PolygonObstacle(float[] points) {
        this(points, 0.0f, 0.0f);
    }

    public PolygonObstacle(float[] points, float x, float y) {
        super(x, y);
        assert (points.length % 2 == 0);
        this.debugColor = Color.YELLOW;
        this.initShapes(points);
        this.initBounds();
    }

    @Override
    public void dispose() {
        if (this.shapes != null) {
            for (int ii = 0; ii < this.shapes.length; ++ii) {
                this.shapes[ii].dispose();
            }
            this.shapes = null;
        }
    }

    protected void initBounds() {
        float minx = this.vertices[0];
        float maxx = this.vertices[0];
        float miny = this.vertices[1];
        float maxy = this.vertices[1];
        for (int ii = 2; ii < this.vertices.length; ii += 2) {
            if (this.vertices[ii] < minx) {
                minx = this.vertices[ii];
            } else if (this.vertices[ii] > maxx) {
                maxx = this.vertices[ii];
            }
            if (this.vertices[ii + 1] < miny) {
                miny = this.vertices[ii + 1];
                continue;
            }
            if (!(this.vertices[ii] > maxy)) continue;
            maxy = this.vertices[ii + 1];
        }
        this.dimension = new Vector2(maxx - minx, maxy - miny);
        this.sizeCache = new Vector2(this.dimension);
    }

    protected void initShapes(float[] points) {
        int ii;
        this.dispose();
        ShortArray array = TRIANGULATOR.computeTriangles(points);
        this.trimColinear(points, array);
        this.tridx = new short[array.items.length];
        System.arraycopy(array.items, 0, this.tridx, 0, this.tridx.length);
        int tris = array.items.length / 3;
        this.vertices = new float[tris * 6];
        this.shapes = new PolygonShape[tris];
        this.geoms = new Fixture[tris];
        for (ii = 0; ii < tris; ++ii) {
            for (int jj = 0; jj < 3; ++jj) {
                this.vertices[6 * ii + 2 * jj] = points[2 * array.items[3 * ii + jj]];
                this.vertices[6 * ii + 2 * jj + 1] = points[2 * array.items[3 * ii + jj] + 1];
            }
            this.shapes[ii] = new PolygonShape();
            this.shapes[ii].set(this.vertices, 6 * ii, 6);
        }
        this.scaled = new float[points.length];
        for (ii = 0; ii < points.length; ii += 2) {
            this.scaled[ii] = points[ii] * this.drawScale.x;
            this.scaled[ii + 1] = points[ii + 1] * this.drawScale.y;
        }
        if (this.texture != null) {
            this.region = new PolygonRegion(this.texture, this.scaled, this.tridx);
        }
        this.markDirty(true);
    }

    protected void trimColinear(float[] points, ShortArray indices) {
        int colinear = 0;
        for (int ii = 0; ii < indices.size / 3 - colinear; ++ii) {
            float t1 = points[2 * indices.items[3 * ii]] * (points[2 * indices.items[3 * ii + 1] + 1] - points[2 * indices.items[3 * ii + 2] + 1]);
            float t2 = points[2 * indices.items[3 * ii + 1]] * (points[2 * indices.items[3 * ii + 2] + 1] - points[2 * indices.items[3 * ii] + 1]);
            float t3 = points[2 * indices.items[3 * ii + 2]] * (points[2 * indices.items[3 * ii] + 1] - points[2 * indices.items[3 * ii + 1] + 1]);
            if (!(Math.abs(t1 + t2 + t3) < 1.0E-7f)) continue;
            indices.swap(3 * ii, indices.size - 3 * colinear - 3);
            indices.swap(3 * ii + 1, indices.size - 3 * colinear - 2);
            indices.swap(3 * ii + 2, indices.size - 3 * colinear - 1);
            ++colinear;
        }
        indices.size -= 3 * colinear;
        indices.shrink();
    }

    protected void resize(float width, float height) {
        int ii;
        float scalex = width / this.dimension.x;
        float scaley = height / this.dimension.y;
        for (ii = 0; ii < this.shapes.length; ++ii) {
            for (int jj = 0; jj < 3; ++jj) {
                int n = 6 * ii + 2 * jj;
                this.vertices[n] = this.vertices[n] * scalex;
                int n2 = 6 * ii + 2 * jj + 1;
                this.vertices[n2] = this.vertices[n2] * scaley;
            }
            this.shapes[ii].set(this.vertices, 6 * ii, 6);
        }
        for (ii = 0; ii < this.scaled.length; ii += 2) {
            int n = ii;
            this.scaled[n] = this.scaled[n] * scalex;
            int n3 = ii + 1;
            this.scaled[n3] = this.scaled[n3] * scaley;
        }
        this.dimension.set(width, height);
    }

    @Override
    protected void createFixtures() {
        if (this.body == null) {
            return;
        }
        this.releaseFixtures();
        if (this.geoms.length != this.shapes.length) {
            this.geoms = new Fixture[this.shapes.length];
        }
        for (int ii = 0; ii < this.shapes.length; ++ii) {
            this.fixture.shape = this.shapes[ii];
            this.geoms[ii] = this.body.createFixture(this.fixture);
        }
        this.markDirty(false);
    }

    @Override
    protected void releaseFixtures() {
        if (this.geoms[0] != null) {
            for (Fixture fix : this.geoms) {
                this.body.destroyFixture(fix);
            }
        }
    }

    @Override
    public void setTexture(TextureRegion value) {
        this.texture = value;
        this.region = new PolygonRegion(this.texture, this.scaled, this.tridx);
    }

    @Override
    public void setDrawScale(float x, float y) {
        assert (x != 0.0f && y != 0.0f) : "Scale cannot be 0";
        float dx = x / this.drawScale.x;
        float dy = y / this.drawScale.y;
        for (int ii = 0; ii < this.scaled.length; ii += 2) {
            int n = ii;
            this.scaled[n] = this.scaled[n] * dx;
            int n2 = ii + 1;
            this.scaled[n2] = this.scaled[n2] * dy;
        }
        if (this.texture != null) {
            this.region = new PolygonRegion(this.texture, this.scaled, this.tridx);
        }
        this.drawScale.set(x, y);
    }

    @Override
    public void draw(ObstacleCanvas canvas) {
        if (this.region != null) {
            canvas.draw(this.region, Color.WHITE, 0.0f, 0.0f, this.getX() * this.drawScale.x, this.getY() * this.drawScale.y, this.getAngle(), 1.0f, 1.0f);
        }
    }

    @Override
    public void drawDebug(ObstacleCanvas canvas) {
        if (this.debugColor != null) {
            for (PolygonShape tri : this.shapes) {
                canvas.drawPhysics(tri, this.debugColor, this.getX(), this.getY(), this.getAngle(), this.drawScale.x, this.drawScale.y);
            }
        }
    }
}

