/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics.obstacle;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.PolygonShape;

public class ObstacleCanvas {
    private PolygonSpriteBatch spriteBatch;
    private DrawPass active = DrawPass.INACTIVE;
    private BlendState blend;
    private OrthographicCamera camera;
    int width;
    int height;
    private Affine2 local;
    private Matrix4 global;
    private Vector2 vertex;
    private TextureRegion holder;

    public ObstacleCanvas() {
        if (Gdx.gl30 != null) {
            ShaderProgram shader = new ShaderProgram(Gdx.files.internal("shaders/gl30.vert"), Gdx.files.internal("shaders/gl30.frag"));
            System.out.println("shader");
            this.spriteBatch = new PolygonSpriteBatch(4096, shader);
            System.out.println("Spritebatch complete");
        } else {
            this.spriteBatch = new PolygonSpriteBatch();
        }
        this.camera = new OrthographicCamera((float)this.getWidth(), (float)this.getHeight());
        this.camera.setToOrtho(false);
        this.spriteBatch.setProjectionMatrix(this.camera.combined);
        this.holder = new TextureRegion();
        this.local = new Affine2();
        this.global = new Matrix4();
        this.vertex = new Vector2();
    }

    public void dispose() {
        if (this.active != DrawPass.INACTIVE) {
            Gdx.app.error("GameCanvas", "Cannot dispose while drawing active", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.dispose();
        this.spriteBatch = null;
        this.local = null;
        this.global = null;
        this.vertex = null;
        this.holder = null;
    }

    public int getWidth() {
        return Gdx.graphics.getWidth();
    }

    public void setWidth(int width) {
        if (this.active != DrawPass.INACTIVE) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", (Throwable)new IllegalStateException());
            return;
        }
        this.width = width;
        if (!this.isFullscreen()) {
            Gdx.graphics.setWindowedMode(width, this.getHeight());
        }
        this.resize();
    }

    public int getHeight() {
        return Gdx.graphics.getHeight();
    }

    public void setHeight(int height) {
        if (this.active != DrawPass.INACTIVE) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", (Throwable)new IllegalStateException());
            return;
        }
        this.height = height;
        if (!this.isFullscreen()) {
            Gdx.graphics.setWindowedMode(this.getWidth(), height);
        }
        this.resize();
    }

    public Vector2 getSize() {
        return new Vector2((float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
    }

    public void setSize(int width, int height) {
        if (this.active != DrawPass.INACTIVE) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", (Throwable)new IllegalStateException());
            return;
        }
        this.width = width;
        this.height = height;
        if (!this.isFullscreen()) {
            Gdx.graphics.setWindowedMode(width, height);
        }
        this.resize();
    }

    public boolean isFullscreen() {
        return Gdx.graphics.isFullscreen();
    }

    public void setFullscreen(boolean value, boolean desktop) {
        if (this.active != DrawPass.INACTIVE) {
            Gdx.app.error("GameCanvas", "Cannot alter property while drawing active", (Throwable)new IllegalStateException());
            return;
        }
        if (value) {
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
        } else {
            Gdx.graphics.setWindowedMode(this.width, this.height);
        }
    }

    public void resize() {
        this.spriteBatch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
    }

    public BlendState getBlendState() {
        return this.blend;
    }

    public void setBlendState(BlendState state) {
        if (state == this.blend) {
            return;
        }
        switch (state) {
            case NO_PREMULT: {
                this.spriteBatch.setBlendFunction(770, 771);
                break;
            }
            case ALPHA_BLEND: {
                this.spriteBatch.setBlendFunction(1, 771);
                break;
            }
            case ADDITIVE: {
                this.spriteBatch.setBlendFunction(770, 1);
                break;
            }
            case OPAQUE: {
                this.spriteBatch.setBlendFunction(1, 0);
            }
        }
        this.blend = state;
    }

    public OrthographicCamera getCamera() {
        return this.camera;
    }

    public void clear() {
        Gdx.gl.glClearColor(0.39f, 0.58f, 0.93f, 1.0f);
        Gdx.gl.glClear(16384);
    }

    public void begin(Affine2 affine) {
        this.camera.update();
        this.global.setAsAffine(affine);
        this.global.mulLeft(this.camera.combined);
        this.spriteBatch.setProjectionMatrix(this.global);
        this.setBlendState(BlendState.NO_PREMULT);
        this.spriteBatch.begin();
        this.active = DrawPass.STANDARD;
    }

    public void begin(float sx, float sy) {
        this.camera.update();
        this.global.idt();
        this.global.scl(sx, sy, 1.0f);
        this.global.mulLeft(this.camera.combined);
        this.spriteBatch.setProjectionMatrix(this.global);
        this.spriteBatch.begin();
        this.active = DrawPass.STANDARD;
    }

    public void begin() {
        this.camera.update();
        this.spriteBatch.setProjectionMatrix(this.camera.combined);
        this.spriteBatch.begin();
        this.active = DrawPass.STANDARD;
    }

    public void end() {
        this.spriteBatch.end();
        this.active = DrawPass.INACTIVE;
    }

    public void draw(Texture image, float x, float y) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(image, x, y);
    }

    public void draw(Texture image, Color tint, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(image, x, y, width, height);
    }

    public void draw(Texture image, Color tint, float ox, float oy, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.holder.setRegion(image);
        this.draw(this.holder, tint, x - ox, y - oy, width, height);
    }

    public void draw(Texture image, Color tint, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.holder.setRegion(image);
        this.draw(this.holder, tint, ox, oy, x, y, angle, sx, sy);
    }

    public void draw(Texture image, Color tint, float ox, float oy, Affine2 transform) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.holder.setRegion(image);
        this.draw(this.holder, tint, ox, oy, transform);
    }

    public void draw(TextureRegion region, float x, float y) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(region, x, y);
    }

    public void draw(TextureRegion region, Color tint, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, x, y, width, height);
    }

    public void draw(TextureRegion region, Color tint, float ox, float oy, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, x - ox, y - oy, width, height);
    }

    public void draw(TextureRegion region, Color tint, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.computeTransform(ox, oy, x, y, angle, sx, sy);
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, (float)region.getRegionWidth(), (float)region.getRegionHeight(), this.local);
    }

    public void draw(TextureRegion region, Color tint, float ox, float oy, Affine2 affine) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.local.set(affine);
        this.local.translate(-ox, -oy);
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, (float)region.getRegionWidth(), (float)region.getRegionHeight(), this.local);
    }

    public void draw(PolygonRegion region, float x, float y) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(Color.WHITE);
        this.spriteBatch.draw(region, x, y);
    }

    public void draw(PolygonRegion region, Color tint, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, x, y, width, height);
    }

    public void draw(PolygonRegion region, Color tint, float ox, float oy, float x, float y, float width, float height) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, x - ox, y - oy, width, height);
    }

    public void draw(PolygonRegion region, Color tint, float ox, float oy, float x, float y, float angle, float sx, float sy) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        TextureRegion bounds = region.getRegion();
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, x, y, ox, oy, (float)bounds.getRegionWidth(), (float)bounds.getRegionHeight(), sx, sy, 180.0f * angle / (float)Math.PI);
    }

    public void draw(PolygonRegion region, Color tint, float ox, float oy, Affine2 affine) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        this.local.set(affine);
        this.local.translate(-ox, -oy);
        this.computeVertices(this.local, region.getVertices());
        this.spriteBatch.setColor(tint);
        this.spriteBatch.draw(region, 0.0f, 0.0f);
        this.local.inv();
        this.computeVertices(this.local, region.getVertices());
    }

    private void computeVertices(Affine2 affine, float[] vertices) {
        for (int ii = 0; ii < vertices.length; ii += 2) {
            this.vertex.set(vertices[2 * ii], vertices[2 * ii + 1]);
            affine.applyTo(this.vertex);
            vertices[2 * ii] = this.vertex.x;
            vertices[2 * ii + 1] = this.vertex.y;
        }
    }

    public void drawText(String text, BitmapFont font, float x, float y) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        GlyphLayout layout = new GlyphLayout(font, (CharSequence)text);
        font.draw((Batch)this.spriteBatch, layout, x, y);
    }

    public void drawTextCentered(String text, BitmapFont font, float offset) {
        if (this.active != DrawPass.STANDARD) {
            Gdx.app.error("GameCanvas", "Cannot draw without active begin()", (Throwable)new IllegalStateException());
            return;
        }
        GlyphLayout layout = new GlyphLayout(font, (CharSequence)text);
        float x = ((float)this.getWidth() - layout.width) / 2.0f;
        float y = ((float)this.getHeight() + layout.height) / 2.0f;
        font.draw((Batch)this.spriteBatch, layout, x, y + offset);
    }

    public void beginDebug(Affine2 affine) {
        this.camera.update();
        this.global.setAsAffine(affine);
        this.global.mulLeft(this.camera.combined);
        this.active = DrawPass.DEBUG;
    }

    public void beginDebug(float sx, float sy) {
        this.global.idt();
        this.global.scl(sx, sy, 1.0f);
        this.global.mulLeft(this.camera.combined);
        this.active = DrawPass.DEBUG;
    }

    public void beginDebug() {
        this.active = DrawPass.DEBUG;
    }

    public void endDebug() {
        this.active = DrawPass.INACTIVE;
    }

    public void drawPhysics(PolygonShape shape, Color color, float x, float y) {
        float y1;
        float x1;
        float y0;
        float x0;
        if (this.active != DrawPass.DEBUG) {
            Gdx.app.error("GameCanvas", "Cannot draw without active beginDebug()", (Throwable)new IllegalStateException());
            return;
        }
        for (int ii = 0; ii < shape.getVertexCount() - 1; ++ii) {
            shape.getVertex(ii, this.vertex);
            x0 = x + this.vertex.x;
            y0 = y + this.vertex.y;
            shape.getVertex(ii + 1, this.vertex);
            x1 = x + this.vertex.x;
            y1 = y + this.vertex.y;
        }
        shape.getVertex(shape.getVertexCount() - 1, this.vertex);
        x0 = x + this.vertex.x;
        y0 = y + this.vertex.y;
        shape.getVertex(0, this.vertex);
        x1 = x + this.vertex.x;
        y1 = y + this.vertex.y;
    }

    public void drawPhysics(PolygonShape shape, Color color, float x, float y, float angle) {
        float y1;
        float x1;
        float y0;
        float x0;
        if (this.active != DrawPass.DEBUG) {
            Gdx.app.error("GameCanvas", "Cannot draw without active beginDebug()", (Throwable)new IllegalStateException());
            return;
        }
        this.local.setToTranslation(x, y);
        this.local.rotateRad(angle);
        for (int ii = 0; ii < shape.getVertexCount() - 1; ++ii) {
            shape.getVertex(ii, this.vertex);
            this.local.applyTo(this.vertex);
            x0 = this.vertex.x;
            y0 = this.vertex.y;
            shape.getVertex(ii + 1, this.vertex);
            this.local.applyTo(this.vertex);
            x1 = this.vertex.x;
            y1 = this.vertex.y;
        }
        shape.getVertex(shape.getVertexCount() - 1, this.vertex);
        this.local.applyTo(this.vertex);
        x0 = this.vertex.x;
        y0 = this.vertex.y;
        shape.getVertex(0, this.vertex);
        this.local.applyTo(this.vertex);
        x1 = this.vertex.x;
        y1 = this.vertex.y;
    }

    public void drawPhysics(PolygonShape shape, Color color, float x, float y, float angle, float sx, float sy) {
        float y1;
        float x1;
        float y0;
        float x0;
        if (this.active != DrawPass.DEBUG) {
            Gdx.app.error("GameCanvas", "Cannot draw without active beginDebug()", (Throwable)new IllegalStateException());
            return;
        }
        this.local.setToScaling(sx, sy);
        this.local.translate(x, y);
        this.local.rotateRad(angle);
        for (int ii = 0; ii < shape.getVertexCount() - 1; ++ii) {
            shape.getVertex(ii, this.vertex);
            this.local.applyTo(this.vertex);
            x0 = this.vertex.x;
            y0 = this.vertex.y;
            shape.getVertex(ii + 1, this.vertex);
            this.local.applyTo(this.vertex);
            x1 = this.vertex.x;
            y1 = this.vertex.y;
        }
        shape.getVertex(shape.getVertexCount() - 1, this.vertex);
        this.local.applyTo(this.vertex);
        x0 = this.vertex.x;
        y0 = this.vertex.y;
        shape.getVertex(0, this.vertex);
        this.local.applyTo(this.vertex);
        x1 = this.vertex.x;
        y1 = this.vertex.y;
    }

    public void drawPhysics(CircleShape shape, Color color, float x, float y) {
        if (this.active != DrawPass.DEBUG) {
            Gdx.app.error("GameCanvas", "Cannot draw without active beginDebug()", (Throwable)new IllegalStateException());
            return;
        }
    }

    public void drawPhysics(CircleShape shape, Color color, float x, float y, float sx, float sy) {
        if (this.active != DrawPass.DEBUG) {
            Gdx.app.error("GameCanvas", "Cannot draw without active beginDebug()", (Throwable)new IllegalStateException());
            return;
        }
        float x0 = x * sx;
        float y0 = y * sy;
        float w = shape.getRadius() * sx;
        float h = shape.getRadius() * sy;
    }

    private void computeTransform(float ox, float oy, float x, float y, float angle, float sx, float sy) {
        this.local.setToTranslation(x, y);
        this.local.rotate(180.0f * angle / (float)Math.PI);
        this.local.scale(sx, sy);
        this.local.translate(-ox, -oy);
    }

    public static enum BlendState {
        ALPHA_BLEND,
        NO_PREMULT,
        ADDITIVE,
        OPAQUE;

    }

    private static enum DrawPass {
        INACTIVE,
        STANDARD,
        DEBUG;

    }
}

