/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics.obstacle;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.MassData;
import com.badlogic.gdx.physics.box2d.World;
import edu.cornell.gdiac.physics.obstacle.ObstacleCanvas;

public abstract class Obstacle {
    protected BodyDef bodyinfo;
    protected FixtureDef fixture;
    protected MassData massdata;
    protected boolean masseffect;
    private String nametag;
    protected Vector2 drawScale;
    private boolean toRemove = false;
    private boolean isDirty;
    protected Vector2 positionCache = new Vector2();
    protected Vector2 velocityCache = new Vector2();
    protected Vector2 centroidCache = new Vector2();
    protected Vector2 scaleCache = new Vector2();

    public BodyDef.BodyType getBodyType() {
        return this.bodyinfo.type;
    }

    public void setBodyType(BodyDef.BodyType value) {
        this.bodyinfo.type = value;
    }

    public Vector2 getPosition() {
        return this.positionCache.set(this.bodyinfo.position);
    }

    public void setPosition(Vector2 value) {
        this.bodyinfo.position.set(value);
    }

    public void setPosition(float x, float y) {
        this.bodyinfo.position.set(x, y);
    }

    public float getX() {
        return this.bodyinfo.position.x;
    }

    public void setX(float value) {
        this.bodyinfo.position.x = value;
    }

    public float getY() {
        return this.bodyinfo.position.y;
    }

    public void setY(float value) {
        this.bodyinfo.position.y = value;
    }

    public float getAngle() {
        return this.bodyinfo.angle;
    }

    public void setAngle(float value) {
        this.bodyinfo.angle = value;
    }

    public Vector2 getLinearVelocity() {
        return this.velocityCache.set(this.bodyinfo.linearVelocity);
    }

    public void setLinearVelocity(Vector2 value) {
        this.bodyinfo.linearVelocity.set(value);
    }

    public float getVX() {
        return this.bodyinfo.linearVelocity.x;
    }

    public void setVX(float value) {
        this.bodyinfo.linearVelocity.x = value;
    }

    public float getVY() {
        return this.bodyinfo.linearVelocity.y;
    }

    public void setVY(float value) {
        this.bodyinfo.linearVelocity.y = value;
    }

    public float getAngularVelocity() {
        return this.bodyinfo.angularVelocity;
    }

    public void setAngularVelocity(float value) {
        this.bodyinfo.angularVelocity = value;
    }

    public boolean isActive() {
        return this.bodyinfo.active;
    }

    public void setActive(boolean value) {
        this.bodyinfo.active = value;
    }

    public boolean isAwake() {
        return this.bodyinfo.awake;
    }

    public void setAwake(boolean value) {
        this.bodyinfo.awake = value;
    }

    public boolean isSleepingAllowed() {
        return this.bodyinfo.allowSleep;
    }

    public void setSleepingAllowed(boolean value) {
        this.bodyinfo.allowSleep = value;
    }

    public boolean isBullet() {
        return this.bodyinfo.bullet;
    }

    public void setBullet(boolean value) {
        this.bodyinfo.bullet = value;
    }

    public boolean isFixedRotation() {
        return this.bodyinfo.fixedRotation;
    }

    public void setFixedRotation(boolean value) {
        this.bodyinfo.fixedRotation = value;
    }

    public float getGravityScale() {
        return this.bodyinfo.gravityScale;
    }

    public void setGravityScale(float value) {
        this.bodyinfo.gravityScale = value;
    }

    public float getLinearDamping() {
        return this.bodyinfo.linearDamping;
    }

    public void setLinearDamping(float value) {
        this.bodyinfo.linearDamping = value;
    }

    public float getAngularDamping() {
        return this.bodyinfo.angularDamping;
    }

    public void setAngularDamping(float value) {
        this.bodyinfo.angularDamping = value;
    }

    protected void setBodyState(Body body) {
        this.bodyinfo.type = body.getType();
        this.bodyinfo.angle = body.getAngle();
        this.bodyinfo.active = body.isActive();
        this.bodyinfo.awake = body.isAwake();
        this.bodyinfo.bullet = body.isBullet();
        this.bodyinfo.position.set(body.getPosition());
        this.bodyinfo.linearVelocity.set(body.getLinearVelocity());
        this.bodyinfo.allowSleep = body.isSleepingAllowed();
        this.bodyinfo.fixedRotation = body.isFixedRotation();
        this.bodyinfo.gravityScale = body.getGravityScale();
        this.bodyinfo.angularDamping = body.getAngularDamping();
        this.bodyinfo.linearDamping = body.getLinearDamping();
    }

    public float getDensity() {
        return this.fixture.density;
    }

    public void setDensity(float value) {
        this.fixture.density = value;
    }

    public float getFriction() {
        return this.fixture.friction;
    }

    public void setFriction(float value) {
        this.fixture.friction = value;
    }

    public float getRestitution() {
        return this.fixture.restitution;
    }

    public void setRestitution(float value) {
        this.fixture.restitution = value;
    }

    public boolean isSensor() {
        return this.fixture.isSensor;
    }

    public void setSensor(boolean value) {
        this.fixture.isSensor = value;
    }

    public Filter getFilterData() {
        return this.fixture.filter;
    }

    public void setFilterData(Filter value) {
        if (value != null) {
            this.fixture.filter.categoryBits = value.categoryBits;
            this.fixture.filter.groupIndex = value.groupIndex;
            this.fixture.filter.maskBits = value.maskBits;
        } else {
            this.fixture.filter.categoryBits = 1;
            this.fixture.filter.groupIndex = 0;
            this.fixture.filter.maskBits = (short)-1;
        }
    }

    public Vector2 getCentroid() {
        return this.centroidCache.set(this.massdata.center);
    }

    public void setCentroid(Vector2 value) {
        if (!this.masseffect) {
            this.masseffect = true;
            this.massdata.I = this.getInertia();
            this.massdata.mass = this.getMass();
        }
        this.massdata.center.set(value);
    }

    public float getInertia() {
        return this.massdata.I;
    }

    public void setInertia(float value) {
        if (!this.masseffect) {
            this.masseffect = true;
            this.massdata.center.set(this.getCentroid());
            this.massdata.mass = this.getMass();
        }
        this.massdata.I = value;
    }

    public float getMass() {
        return this.massdata.mass;
    }

    public void setMass(float value) {
        if (!this.masseffect) {
            this.masseffect = true;
            this.massdata.center.set(this.getCentroid());
            this.massdata.I = this.getInertia();
        }
        this.massdata.mass = value;
    }

    public void resetMass() {
        this.masseffect = false;
    }

    public boolean isRemoved() {
        return this.toRemove;
    }

    public void markRemoved(boolean value) {
        this.toRemove = value;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void markDirty(boolean value) {
        this.isDirty = value;
    }

    public Body getBody() {
        return null;
    }

    public Vector2 getDrawScale() {
        this.scaleCache.set(this.drawScale);
        return this.scaleCache;
    }

    public void setDrawScale(Vector2 value) {
        this.setDrawScale(value.x, value.y);
    }

    public void setDrawScale(float x, float y) {
        this.drawScale.set(x, y);
    }

    public String getName() {
        return this.nametag;
    }

    public void setName(String value) {
        this.nametag = value;
    }

    protected Obstacle() {
        this(0.0f, 0.0f);
    }

    protected Obstacle(float x, float y) {
        this.bodyinfo = new BodyDef();
        this.bodyinfo.awake = true;
        this.bodyinfo.allowSleep = true;
        this.bodyinfo.gravityScale = 1.0f;
        this.bodyinfo.position.set(x, y);
        this.bodyinfo.fixedRotation = false;
        this.bodyinfo.type = BodyDef.BodyType.DynamicBody;
        this.fixture = new FixtureDef();
        this.masseffect = false;
        this.massdata = new MassData();
        this.drawScale = new Vector2(1.0f, 1.0f);
    }

    public void dispose() {
    }

    public abstract boolean activatePhysics(World var1);

    public abstract void deactivatePhysics(World var1);

    public void update(float delta) {
    }

    public abstract void draw(ObstacleCanvas var1);

    public abstract void drawDebug(ObstacleCanvas var1);
}

