/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics.obstacle;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import edu.cornell.gdiac.physics.obstacle.ObstacleCanvas;
import edu.cornell.gdiac.physics.obstacle.SimpleObstacle;

public class CapsuleObstacle
extends SimpleObstacle {
    private static final float DEFAULT_EPSILON = 0.01f;
    protected PolygonShape shape;
    protected CircleShape end1;
    protected CircleShape end2;
    protected Rectangle center;
    private Color debugColor;
    private Vector2 dimension;
    private Vector2 sizeCache;
    protected Fixture core = null;
    protected Fixture cap1 = null;
    protected Fixture cap2 = null;
    protected Orientation orient;
    private float[] vertices;
    private Vector2 posCache = new Vector2();
    private float seamEpsilon;

    public Vector2 getDimension() {
        return this.sizeCache.set(this.dimension);
    }

    public void setDimension(Vector2 value) {
        this.setDimension(value.x, value.y);
    }

    public void setDimension(float width, float height) {
        this.dimension.set(width, height);
        this.markDirty(true);
        this.resize(width, height);
    }

    public float getWidth() {
        return this.dimension.x;
    }

    public void setWidth(float value) {
        this.sizeCache.set(value, this.dimension.y);
        this.setDimension(this.sizeCache);
    }

    public float getHeight() {
        return this.dimension.y;
    }

    public void setHeight(float value) {
        this.sizeCache.set(this.dimension.x, value);
        this.setDimension(this.sizeCache);
    }

    public Orientation getOrientation() {
        return this.orient;
    }

    public boolean setOrientation(Orientation value) {
        if (this.dimension.x < this.dimension.y && CapsuleObstacle.isHorizontal(value)) {
            return false;
        }
        this.orient = value;
        this.resize(this.dimension.x, this.dimension.y);
        return true;
    }

    protected static boolean isHorizontal(Orientation value) {
        return value == Orientation.LEFT || value == Orientation.RIGHT || value == Orientation.HORIZONTAL;
    }

    public void setSeamOffset(float value) {
        this.seamEpsilon = value;
        this.markDirty(true);
    }

    public float getSeamOffset() {
        return this.seamEpsilon;
    }

    public Color getDebugColor() {
        return this.debugColor;
    }

    public void setDebugColor(Color value) {
        this.debugColor = value;
    }

    public CapsuleObstacle(float width, float height) {
        this(0.0f, 0.0f, width, height, width > height ? Orientation.HORIZONTAL : Orientation.VERTICAL);
    }

    public CapsuleObstacle(float x, float y, float width, float height) {
        this(x, y, width, height, width > height ? Orientation.HORIZONTAL : Orientation.VERTICAL);
    }

    public CapsuleObstacle(float x, float y, float width, float height, Orientation o) {
        super(x, y);
        this.dimension = new Vector2();
        this.sizeCache = new Vector2();
        this.shape = new PolygonShape();
        this.end1 = new CircleShape();
        this.end2 = new CircleShape();
        this.center = new Rectangle();
        this.vertices = new float[8];
        this.orient = o;
        this.seamEpsilon = 0.01f;
        this.debugColor = Color.YELLOW;
        this.resize(width, height);
    }

    @Override
    public void dispose() {
        if (this.shape != null) {
            this.shape.dispose();
            this.shape = null;
        }
        if (this.end1 != null) {
            this.end1.dispose();
            this.end1 = null;
        }
        if (this.end2 != null) {
            this.end2.dispose();
            this.end2 = null;
        }
    }

    private void resize(float width, float height) {
        this.dimension.set(width, height);
        if (width < height && CapsuleObstacle.isHorizontal(this.orient)) {
            this.orient = Orientation.VERTICAL;
        } else if (width > height && !CapsuleObstacle.isHorizontal(this.orient)) {
            this.orient = Orientation.HORIZONTAL;
        }
        this.center.x = -width / 2.0f;
        this.center.y = -height / 2.0f;
        this.center.width = width;
        this.center.height = height;
        float r = 0.0f;
        switch (this.orient) {
            case TOP: {
                r = width / 2.0f;
                this.center.height -= r;
                this.center.x += 2.0f * this.seamEpsilon;
                this.center.width -= 2.0f * this.seamEpsilon;
                break;
            }
            case VERTICAL: {
                r = width / 2.0f;
                this.center.y += r;
                this.center.height -= 2.0f * r;
                this.center.x += this.seamEpsilon;
                this.center.width -= 2.0f * this.seamEpsilon;
                break;
            }
            case BOTTOM: {
                r = width / 2.0f;
                this.center.y += r;
                this.center.height -= r;
                this.center.x += this.seamEpsilon;
                this.center.width -= 2.0f * this.seamEpsilon;
                break;
            }
            case LEFT: {
                r = height / 2.0f;
                this.center.width -= r;
                this.center.y += this.seamEpsilon;
                this.center.height -= 2.0f * this.seamEpsilon;
                break;
            }
            case HORIZONTAL: {
                r = height / 2.0f;
                this.center.x += r;
                this.center.width -= 2.0f * r;
                this.center.y += this.seamEpsilon;
                this.center.height -= 2.0f * this.seamEpsilon;
                break;
            }
            case RIGHT: {
                r = height / 2.0f;
                this.center.x += r;
                this.center.width -= r;
                this.center.y += this.seamEpsilon;
                this.center.height -= 2.0f * this.seamEpsilon;
            }
        }
        if (this.center.width == 0.0f) {
            this.center.width = this.seamEpsilon;
        }
        if (this.center.height == 0.0f) {
            this.center.height = this.seamEpsilon;
        }
        this.vertices[0] = this.center.x;
        this.vertices[1] = this.center.y;
        this.vertices[2] = this.center.x;
        this.vertices[3] = this.center.y + this.center.height;
        this.vertices[4] = this.center.x + this.center.width;
        this.vertices[5] = this.center.y + this.center.height;
        this.vertices[6] = this.center.x + this.center.width;
        this.vertices[7] = this.center.y;
        this.shape.set(this.vertices);
        this.end1.setRadius(r);
        this.end2.setRadius(r);
    }

    @Override
    public void setDensity(float value) {
        this.fixture.density = value;
        if (this.body != null) {
            this.core.setDensity(value);
            this.cap1.setDensity(value / 2.0f);
            this.cap2.setDensity(value / 2.0f);
            if (!this.masseffect) {
                this.body.resetMassData();
            }
        }
    }

    @Override
    protected void createFixtures() {
        if (this.body == null) {
            return;
        }
        this.releaseFixtures();
        this.fixture.shape = this.shape;
        this.core = this.body.createFixture(this.fixture);
        this.fixture.density /= 2.0f;
        this.posCache.set(0.0f, 0.0f);
        switch (this.orient) {
            case TOP: {
                this.posCache.y = this.center.y + this.center.height;
                this.end1.setPosition(this.posCache);
                this.fixture.shape = this.end1;
                this.cap1 = this.body.createFixture(this.fixture);
                this.cap2 = null;
                break;
            }
            case VERTICAL: {
                this.posCache.y = this.center.y + this.center.height;
                this.end1.setPosition(this.posCache);
                this.fixture.shape = this.end1;
                this.cap1 = this.body.createFixture(this.fixture);
                this.posCache.y = this.center.y;
                this.end2.setPosition(this.posCache);
                this.fixture.shape = this.end2;
                this.cap2 = this.body.createFixture(this.fixture);
                break;
            }
            case BOTTOM: {
                this.cap1 = null;
                this.posCache.y = this.center.y;
                this.end2.setPosition(this.posCache);
                this.fixture.shape = this.end2;
                this.cap2 = this.body.createFixture(this.fixture);
                break;
            }
            case LEFT: {
                this.posCache.x = this.center.x;
                this.end1.setPosition(this.posCache);
                this.fixture.shape = this.end1;
                this.cap1 = this.body.createFixture(this.fixture);
                this.cap2 = null;
                break;
            }
            case HORIZONTAL: {
                this.posCache.x = this.center.x;
                this.end1.setPosition(this.posCache);
                this.fixture.shape = this.end1;
                this.cap1 = this.body.createFixture(this.fixture);
                this.posCache.x = this.center.x + this.center.width;
                this.end2.setPosition(this.posCache);
                this.fixture.shape = this.end2;
                this.cap2 = this.body.createFixture(this.fixture);
                break;
            }
            case RIGHT: {
                this.cap1 = null;
                this.posCache.x = this.center.x + this.center.width;
                this.end2.setPosition(this.posCache);
                this.fixture.shape = this.end2;
                this.cap2 = this.body.createFixture(this.fixture);
            }
        }
        this.markDirty(false);
    }

    @Override
    protected void releaseFixtures() {
        if (this.core != null) {
            this.body.destroyFixture(this.core);
            this.core = null;
        }
        if (this.cap1 != null) {
            this.body.destroyFixture(this.cap1);
            this.cap1 = null;
        }
        if (this.cap2 != null) {
            this.body.destroyFixture(this.cap2);
            this.cap2 = null;
        }
    }

    @Override
    public void drawDebug(ObstacleCanvas canvas) {
        float dy;
        float dx;
        float r;
        if (this.debugColor == null) {
            return;
        }
        canvas.drawPhysics(this.shape, this.debugColor, this.getX(), this.getY(), this.getAngle(), this.drawScale.x, this.drawScale.y);
        if (this.cap1 != null) {
            if (CapsuleObstacle.isHorizontal(this.orient)) {
                r = -this.center.x;
                dx = (float)((double)r * Math.cos(Math.PI + (double)this.getAngle()));
                dy = (float)((double)r * Math.sin(Math.PI + (double)this.getAngle()));
            } else {
                r = this.center.y + this.center.height;
                dx = (float)((double)r * Math.cos(1.5707963267948966 + (double)this.getAngle()));
                dy = (float)((double)r * Math.sin(1.5707963267948966 + (double)this.getAngle()));
            }
            canvas.drawPhysics(this.end1, this.debugColor, this.getX() + dx, this.getY() + dy, this.drawScale.x, this.drawScale.y);
        }
        if (this.cap2 != null) {
            if (CapsuleObstacle.isHorizontal(this.orient)) {
                r = this.center.x + this.center.width;
                dx = (float)((double)r * Math.cos(this.getAngle()));
                dy = (float)((double)r * Math.sin(this.getAngle()));
            } else {
                r = -this.center.y;
                dx = (float)((double)r * Math.cos(-1.5707963267948966 + (double)this.getAngle()));
                dy = (float)((double)r * Math.sin(-1.5707963267948966 + (double)this.getAngle()));
            }
            canvas.drawPhysics(this.end2, this.debugColor, this.getX() + dx, this.getY() + dy, this.drawScale.x, this.drawScale.y);
        }
    }

    public static enum Orientation {
        TOP,
        VERTICAL,
        BOTTOM,
        LEFT,
        HORIZONTAL,
        RIGHT;

    }
}

