/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.b2lights;

import box2dLight.RayHandler;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.b2lights.DudeModel;
import edu.cornell.gdiac.b2lights.ExitModel;
import edu.cornell.gdiac.b2lights.ExteriorModel;
import edu.cornell.gdiac.b2lights.InteriorModel;
import edu.cornell.gdiac.physics.lights.ConeSource;
import edu.cornell.gdiac.physics.lights.LightSource;
import edu.cornell.gdiac.physics.lights.PointSource;
import edu.cornell.gdiac.physics.obstacle.Obstacle;
import edu.cornell.gdiac.physics.obstacle.ObstacleCanvas;
import edu.cornell.gdiac.util.PooledList;

public class LevelModel {
    public static final int WORLD_VELOC = 6;
    public static final int WORLD_POSIT = 2;
    private DudeModel avatar;
    private ExitModel goalDoor;
    private boolean debug = false;
    protected PooledList<Obstacle> objects = new PooledList();
    protected World world = null;
    protected Rectangle bounds;
    protected Vector2 scale;
    protected OrthographicCamera raycamera;
    protected RayHandler rayhandler;
    private Array<LightSource> lights = new Array();
    private int activeLight;
    protected int maxFPS;
    protected int minFPS;
    protected float timeStep;
    protected float maxSteps;
    protected float maxTimePerFrame;
    protected float physicsTimeLeft;

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Vector2 getScale() {
        return this.scale;
    }

    public World getWorld() {
        return this.world;
    }

    public RayHandler getRayHandler() {
        return this.rayhandler;
    }

    public DudeModel getAvatar() {
        return this.avatar;
    }

    public ExitModel getExit() {
        return this.goalDoor;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    public int getMaxFPS() {
        return this.maxFPS;
    }

    public void setMaxFPS(int value) {
        this.maxFPS = value;
    }

    public int getMinFPS() {
        return this.minFPS;
    }

    public void setMinFPS(int value) {
        this.minFPS = value;
    }

    public LevelModel() {
        this.bounds = new Rectangle(0.0f, 0.0f, 1.0f, 1.0f);
        this.scale = new Vector2(1.0f, 1.0f);
    }

    public void populate(AssetDirectory directory, JsonValue levelFormat) {
        float[] pSize = levelFormat.get("physicsSize").asFloatArray();
        int[] gSize = levelFormat.get("graphicSize").asIntArray();
        this.world = new World(Vector2.Zero, false);
        this.bounds = new Rectangle(0.0f, 0.0f, pSize[0], pSize[1]);
        this.scale.x = (float)gSize[0] / pSize[0];
        this.scale.y = (float)gSize[1] / pSize[1];
        int[] fps = levelFormat.get("fpsRange").asIntArray();
        this.maxFPS = fps[1];
        this.minFPS = fps[0];
        this.timeStep = 1.0f / (float)this.maxFPS;
        this.maxSteps = 1.0f + (float)this.maxFPS / (float)this.minFPS;
        this.maxTimePerFrame = this.timeStep * this.maxSteps;
        if (levelFormat.has("lighting")) {
            this.initLighting(levelFormat.get("lighting"));
        }
        this.createPointLights(levelFormat.get("pointlights"));
        this.createConeLights(levelFormat.get("conelights"));
        this.goalDoor = new ExitModel();
        this.goalDoor.initialize(directory, levelFormat.get("exit"));
        this.goalDoor.setDrawScale(this.scale);
        this.activate(this.goalDoor);
        for (JsonValue bounds = levelFormat.getChild("exterior"); bounds != null; bounds = bounds.next()) {
            ExteriorModel obj = new ExteriorModel();
            obj.initialize(directory, bounds);
            obj.setDrawScale(this.scale);
            this.activate(obj);
        }
        for (JsonValue walls = levelFormat.getChild("interior"); walls != null; walls = walls.next()) {
            InteriorModel obj = new InteriorModel();
            obj.initialize(directory, walls);
            obj.setDrawScale(this.scale);
            this.activate(obj);
        }
        this.avatar = new DudeModel();
        JsonValue avdata = levelFormat.get("avatar");
        this.avatar.initialize(directory, avdata);
        this.avatar.setDrawScale(this.scale);
        this.activate(this.avatar);
        this.attachLights(this.avatar);
    }

    private void initLighting(JsonValue light) {
        this.raycamera = new OrthographicCamera(this.bounds.width, this.bounds.height);
        this.raycamera.position.set(this.bounds.width / 2.0f, this.bounds.height / 2.0f, 0.0f);
        this.raycamera.update();
        RayHandler.setGammaCorrection((boolean)light.getBoolean("gamma"));
        RayHandler.useDiffuseLight((boolean)light.getBoolean("diffuse"));
        this.rayhandler = new RayHandler(this.world, Gdx.graphics.getWidth(), Gdx.graphics.getWidth());
        this.rayhandler.setCombinedMatrix(this.raycamera);
        float[] color = light.get("color").asFloatArray();
        this.rayhandler.setAmbientLight(color[0], color[0], color[0], color[0]);
        int blur = light.getInt("blur");
        this.rayhandler.setBlur(blur > 0);
        this.rayhandler.setBlurNum(blur);
    }

    private void createPointLights(JsonValue json) {
        for (JsonValue light = json.child(); light != null; light = light.next()) {
            float[] color = light.get("color").asFloatArray();
            float[] pos = light.get("pos").asFloatArray();
            float dist = light.getFloat("distance");
            int rays = light.getInt("rays");
            PointSource point = new PointSource(this.rayhandler, rays, Color.WHITE, dist, pos[0], pos[1]);
            point.setColor(color[0], color[1], color[2], color[3]);
            point.setSoft(light.getBoolean("soft"));
            Filter f = new Filter();
            f.maskBits = LevelModel.bitStringToComplement(light.getString("excludeBits"));
            point.setContactFilter(f);
            point.setActive(false);
            this.lights.add((Object)point);
        }
    }

    private void createConeLights(JsonValue json) {
        for (JsonValue light = json.child(); light != null; light = light.next()) {
            float[] color = light.get("color").asFloatArray();
            float[] pos = light.get("pos").asFloatArray();
            float dist = light.getFloat("distance");
            float face = light.getFloat("facing");
            float angle = light.getFloat("angle");
            int rays = light.getInt("rays");
            ConeSource cone = new ConeSource(this.rayhandler, rays, Color.WHITE, dist, pos[0], pos[1], face, angle);
            cone.setColor(color[0], color[1], color[2], color[3]);
            cone.setSoft(light.getBoolean("soft"));
            Filter f = new Filter();
            f.maskBits = LevelModel.bitStringToComplement(light.getString("excludeBits"));
            cone.setContactFilter(f);
            cone.setActive(false);
            this.lights.add((Object)cone);
        }
    }

    public void attachLights(DudeModel avatar) {
        for (LightSource light : this.lights) {
            light.attachToBody(avatar.getBody(), light.getX(), light.getY(), light.getDirection());
        }
        if (this.lights.size > 0) {
            this.activeLight = 0;
            ((LightSource)this.lights.get(0)).setActive(true);
        } else {
            this.activeLight = -1;
        }
    }

    public void activateNextLight() {
        if (this.activeLight != -1) {
            ((LightSource)this.lights.get(this.activeLight)).setActive(false);
        }
        ++this.activeLight;
        if (this.activeLight >= this.lights.size) {
            this.activeLight = -1;
        } else {
            ((LightSource)this.lights.get(this.activeLight)).setActive(true);
        }
    }

    public void activatePrevLight() {
        if (this.activeLight != -1) {
            ((LightSource)this.lights.get(this.activeLight)).setActive(false);
        }
        --this.activeLight;
        if (this.activeLight < -1) {
            this.activeLight = this.lights.size - 1;
        } else if (this.activeLight > -1) {
            ((LightSource)this.lights.get(this.activeLight)).setActive(true);
        }
    }

    public void dispose() {
        for (LightSource light : this.lights) {
            light.remove();
        }
        this.lights.clear();
        if (this.rayhandler != null) {
            this.rayhandler.dispose();
            this.rayhandler = null;
        }
        for (Obstacle obj : this.objects) {
            obj.deactivatePhysics(this.world);
            obj.dispose();
        }
        this.objects.clear();
        if (this.world != null) {
            this.world.dispose();
            this.world = null;
        }
    }

    protected void activate(Obstacle obj) {
        assert (this.inBounds(obj)) : "Object is not in bounds";
        this.objects.add(obj);
        obj.activatePhysics(this.world);
    }

    private boolean inBounds(Obstacle obj) {
        boolean horiz = this.bounds.x <= obj.getX() && obj.getX() <= this.bounds.x + this.bounds.width;
        boolean vert = this.bounds.y <= obj.getY() && obj.getY() <= this.bounds.y + this.bounds.height;
        return horiz && vert;
    }

    public boolean update(float dt) {
        if (this.fixedStep(dt)) {
            if (this.rayhandler != null) {
                this.rayhandler.update();
            }
            this.avatar.update(dt);
            this.goalDoor.update(dt);
            return true;
        }
        return false;
    }

    private boolean fixedStep(float dt) {
        if (this.world == null) {
            return false;
        }
        this.physicsTimeLeft += dt;
        if (this.physicsTimeLeft > this.maxTimePerFrame) {
            this.physicsTimeLeft = this.maxTimePerFrame;
        }
        boolean stepped = false;
        while (this.physicsTimeLeft >= this.timeStep) {
            this.world.step(this.timeStep, 6, 2);
            this.physicsTimeLeft -= this.timeStep;
            stepped = true;
        }
        return stepped;
    }

    public void draw(ObstacleCanvas canvas) {
        canvas.clear();
        canvas.begin();
        for (Obstacle obj : this.objects) {
            obj.draw(canvas);
        }
        canvas.end();
        if (this.rayhandler != null && this.activeLight != -1) {
            this.rayhandler.render();
        }
        if (this.debug) {
            canvas.beginDebug();
            for (Obstacle obj : this.objects) {
                obj.drawDebug(canvas);
            }
            canvas.endDebug();
        }
    }

    public static short bitStringToShort(String s) {
        short value = 0;
        short pos = 1;
        for (int ii = s.length() - 1; ii >= 0; --ii) {
            if (s.charAt(ii) == '1') {
                value = (short)(value + pos);
            }
            pos = (short)(pos * 2);
        }
        return value;
    }

    public static short bitStringToComplement(String s) {
        short value = 0;
        short pos = 1;
        for (int ii = s.length() - 1; ii >= 0; --ii) {
            if (s.charAt(ii) == '0') {
                value = (short)(value + pos);
            }
            pos = (short)(pos * 2);
        }
        return value;
    }
}

