/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.b2lights;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.b2lights.LevelModel;
import edu.cornell.gdiac.physics.obstacle.BoxObstacle;
import edu.cornell.gdiac.physics.obstacle.ObstacleCanvas;
import java.lang.reflect.Field;

public class InteriorModel
extends BoxObstacle {
    protected PolygonRegion region = null;
    protected Vector2 anchor;
    protected Vector2 padding = new Vector2();

    public InteriorModel() {
        super(0.0f, 0.0f, 1.0f, 1.0f);
    }

    private void initRegion() {
        if (this.texture == null) {
            return;
        }
        float[] scaled = new float[this.vertices.length];
        for (int ii = 0; ii < scaled.length; ++ii) {
            scaled[ii] = ii % 2 == 0 ? (this.vertices[ii] + Math.signum(this.vertices[ii]) * this.padding.x + this.getX()) * this.drawScale.x : (this.vertices[ii] + Math.signum(this.vertices[ii]) * this.padding.y + this.getY()) * this.drawScale.y;
        }
        short[] tris = new short[]{0, 1, 3, 3, 2, 1};
        this.anchor = new Vector2(this.getX(), this.getY());
        this.region = new PolygonRegion(this.texture, scaled, tris);
    }

    @Override
    protected void resize(float width, float height) {
        super.resize(width, height);
        this.initRegion();
    }

    @Override
    public void setPosition(Vector2 value) {
        super.setPosition(value.x, value.y);
        this.initRegion();
    }

    @Override
    public void setPosition(float x, float y) {
        super.setPosition(x, y);
        this.initRegion();
    }

    @Override
    public void setX(float value) {
        super.setX(value);
        this.initRegion();
    }

    @Override
    public void setY(float value) {
        super.setY(value);
        this.initRegion();
    }

    @Override
    public void setAngle(float value) {
        throw new UnsupportedOperationException("Cannot rotate platforms");
    }

    @Override
    public void setTexture(TextureRegion value) {
        super.setTexture(value);
        this.initRegion();
    }

    @Override
    public void setDrawScale(float x, float y) {
        super.setDrawScale(x, y);
        this.initRegion();
    }

    public Vector2 getPadding() {
        return this.padding;
    }

    public void setPadding(Vector2 pad) {
        this.padding.set(pad);
        this.initRegion();
    }

    public void setPadding(float w, float h) {
        this.padding.set(w, h);
        this.initRegion();
    }

    public void initialize(AssetDirectory directory, JsonValue json) {
        Color debugColor;
        this.setName(json.name());
        float[] pos = json.get("pos").asFloatArray();
        float[] size = json.get("size").asFloatArray();
        float[] pad = json.get("pad").asFloatArray();
        this.setPosition(pos[0], pos[1]);
        this.setDimension(size[0], size[1]);
        this.setPadding(pad[0], pad[1]);
        this.setBodyType(json.get("bodytype").asString().equals("static") ? BodyDef.BodyType.StaticBody : BodyDef.BodyType.DynamicBody);
        this.setDensity(json.get("density").asFloat());
        this.setFriction(json.get("friction").asFloat());
        this.setRestitution(json.get("restitution").asFloat());
        short collideBits = LevelModel.bitStringToShort(json.get("collideBits").asString());
        short excludeBits = LevelModel.bitStringToComplement(json.get("excludeBits").asString());
        Filter filter = new Filter();
        filter.categoryBits = collideBits;
        filter.maskBits = excludeBits;
        this.setFilterData(filter);
        try {
            String cname = json.get("debugcolor").asString().toUpperCase();
            Field field = Class.forName("com.badlogic.gdx.graphics.Color").getField(cname);
            debugColor = new Color((Color)field.get(null));
        }
        catch (Exception e) {
            debugColor = null;
        }
        int opacity = json.get("debugopacity").asInt();
        debugColor.mul((float)opacity / 255.0f);
        this.setDebugColor(debugColor);
        String key = json.get("texture").asString();
        TextureRegion texture = new TextureRegion(directory.getEntry(key, Texture.class));
        this.setTexture(texture);
    }

    @Override
    public void draw(ObstacleCanvas canvas) {
        if (this.region != null) {
            canvas.draw(this.region, Color.WHITE, 0.0f, 0.0f, (this.getX() - this.anchor.x) * this.drawScale.x, (this.getY() - this.anchor.y) * this.drawScale.y, this.getAngle(), 1.0f, 1.0f);
        }
    }
}

