/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.b2lights;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.util.Controllers;
import edu.cornell.gdiac.util.XBoxController;

public class InputController {
    private static InputController theController = null;
    private boolean resetPressed;
    private boolean resetPrevious;
    private boolean nextPressed;
    private boolean nextPrevious;
    private boolean prevPressed;
    private boolean prevPrevious;
    private boolean debugPressed;
    private boolean debugPrevious;
    private boolean exitPressed;
    private boolean exitPrevious;
    private float horizontal;
    private float vertical;
    XBoxController xbox;

    public static InputController getInstance() {
        if (theController == null) {
            theController = new InputController();
        }
        return theController;
    }

    public float getHorizontal() {
        return this.horizontal;
    }

    public float getVertical() {
        return this.vertical;
    }

    public boolean didReset() {
        return this.resetPressed && !this.resetPrevious;
    }

    public boolean didForward() {
        return this.nextPressed && !this.nextPrevious;
    }

    public boolean didBack() {
        return this.prevPressed && !this.prevPrevious;
    }

    public boolean didDebug() {
        return this.debugPressed && !this.debugPrevious;
    }

    public boolean didExit() {
        return this.exitPressed && !this.exitPrevious;
    }

    public InputController() {
        Array<XBoxController> controllers = Controllers.get().getXBoxControllers();
        this.xbox = controllers.size > 0 ? (XBoxController)controllers.get(0) : null;
    }

    public void readInput() {
        this.resetPrevious = this.resetPressed;
        this.debugPrevious = this.debugPressed;
        this.exitPrevious = this.exitPressed;
        this.nextPrevious = this.nextPressed;
        this.prevPrevious = this.prevPressed;
        if (this.xbox != null && this.xbox.isConnected()) {
            this.readGamepad();
            this.readKeyboard(true);
        } else {
            this.readKeyboard(false);
        }
    }

    private void readGamepad() {
        this.resetPressed = this.xbox.getStart();
        this.exitPressed = this.xbox.getBack();
        this.nextPressed = this.xbox.getRBumper();
        this.prevPressed = this.xbox.getLBumper();
        this.debugPressed = this.xbox.getY();
        this.horizontal = this.xbox.getLeftX();
        this.vertical = this.xbox.getLeftY();
    }

    private void readKeyboard(boolean secondary) {
        this.resetPressed = secondary && this.resetPressed || Gdx.input.isKeyPressed(46);
        this.debugPressed = secondary && this.debugPressed || Gdx.input.isKeyPressed(32);
        this.prevPressed = secondary && this.prevPressed || Gdx.input.isKeyPressed(44);
        this.nextPressed = secondary && this.nextPressed || Gdx.input.isKeyPressed(42);
        this.exitPressed = secondary && this.exitPressed || Gdx.input.isKeyPressed(111);
        float f = this.horizontal = secondary ? this.horizontal : 0.0f;
        if (Gdx.input.isKeyPressed(22)) {
            this.horizontal += 1.0f;
        }
        if (Gdx.input.isKeyPressed(21)) {
            this.horizontal -= 1.0f;
        }
        float f2 = this.vertical = secondary ? this.vertical : 0.0f;
        if (Gdx.input.isKeyPressed(19)) {
            this.vertical += 1.0f;
        }
        if (Gdx.input.isKeyPressed(20)) {
            this.vertical -= 1.0f;
        }
    }
}

