/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.b2lights;

import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectSet;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.b2lights.DudeModel;
import edu.cornell.gdiac.b2lights.ExitModel;
import edu.cornell.gdiac.b2lights.InputController;
import edu.cornell.gdiac.b2lights.LevelModel;
import edu.cornell.gdiac.physics.obstacle.Obstacle;
import edu.cornell.gdiac.physics.obstacle.ObstacleCanvas;
import edu.cornell.gdiac.util.ScreenListener;

public class GameController
implements Screen,
ContactListener {
    protected AssetDirectory directory;
    private JsonValue levelFormat;
    protected BitmapFont displayFont;
    public static final int EXIT_QUIT = 0;
    public static final int EXIT_COUNT = 120;
    protected ObstacleCanvas canvas;
    private ScreenListener listener;
    protected LevelModel level;
    private boolean active = false;
    private boolean complete = false;
    private boolean failed = false;
    private int countdown = -1;
    protected ObjectSet<Fixture> sensorFixtures;
    private Vector2 angleCache = new Vector2();

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean value) {
        if (value) {
            this.countdown = 120;
        }
        this.complete = value;
    }

    public boolean isFailure() {
        return this.failed;
    }

    public void setFailure(boolean value) {
        if (value) {
            this.countdown = 120;
        }
        this.failed = value;
    }

    public boolean isActive() {
        return this.active;
    }

    public ObstacleCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(ObstacleCanvas canvas) {
        this.canvas = canvas;
    }

    public GameController() {
        this.level = new LevelModel();
        this.setComplete(false);
        this.setFailure(false);
    }

    public void dispose() {
        this.level.dispose();
        this.level = null;
        this.canvas = null;
    }

    public void gatherAssets(AssetDirectory directory) {
        this.directory = directory;
        this.displayFont = directory.getEntry("display", BitmapFont.class);
        this.levelFormat = directory.getEntry("level1", JsonValue.class);
    }

    public void reset() {
        this.level.dispose();
        this.setComplete(false);
        this.setFailure(false);
        this.countdown = -1;
        this.level.populate(this.directory, this.levelFormat);
        this.level.getWorld().setContactListener((ContactListener)this);
    }

    public boolean preUpdate(float dt) {
        InputController input = InputController.getInstance();
        input.readInput();
        if (this.listener == null) {
            return true;
        }
        if (input.didDebug()) {
            this.level.setDebug(!this.level.getDebug());
        }
        if (input.didReset()) {
            this.reset();
        }
        if (input.didExit()) {
            this.listener.exitScreen(this, 0);
            return false;
        }
        if (this.countdown > 0) {
            --this.countdown;
        } else if (this.countdown == 0) {
            this.reset();
        }
        return true;
    }

    public void update(float dt) {
        DudeModel avatar = this.level.getAvatar();
        InputController input = InputController.getInstance();
        if (input.didForward()) {
            this.level.activateNextLight();
        } else if (input.didBack()) {
            this.level.activatePrevLight();
        }
        this.angleCache.set(input.getHorizontal(), input.getVertical());
        if (this.angleCache.len2() > 0.0f) {
            float angle = this.angleCache.angle();
            angle = (float)Math.PI * (angle - 90.0f) / 180.0f;
            avatar.setAngle(angle);
        }
        this.angleCache.scl(avatar.getForce());
        avatar.setMovement(this.angleCache.x, this.angleCache.y);
        avatar.applyForce();
        this.level.update(dt);
    }

    public void draw(float delta) {
        this.canvas.clear();
        this.level.draw(this.canvas);
        if (this.complete && !this.failed) {
            this.displayFont.setColor(Color.YELLOW);
            this.canvas.begin();
            this.canvas.drawTextCentered("VICTORY!", this.displayFont, 0.0f);
            this.canvas.end();
        } else if (this.failed) {
            this.displayFont.setColor(Color.RED);
            this.canvas.begin();
            this.canvas.drawTextCentered("FAILURE!", this.displayFont, 0.0f);
            this.canvas.end();
        }
    }

    public void resize(int width, int height) {
    }

    public void render(float delta) {
        if (this.active) {
            if (this.preUpdate(delta)) {
                this.update(delta);
            }
            this.draw(delta);
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void show() {
        this.active = true;
    }

    public void hide() {
        this.active = false;
    }

    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }

    public void beginContact(Contact contact) {
        Fixture fix1 = contact.getFixtureA();
        Fixture fix2 = contact.getFixtureB();
        Body body1 = fix1.getBody();
        Body body2 = fix2.getBody();
        Object fd1 = fix1.getUserData();
        Object fd2 = fix2.getUserData();
        try {
            Obstacle bd1 = (Obstacle)body1.getUserData();
            Obstacle bd2 = (Obstacle)body2.getUserData();
            DudeModel avatar = this.level.getAvatar();
            ExitModel door = this.level.getExit();
            if (bd1 == avatar && bd2 == door || bd1 == door && bd2 == avatar) {
                this.setComplete(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endContact(Contact contact) {
    }

    public void postSolve(Contact contact, ContactImpulse impulse) {
    }

    public void preSolve(Contact contact, Manifold oldManifold) {
    }
}

