/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.b2lights;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ShortArray;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.b2lights.LevelModel;
import edu.cornell.gdiac.physics.obstacle.PolygonObstacle;
import java.lang.reflect.Field;

public class ExteriorModel
extends PolygonObstacle {
    public ExteriorModel() {
        super(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f}, 0.0f, 0.0f);
    }

    @Override
    protected void initShapes(float[] points) {
        this.initShapes(points, points);
    }

    protected void initShapes(float[] points, float[] padding) {
        int ii;
        this.dispose();
        ShortArray array = TRIANGULATOR.computeTriangles(points);
        this.trimColinear(points, array);
        this.tridx = new short[array.items.length];
        System.arraycopy(array.items, 0, this.tridx, 0, this.tridx.length);
        int tris = array.items.length / 3;
        this.vertices = new float[tris * 6];
        this.shapes = new PolygonShape[tris];
        this.geoms = new Fixture[tris];
        for (ii = 0; ii < tris; ++ii) {
            for (int jj = 0; jj < 3; ++jj) {
                this.vertices[6 * ii + 2 * jj] = points[2 * array.items[3 * ii + jj]];
                this.vertices[6 * ii + 2 * jj + 1] = points[2 * array.items[3 * ii + jj] + 1];
            }
            this.shapes[ii] = new PolygonShape();
            this.shapes[ii].set(this.vertices, 6 * ii, 6);
        }
        this.scaled = new float[padding.length];
        for (ii = 0; ii < padding.length; ii += 2) {
            this.scaled[ii] = padding[ii] * this.drawScale.x;
            this.scaled[ii + 1] = padding[ii + 1] * this.drawScale.y;
        }
        if (this.texture != null) {
            this.region = new PolygonRegion(this.texture, this.scaled, this.tridx);
        }
        this.markDirty(true);
    }

    public void initialize(AssetDirectory directory, JsonValue json) {
        Color debugColor;
        this.setName(json.name());
        float[] verts = json.get("boundary").asFloatArray();
        float[] pads = json.get("padding").asFloatArray();
        this.initShapes(verts, pads);
        this.setBodyType(json.get("bodytype").asString().equals("static") ? BodyDef.BodyType.StaticBody : BodyDef.BodyType.DynamicBody);
        this.setDensity(json.get("density").asFloat());
        this.setFriction(json.get("friction").asFloat());
        this.setRestitution(json.get("restitution").asFloat());
        short collideBits = LevelModel.bitStringToShort(json.get("collideBits").asString());
        short excludeBits = LevelModel.bitStringToComplement(json.get("excludeBits").asString());
        Filter filter = new Filter();
        filter.categoryBits = collideBits;
        filter.maskBits = excludeBits;
        this.setFilterData(filter);
        try {
            String cname = json.get("debugcolor").asString().toUpperCase();
            Field field = Class.forName("com.badlogic.gdx.graphics.Color").getField(cname);
            debugColor = new Color((Color)field.get(null));
        }
        catch (Exception e) {
            debugColor = null;
        }
        int opacity = json.get("debugopacity").asInt();
        debugColor.mul((float)opacity / 255.0f);
        this.setDebugColor(debugColor);
        String key = json.get("texture").asString();
        TextureRegion texture = new TextureRegion(directory.getEntry(key, Texture.class));
        this.setTexture(texture);
    }
}

