/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.b2lights;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.b2lights.LevelModel;
import edu.cornell.gdiac.physics.obstacle.BoxObstacle;
import java.lang.reflect.Field;

public class ExitModel
extends BoxObstacle {
    public ExitModel() {
        super(0.0f, 0.0f, 1.0f, 1.0f);
        this.setSensor(true);
    }

    public void initialize(AssetDirectory directory, JsonValue json) {
        Color debugColor;
        this.setName(json.name());
        float[] pos = json.get("pos").asFloatArray();
        float[] size = json.get("size").asFloatArray();
        this.setPosition(pos[0], pos[1]);
        this.setDimension(size[0], size[1]);
        this.setBodyType(json.get("bodytype").asString().equals("static") ? BodyDef.BodyType.StaticBody : BodyDef.BodyType.DynamicBody);
        this.setDensity(json.get("density").asFloat());
        this.setFriction(json.get("friction").asFloat());
        this.setRestitution(json.get("restitution").asFloat());
        short collideBits = LevelModel.bitStringToShort(json.get("collideBits").asString());
        short excludeBits = LevelModel.bitStringToComplement(json.get("excludeBits").asString());
        Filter filter = new Filter();
        filter.categoryBits = collideBits;
        filter.maskBits = excludeBits;
        this.setFilterData(filter);
        try {
            String cname = json.get("debugcolor").asString().toUpperCase();
            Field field = Class.forName("com.badlogic.gdx.graphics.Color").getField(cname);
            debugColor = new Color((Color)field.get(null));
        }
        catch (Exception e) {
            debugColor = null;
        }
        int opacity = json.get("debugopacity").asInt();
        debugColor.mul((float)opacity / 255.0f);
        this.setDebugColor(debugColor);
        String key = json.get("texture").asString();
        TextureRegion texture = new TextureRegion(directory.getEntry(key, Texture.class));
        this.setTexture(texture);
    }
}

