/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.b2lights;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.b2lights.LevelModel;
import edu.cornell.gdiac.physics.obstacle.ObstacleCanvas;
import edu.cornell.gdiac.physics.obstacle.WheelObstacle;
import edu.cornell.gdiac.util.FilmStrip;
import java.lang.reflect.Field;

public class DudeModel
extends WheelObstacle {
    private float force;
    private float damping;
    private float maxspeed;
    private Vector2 movement = new Vector2();
    private boolean animate = false;
    private int walkCool;
    private int walkLimit;
    private FilmStrip filmstrip;
    private int startFrame;
    private Vector2 center;
    private Vector2 forceCache = new Vector2();

    public Vector2 getMovement() {
        return this.movement;
    }

    public void setMovement(Vector2 value) {
        this.setMovement(value.x, value.y);
    }

    public void setMovement(float dx, float dy) {
        this.movement.set(dx, dy);
    }

    public float getForce() {
        return this.force;
    }

    public void setForce(float value) {
        this.force = value;
    }

    public float getDamping() {
        return this.damping;
    }

    public void setDamping(float value) {
        this.damping = value;
    }

    public float getMaxSpeed() {
        return this.maxspeed;
    }

    public void setMaxSpeed(float value) {
        this.maxspeed = value;
    }

    public float getStartFrame() {
        return this.startFrame;
    }

    public void setStartFrame(int value) {
        this.startFrame = value;
    }

    public int getWalkLimit() {
        return this.walkLimit;
    }

    public void setWalkLimit(int value) {
        this.walkLimit = value;
    }

    public DudeModel() {
        super(0.0f, 0.0f, 1.0f);
        this.setFixedRotation(false);
    }

    public void initialize(AssetDirectory directory, JsonValue json) {
        Color debugColor;
        this.setName(json.name());
        float[] pos = json.get("pos").asFloatArray();
        float radius = json.get("radius").asFloat();
        this.setPosition(pos[0], pos[1]);
        this.setRadius(radius);
        this.setBodyType(json.get("bodytype").asString().equals("static") ? BodyDef.BodyType.StaticBody : BodyDef.BodyType.DynamicBody);
        this.setDensity(json.get("density").asFloat());
        this.setFriction(json.get("friction").asFloat());
        this.setRestitution(json.get("restitution").asFloat());
        this.setForce(json.get("force").asFloat());
        this.setDamping(json.get("damping").asFloat());
        this.setMaxSpeed(json.get("maxspeed").asFloat());
        this.setStartFrame(json.get("startframe").asInt());
        this.setWalkLimit(json.get("walklimit").asInt());
        short collideBits = LevelModel.bitStringToShort(json.get("collideBits").asString());
        short excludeBits = LevelModel.bitStringToComplement(json.get("excludeBits").asString());
        Filter filter = new Filter();
        filter.categoryBits = collideBits;
        filter.maskBits = excludeBits;
        this.setFilterData(filter);
        try {
            String cname = json.get("debugcolor").asString().toUpperCase();
            Field field = Class.forName("com.badlogic.gdx.graphics.Color").getField(cname);
            debugColor = new Color((Color)field.get(null));
        }
        catch (Exception e) {
            debugColor = null;
        }
        int opacity = json.get("debugopacity").asInt();
        debugColor.mul((float)opacity / 255.0f);
        this.setDebugColor(debugColor);
        String key = json.get("texture").asString();
        this.filmstrip = directory.getEntry(key, FilmStrip.class);
        this.center = new Vector2((float)(this.filmstrip.getRegionWidth() / 2), (float)(this.filmstrip.getRegionHeight() / 2));
    }

    public void applyForce() {
        if (!this.isActive()) {
            return;
        }
        this.setLinearVelocity(Vector2.Zero);
        this.setAngularVelocity(0.0f);
        if (this.getMovement().len2() > 0.0f) {
            this.forceCache.set(this.getMovement());
            this.body.applyForce(this.forceCache, this.getPosition(), true);
            this.animate = true;
        } else {
            this.animate = false;
        }
    }

    @Override
    public void update(float dt) {
        if (this.animate && this.walkCool == 0) {
            if (this.filmstrip != null) {
                int next = (this.filmstrip.getFrame() + 1) % this.filmstrip.getSize();
                this.filmstrip.setFrame(next);
            }
            this.walkCool = this.walkLimit;
        } else if (this.walkCool > 0) {
            --this.walkCool;
        } else if (!this.animate) {
            if (this.filmstrip != null) {
                this.filmstrip.setFrame(this.startFrame);
            }
            this.walkCool = 0;
        }
        super.update(dt);
    }

    @Override
    public void draw(ObstacleCanvas canvas) {
        if (this.filmstrip != null) {
            canvas.draw(this.filmstrip, Color.WHITE, this.center.x, this.center.y, this.getX() * this.drawScale.x, this.getY() * this.drawScale.y, this.getAngle(), 1.0f, 1.0f);
        }
    }
}

