/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.assets.TextureRegionLoader;

public class TextureRegionParser
implements AssetParser<TextureRegion> {
    private JsonValue root;
    private JsonValue atlas;
    public static char ALIAS_SEP = (char)58;
    private static char ALIAS_MASK = (char)8704;

    @Override
    public Class<TextureRegion> getType() {
        return TextureRegion.class;
    }

    @Override
    public void reset(JsonValue directory) {
        this.root = directory;
        this.root = this.root.getChild("textures");
        this.atlas = null;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.atlas != null;
    }

    @Override
    public void processNext(AssetManager manager, ObjectMap<String, String> keymap) {
        String file = this.root.getString("file", null);
        if (file == null) {
            this.advance();
            return;
        }
        TextureRegionLoader.TextureRegionParameters params = new TextureRegionLoader.TextureRegionParameters(file);
        if (this.atlas.size < 4) {
            throw new GdxRuntimeException("Rectangle " + this.atlas + " is not valid");
        }
        params.x = this.atlas.getInt(0);
        params.y = this.atlas.getInt(1);
        params.width = this.atlas.getInt(2);
        params.height = this.atlas.getInt(3);
        params.width = params.width == -1 ? -1 : params.width - params.x;
        params.height = params.height == -1 ? -1 : params.height - params.y;
        String region = ParserUtils.safeConcatenate(file, this.atlas.name(), ALIAS_SEP, ALIAS_MASK);
        keymap.put((Object)(this.root.name() + "." + this.atlas.name()), (Object)region);
        manager.load(region, TextureRegion.class, (AssetLoaderParameters)params);
        this.advance();
    }

    public boolean equals(Object o) {
        return o instanceof TextureRegionParser;
    }

    private void advance() {
        if (this.atlas != null) {
            this.atlas = this.atlas.next();
            if (this.atlas == null) {
                this.root = this.root.next();
            }
        }
        while (this.atlas == null && this.root != null) {
            if (this.root.hasChild("atlas")) {
                this.atlas = this.root.getChild("atlas");
                continue;
            }
            this.root = this.root.next();
        }
    }
}

