/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import edu.cornell.gdiac.assets.FilmStripParser;
import edu.cornell.gdiac.util.FilmStrip;

public class FilmStripLoader
extends AsynchronousAssetLoader<FilmStrip, FilmStripParameters> {
    protected FileHandleResolver resolver;
    private FilmStrip cachedSprite;

    public FilmStripLoader() {
        this((FileHandleResolver)new InternalFileHandleResolver());
    }

    public FilmStripLoader(FileHandleResolver resolver) {
        super(resolver);
        this.resolver = resolver;
    }

    protected FilmStrip getLoadedSprite() {
        return this.cachedSprite;
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, FilmStripParameters params) {
        Texture texture = (Texture)manager.get((String)manager.getDependencies(fileName).first());
        this.cachedSprite = this.load(texture, params);
    }

    public FilmStrip loadSync(AssetManager manager, String fileName, FileHandle file, FilmStripParameters params) {
        FilmStrip region = this.cachedSprite;
        this.cachedSprite = null;
        return region;
    }

    public FileHandle resolve(String fileName) {
        int suffix = fileName.lastIndexOf(FilmStripParser.ALIAS_SEP);
        if (suffix == -1) {
            throw new GdxRuntimeException("Texture region file name must end in " + FilmStripParser.ALIAS_SEP + "name'.");
        }
        String prefix = fileName.substring(0, suffix);
        return this.resolver.resolve(prefix);
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, FilmStripParameters params) {
        if (params == null) {
            int suffix = fileName.lastIndexOf(FilmStripParser.ALIAS_SEP);
            String prefix = suffix == -1 ? fileName : fileName.substring(0, suffix);
            params = new FilmStripParameters(prefix);
        }
        Array deps = new Array(1);
        deps.add((Object)new AssetDescriptor(params.source, Texture.class));
        return deps;
    }

    public FilmStrip load(Texture texture, FilmStripParameters params) {
        if (params == null) {
            return new FilmStrip(texture, 1, 1);
        }
        int w = params.width == -1 ? texture.getWidth() - params.x : params.width;
        int h = params.height == -1 ? texture.getHeight() - params.y : params.height;
        FilmStrip result = new FilmStrip(texture, params.rows, params.cols, params.size, params.x, params.y, w, h);
        result.setFrame(params.frame);
        return result;
    }

    public static class FilmStripParameters
    extends AssetLoaderParameters<FilmStrip> {
        public String source;
        public int rows = 1;
        public int cols = 1;
        public int size = 1;
        public int frame = 0;
        public int x = 0;
        public int y = 0;
        public int width = -1;
        public int height = -1;

        public FilmStripParameters(String fileName) {
            this.source = fileName;
        }

        public FilmStripParameters(String fileName, int rows, int cols) {
            this.source = fileName;
            this.rows = rows;
            this.cols = cols;
            this.size = rows * cols;
        }

        public FilmStripParameters(String fileName, int rows, int cols, int size) {
            this.source = fileName;
            this.rows = rows;
            this.cols = cols;
            this.size = size;
        }
    }
}

