/* TemperatureView.java
 *
 * Walker M. White
 * September 22, 2002
 */
package converter;

import java.awt.*;
import javax.swing.*;

/**
 * This is the VIEW for the TemperatureConverter application.  The
 * view must do all of the following:
 * <ul>
 * <li>Instantiate the window and all of the graphical components.</li>
 * <li>Position all of the graphical components.</li>
 * </ul>
 * 
 * Note that the view does very little else.  Furthermore, it does not
 * have a main method to start up the application.  That is the job
 * of the controller.
 * 
 * @author  Walker M. White
 * @version 9/22/2002
 */
public class TemperatureView extends javax.swing.JFrame {

    /** The graphical components. */
    private javax.swing.JLabel fahrenheitLabel;
    private javax.swing.JTextField fahrenheitField;
    private javax.swing.JLabel centigradeLabel;
    private javax.swing.JTextField centigradeField;
    
    
    /** Constructor: a new TemperatureConverter GUI */
    public TemperatureView() {
        initializeView();
        pack();
    }

    /**
     * Initialize all the GUI components and lay them out in the Frame.
     */    
    public void initializeView() {
        /** Initialize the components */
        fahrenheitLabel  = new javax.swing.JLabel();
        fahrenheitField  = new javax.swing.JTextField();
        centigradeLabel = new javax.swing.JLabel();
        centigradeField = new javax.swing.JTextField();
        
        /** Lay everything out nicely with GridBagLayout */
        getContentPane().setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setTitle("Temperature Converter");
        setDefaultCloseOperation(EXIT_ON_CLOSE );
        
        fahrenheitLabel.setText("Fahrenheit");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(0, 15, 0, 5);
        getContentPane().add(fahrenheitLabel, gridBagConstraints1);
        
        fahrenheitField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        fahrenheitField.setMinimumSize(new java.awt.Dimension(60, 21));
        fahrenheitField.setPreferredSize(new java.awt.Dimension(60, 21));
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        getContentPane().add(fahrenheitField, gridBagConstraints1);
        
        centigradeLabel.setText("Centigrade");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(10, 10, 10, 5);
        getContentPane().add(centigradeLabel, gridBagConstraints1);
        
        centigradeField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        centigradeField.setMinimumSize(new java.awt.Dimension(60, 21));
        centigradeField.setPreferredSize(new java.awt.Dimension(60, 21));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(0, 0, 0, 15);
        getContentPane().add(centigradeField, gridBagConstraints1);
    }
    
    /** 
     * Yields: the GUI component for storing fahrenheit
     */
    public JTextField getFahrenheitField() {
        return fahrenheitField;
    }

    /** 
     * Yields: the GUI component for storing fahrenheit
     */
    public JTextField getCentigradeField() {
        return centigradeField;
    }

}
