# GDIAC Audio Classes

These files provide support for the GDIAC audio extensions for LibGDX.  If you based your game on the Lab4 architecture, you may already have these files installed.  *However* we have made several bug fixes to the backend which affect how music is processed.  You may wish to replace your backend with these latest files.

## Using the GDIAC Classes

To use the GDIAC audio classes, you will need to do three things.

1. Install the backend classes in `desktop/src`
2. Install the frontend classes in `core/src`
3. Make sure you use `GDXApp` and not `LWJGLApplication`

The last bullet point is important.  In the `DesktopLauncher` class, you create an application object for your game.  In some labs it is `LWJGLApplication`.  In others it is `GDXApp`.  Only `GDXApp` enables the new sound backend.

This is all you need to do.  To access the new features, simply typecase the singleton `GDX.audio`
to the `AudioEngine` interface provided in the frontend classes.

## The SoundController Class

There is one new class in frontend code that you will not have seen before in the game labs.  This class is called `SoundController`. This class is the pseudo-dictionary that manages sounds using keys instead of id numbers.  It is the class talked about in the lecture video.