/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import potential.TabComponent;
import potential.Vector3d;
import potential.VehiclePanelController;

public class VehiclePanel
extends TabComponent {
    private VehiclePanelController controller;
    private JTextField xCoordinateField;
    private JTextField yCoordinateField;
    private JButton deleteButton;
    private JSlider vehicleRadiusSlider;
    private JSlider vehicleChargeSlider;
    private JSlider vehicleMassSlider;
    private JSlider vehicleDampingSlider;
    private JSlider vehicleMaximumSlider;

    public VehiclePanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        JLabel jLabel = new JLabel("Vehicle Location: ");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.xCoordinateField = this.addField("x  ", 3, jPanel2);
        this.xCoordinateField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VehiclePanel.this.controller != null) {
                    try {
                        float f = Float.valueOf(VehiclePanel.this.xCoordinateField.getText()).floatValue();
                        VehiclePanel.this.xCoordinateField.setText(String.format("%.2f", Float.valueOf(f)));
                        VehiclePanel.this.recalculatePosition();
                    }
                    catch (NumberFormatException numberFormatException) {
                        Vector3d vector3d = VehiclePanel.this.controller.getSelectedVehiclePosition();
                        VehiclePanel.this.xCoordinateField.setText(vector3d == null ? "" : String.format("%.2f", Float.valueOf(vector3d.x)));
                    }
                }
            }
        });
        this.yCoordinateField = this.addField("y  ", 3, jPanel2);
        this.yCoordinateField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VehiclePanel.this.controller != null) {
                    try {
                        float f = Float.valueOf(VehiclePanel.this.yCoordinateField.getText()).floatValue();
                        VehiclePanel.this.yCoordinateField.setText(String.format("%.2f", Float.valueOf(f)));
                        VehiclePanel.this.recalculatePosition();
                    }
                    catch (NumberFormatException numberFormatException) {
                        Vector3d vector3d = VehiclePanel.this.controller.getSelectedVehiclePosition();
                        VehiclePanel.this.yCoordinateField.setText(vector3d == null ? "" : String.format("%.2f", Float.valueOf(vector3d.y)));
                    }
                }
            }
        });
        this.deleteButton = new JButton("Clear");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VehiclePanel.this.controller != null) {
                    VehiclePanel.this.controller.deleteSelectedVehicle();
                    VehiclePanel.this.xCoordinateField.setText("");
                    VehiclePanel.this.yCoordinateField.setText("");
                }
            }
        });
        jPanel2.add(this.deleteButton);
        jPanel.add(jLabel);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.vehicleRadiusSlider = this.addSlider("Vehicle Radius: ", this.floatToTick(0.5f, 0.0f, 10.0f), jPanel3);
        this.vehicleRadiusSlider.setLabelTable(this.createLabels(0.0f, 10.0f));
        this.vehicleRadiusSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (VehiclePanel.this.controller != null) {
                    VehiclePanel.this.controller.setSelectedVehicleRadius(VehiclePanel.this.tickToFloat(VehiclePanel.this.vehicleRadiusSlider.getValue(), 0.0f, 10.0f));
                }
            }
        });
        this.vehicleMassSlider = this.addSlider("Vehicle Mass: ", this.floatToTick(1.0f, 0.0f, 20.0f), jPanel3);
        this.vehicleMassSlider.setLabelTable(this.createLabels(0.0f, 20.0f));
        this.vehicleMassSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (VehiclePanel.this.controller != null) {
                    VehiclePanel.this.controller.setSelectedVehicleMass(VehiclePanel.this.tickToFloat(VehiclePanel.this.vehicleMassSlider.getValue(), 0.0f, 20.0f));
                }
            }
        });
        this.vehicleChargeSlider = this.addSlider("Vehicle Charge: ", this.doubleToTick(0.25, 0.0, 1.0), jPanel3);
        this.vehicleChargeSlider.setLabelTable(this.createLabels(0.0, 1.0));
        this.vehicleChargeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (VehiclePanel.this.controller != null) {
                    VehiclePanel.this.controller.setSelectedVehicleCharge(VehiclePanel.this.tickToDouble(VehiclePanel.this.vehicleChargeSlider.getValue(), 0.0, 1.0));
                }
            }
        });
        this.vehicleDampingSlider = this.addSlider("Vehicle Damping: ", this.floatToTick(0.75f, 0.0f, 1.0f), jPanel3);
        this.vehicleDampingSlider.setLabelTable(this.createLabels(0.0f, 1.0f));
        this.vehicleDampingSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (VehiclePanel.this.controller != null) {
                    VehiclePanel.this.controller.setSelectedVehicleDamping(VehiclePanel.this.tickToFloat(VehiclePanel.this.vehicleDampingSlider.getValue(), 0.0f, 1.0f));
                }
            }
        });
        this.vehicleMaximumSlider = this.addSlider("Vehicle Maximum Speed: ", this.floatToTick(0.6f, 0.0f, 2.0f), jPanel3);
        this.vehicleMaximumSlider.setLabelTable(this.createLabels(0.0f, 2.0f));
        this.vehicleMaximumSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (VehiclePanel.this.controller != null) {
                    VehiclePanel.this.controller.setSelectedVehicleMaximumSpeed(VehiclePanel.this.tickToFloat(VehiclePanel.this.vehicleMaximumSlider.getValue(), 0.0f, 2.0f));
                }
            }
        });
        this.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JTextArea jTextArea = this.addArea("Instructions: ", 10, 20, jPanel4);
        jTextArea.setText("To create a new vehicle, Control-click\non its desired position.  Use a regular\nclick to select an existing vehicle for\nediting. A selected vehicle is indicated\nby a heavier border.\n\nOnly one vehicle may be selected at a\ntime.  A selected vehicle is pinned and\nwill not move, but will still exert a\nforce for ovoidance.");
        jTextArea.setEditable(false);
        jTextArea.setEnabled(false);
        jTextArea.setDisabledTextColor(Color.black);
        this.add((Component)jPanel4, "South");
    }

    public void update() {
        if (this.controller != null) {
            this.vehicleRadiusSlider.setValue(this.floatToTick(this.controller.getSelectedVehicleRadius(), 0.0f, 10.0f));
            this.vehicleMassSlider.setValue(this.floatToTick(this.controller.getSelectedVehicleMass(), 0.0f, 20.0f));
            this.vehicleChargeSlider.setValue(this.doubleToTick(this.controller.getSelectedVehicleCharge(), 0.0, 1.0));
            this.vehicleDampingSlider.setValue(this.floatToTick(this.controller.getSelectedVehicleDamping(), 0.0f, 1.0f));
            this.vehicleMaximumSlider.setValue(this.floatToTick(this.controller.getSelectedVehicleMaximumSpeed(), 0.0f, 2.0f));
            Vector3d vector3d = this.controller.getSelectedVehiclePosition();
            if (vector3d == null) {
                this.xCoordinateField.setText("");
                this.yCoordinateField.setText("");
            } else {
                this.xCoordinateField.setText(String.format("%.2f", Float.valueOf(vector3d.x)));
                this.yCoordinateField.setText(String.format("%.2f", Float.valueOf(vector3d.y)));
            }
        }
    }

    public void setController(VehiclePanelController vehiclePanelController) {
        this.controller = vehiclePanelController;
        this.update();
    }

    public VehiclePanelController getController() {
        return this.controller;
    }

    private void recalculatePosition() {
        try {
            float f = Float.valueOf(this.xCoordinateField.getText()).floatValue();
            float f2 = Float.valueOf(this.yCoordinateField.getText()).floatValue();
            this.controller.setSelectedVehiclePosition(new Vector3d(f, f2, 0.0f));
        }
        catch (NumberFormatException numberFormatException) {
            this.controller.deleteSelectedVehicle();
        }
    }
}

