/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.util.Random;

public class Vector3d {
    public static final float DOUBLE_PI = (float)Math.PI * 2;
    public float x;
    public float y;
    public float z;
    public static final Vector3d zero = new Vector3d();

    public Vector3d() {
        this.setZero();
    }

    public Vector3d(float f, float f2, float f3) {
        this.set(f, f2, f3);
    }

    public Vector3d(Vector3d vector3d) {
        this.set(vector3d);
    }

    public float magnitude() {
        return (float)Math.sqrt(this.magnitudeSquared());
    }

    public static final float magnitude(float f, float f2, float f3) {
        return (float)Math.sqrt(Vector3d.magnitudeSquared(f, f2, f3));
    }

    public float magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public static final float magnitudeSquared(float f, float f2, float f3) {
        return f * f + f2 * f2 + f3 * f3;
    }

    public float dot(Vector3d vector3d) {
        return this.x * vector3d.x + this.y * vector3d.y + this.z * vector3d.z;
    }

    public float dot(float f, float f2, float f3) {
        return this.x * f + this.y * f2 + this.z * f3;
    }

    public float approximateLength() {
        float f;
        float f2;
        float f3;
        float f4 = this.x;
        if (f4 < 0.0f) {
            f4 = -f4;
        }
        if ((f3 = this.y) < 0.0f) {
            f3 = -f3;
        }
        if ((f2 = this.z) < 0.0f) {
            f2 = -f2;
        }
        if (f4 < f3) {
            f = f4;
            f4 = f3;
            f3 = f;
        }
        if (f4 < f2) {
            f = f4;
            f4 = f2;
            f2 = f;
        }
        return f4 * 0.9375f + (f3 + f2) * 0.375f;
    }

    public static final float approximateLength(float f, float f2, float f3) {
        float f4;
        float f5;
        float f6;
        float f7 = f;
        if (f7 < 0.0f) {
            f7 = -f7;
        }
        if ((f6 = f2) < 0.0f) {
            f6 = -f6;
        }
        if ((f5 = f3) < 0.0f) {
            f5 = -f5;
        }
        if (f7 < f6) {
            f4 = f7;
            f7 = f6;
            f6 = f4;
        }
        if (f7 < f5) {
            f4 = f7;
            f7 = f5;
            f5 = f4;
        }
        return f7 * 0.9375f + (f6 + f5) * 0.375f;
    }

    public float distance(Vector3d vector3d) {
        return Vector3d.magnitude(this.x - vector3d.x, this.y - vector3d.y, this.z - vector3d.z);
    }

    public float distance(float f, float f2, float f3) {
        return Vector3d.magnitude(this.x - f, this.y - f2, this.z - f3);
    }

    public float approximateDistance(Vector3d vector3d) {
        return Vector3d.approximateLength(this.x - vector3d.x, this.y - vector3d.y, this.z - vector3d.z);
    }

    public float approximateDistance(float f, float f2, float f3) {
        return Vector3d.approximateLength(this.x - f, this.y - f2, this.z - f3);
    }

    public Vector3d copy() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public void set(Vector3d vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
    }

    public void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public void setZero() {
        this.set(0.0f, 0.0f, 0.0f);
    }

    public void setUnitRandom(Random random) {
        float f = random.nextFloat() * ((float)Math.PI * 2);
        float f2 = random.nextFloat() * ((float)Math.PI * 2);
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.cos(f);
        float f5 = (float)Math.sin(f2);
        float f6 = (float)Math.sin(f);
        this.x = f4 * f5;
        this.y = f6 * f5;
        this.z = f3;
    }

    public void setRandom(Random random) {
        float f = random.nextFloat();
        float f2 = random.nextFloat() * ((float)Math.PI * 2);
        float f3 = random.nextFloat() * ((float)Math.PI * 2);
        float f4 = (float)Math.cos(f3);
        float f5 = (float)Math.cos(f2);
        float f6 = (float)Math.sin(f3);
        float f7 = (float)Math.sin(f2);
        this.x = f * f5 * f6;
        this.y = f * f7 * f6;
        this.z = f * f4;
    }

    public void setSum(Vector3d vector3d, Vector3d vector3d2) {
        this.x = vector3d.x + vector3d2.x;
        this.y = vector3d.y + vector3d2.y;
        this.z = vector3d.z + vector3d2.z;
    }

    public void setDifference(Vector3d vector3d, Vector3d vector3d2) {
        this.x = vector3d.x - vector3d2.x;
        this.y = vector3d.y - vector3d2.y;
        this.z = vector3d.z - vector3d2.z;
    }

    public void setScale(float f, Vector3d vector3d) {
        this.x = f * vector3d.x;
        this.y = f * vector3d.y;
        this.z = f * vector3d.z;
    }

    public void setCross(Vector3d vector3d, Vector3d vector3d2) {
        this.set(vector3d.y * vector3d2.z - vector3d.z * vector3d2.y, vector3d.z * vector3d2.x - vector3d.x * vector3d2.z, vector3d.x * vector3d2.y - vector3d.y * vector3d2.x);
    }

    public void setInterpolation(float f, Vector3d vector3d, Vector3d vector3d2) {
        this.x = vector3d.x + f * (vector3d2.x - vector3d.x);
        this.y = vector3d.y + f * (vector3d2.y - vector3d.y);
        this.z = vector3d.z + f * (vector3d2.z - vector3d.z);
    }

    public void setNormalized() {
        float f = this.magnitude();
        if (f != 0.0f) {
            this.setScale(1.0f / f, this);
        }
    }

    public void setApproximateNormalize() {
        float f = this.approximateLength();
        if (f != 0.0f) {
            this.setScale(1.0f / f, this);
        }
    }

    public void setApproximateTruncate(float f) {
        float f2 = this.approximateLength();
        if (f2 > f) {
            this.setScale(f / f2, this);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector3d)) {
            return false;
        }
        return this.equals((Vector3d)object);
    }

    public boolean equals(Vector3d vector3d) {
        return this.x == vector3d.x && this.y == vector3d.y && this.z == vector3d.z;
    }

    public boolean equalsZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.z) + 983 * Float.floatToIntBits(this.y) + 966289 * Float.floatToIntBits(this.x);
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }
}

