/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.Color;
import java.awt.Graphics2D;
import potential.DrawingContext;
import potential.Vector3d;

public class TerrainObject {
    public static final float WEIGHT_NORMAL = 1.0f;
    public static final float WEIGHT_HEAVY = 2.0f;
    public static final Color NORMAL_LINE_COLOR = new Color(0.2f, 0.2f, 0.2f);
    public static final Color NORMAL_FILL_COLOR = new Color(0.7f, 0.7f, 0.7f);
    public static final Color IMPACT_LINE_COLOR = new Color(0.3f, 0.0f, 0.0f);
    public static final Color IMPACT_FILL_COLOR = new Color(1.0f, 0.5f, 0.5f);
    public static final Vector3d GLOBAL_UP = new Vector3d(0.0f, 0.1f, 0.0f);
    public static final float DEFAULT_RADIUS = 0.5f;
    protected Vector3d position;
    protected Vector3d forward;
    protected Vector3d side;
    protected Vector3d up;
    protected float radius;
    protected double charge;
    protected boolean touched = false;
    protected boolean selected = false;

    public TerrainObject() {
        this(new Vector3d(0.0f, 0.0f, 0.0f), 0.5f);
    }

    public TerrainObject(Vector3d vector3d) {
        this(vector3d, 0.5f);
    }

    public TerrainObject(Vector3d vector3d, float f) {
        this.position = vector3d.copy();
        this.setRadius(f);
        this.setCharge(f * f);
        this.initializeFacing();
    }

    private void initializeFacing() {
        this.forward = new Vector3d(0.0f, 0.0f, 1.0f);
        this.side = new Vector3d(1.0f, 0.0f, 0.0f);
        this.up = new Vector3d(0.0f, 1.0f, 0.0f);
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public double getCharge() {
        return this.charge;
    }

    public void setCharge(double d) {
        this.charge = d;
    }

    public final Vector3d getPosition() {
        return this.position;
    }

    public final void setPosition(Vector3d vector3d) {
        this.position.set(vector3d);
    }

    public final Vector3d getForward() {
        return this.forward;
    }

    public final void setForward(Vector3d vector3d) {
        this.forward.set(vector3d);
    }

    public final Vector3d getLateral() {
        return this.side;
    }

    public final void setLateral(Vector3d vector3d) {
        this.side.set(vector3d);
    }

    public boolean isTouched() {
        return this.touched;
    }

    public void setTouched(boolean bl) {
        this.touched = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean contains(Vector3d vector3d) {
        float f = vector3d.x - this.position.x;
        float f2 = vector3d.y - this.position.y;
        float f3 = vector3d.z - this.position.z;
        return Math.sqrt(f * f + f2 * f2 + f3 * f3) <= (double)this.radius;
    }

    public void globalizePosition(Vector3d vector3d, Vector3d vector3d2) {
        this.globalizeDirection(vector3d, vector3d2);
        vector3d2.setSum(vector3d2, this.position);
    }

    public void globalizeDirection(Vector3d vector3d, Vector3d vector3d2) {
        float f = vector3d.x * this.side.x + vector3d.y * this.up.x + vector3d.z * this.forward.x;
        float f2 = vector3d.x * this.side.y + vector3d.y * this.up.y + vector3d.z * this.forward.y;
        float f3 = vector3d.x * this.side.z + vector3d.y * this.up.z + vector3d.z * this.forward.z;
        vector3d2.set(f, f2, f3);
    }

    public void localizePosition(Vector3d vector3d, Vector3d vector3d2) {
        vector3d2.setDifference(vector3d, this.position);
        vector3d2.set(vector3d2.dot(this.side), vector3d2.dot(this.up), vector3d2.dot(this.forward));
    }

    public void draw(Graphics2D graphics2D, DrawingContext drawingContext) {
        Color color = this.touched ? IMPACT_FILL_COLOR : NORMAL_FILL_COLOR;
        Color color2 = this.touched ? IMPACT_LINE_COLOR : NORMAL_LINE_COLOR;
        drawingContext.setWeight(this.selected ? 2.0f : 1.0f);
        drawingContext.outlineCircle(graphics2D, this.position, this.radius, color, color2);
    }
}

