/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import potential.Constants;
import potential.DrawingContext;
import potential.StandardAttractionPotentialFunction;
import potential.StandardAvoidancePotentialFunction;
import potential.Target;
import potential.TerrainObject;
import potential.Vector3d;
import potential.Vehicle;

public class Terrain
implements Constants {
    public static final float EPSILON = 1.0E-4f;
    protected Dimension size;
    protected Random generator;
    protected TerrainObject selection;
    protected Target target;
    protected LinkedList<Vehicle> vehicles = new LinkedList();
    protected LinkedList<TerrainObject> obstacles = new LinkedList();
    private StandardAttractionPotentialFunction attraction = new StandardAttractionPotentialFunction();
    private StandardAvoidancePotentialFunction repulsion = new StandardAvoidancePotentialFunction();

    public Terrain() {
        this(20.0, 20.0);
    }

    public Terrain(Dimension dimension) {
        this(dimension.getWidth(), dimension.getHeight());
    }

    public Terrain(double d, double d2) {
        this.target = new Target();
        this.target.setActive(false);
        this.selection = null;
        this.size = new Dimension();
        this.setSize(d, d2);
        this.setAttractionCharge(0.25);
        this.setAttractionMaximum(0.36787944117144233);
        this.setAttractionBreaking(2.0);
        this.setAvoidanceCoefficient(0.1);
        this.setAvoidanceSeparation(0.95);
        this.setAvoidanceEpsilon((byte)-64);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.getWidth(), dimension.getHeight());
    }

    public void setSize(double d, double d2) {
        this.size.setSize(d, d2);
    }

    public Dimension getSize() {
        return this.size;
    }

    public void update() {
        if (this.target != null) {
            for (Vehicle vehicle : this.vehicles) {
                if (vehicle.isSelected()) continue;
                Vector3d vector3d = this.getPotentialForce(vehicle);
                vehicle.applyForce(vector3d);
            }
        }
    }

    public void draw(Graphics2D graphics2D, DrawingContext drawingContext) {
        if (this.target != null) {
            this.target.draw(graphics2D, drawingContext);
        }
        for (TerrainObject terrainObject : this.obstacles) {
            terrainObject.draw(graphics2D, drawingContext);
        }
        for (Vehicle vehicle : this.vehicles) {
            vehicle.draw(graphics2D, drawingContext);
        }
    }

    private void wrapVehicle() {
    }

    private Vector3d getPotentialForce(Vehicle vehicle) {
        Vector3d vector3d = vehicle.getPosition();
        double d = this.computePotential(vehicle);
        vector3d.x += 1.0E-4f;
        double d2 = this.computePotential(vehicle);
        vector3d.x -= 1.0E-4f;
        vector3d.y += 1.0E-4f;
        double d3 = this.computePotential(vehicle);
        vector3d.y -= 1.0E-4f;
        Vector3d vector3d2 = new Vector3d((float)((d - d2) / (double)1.0E-4f), (float)((d - d3) / (double)1.0E-4f), 0.0f);
        return vector3d2;
    }

    private double computePotential(Vehicle vehicle) {
        double d = this.target.isActive() ? this.attraction.computePotential(vehicle, this.target) : 0.0;
        for (Vehicle terrainObject : this.vehicles) {
            if (terrainObject == vehicle) continue;
            d += this.repulsion.computePotential(vehicle, terrainObject);
        }
        for (TerrainObject terrainObject : this.obstacles) {
            d += this.repulsion.computePotential(vehicle, terrainObject);
        }
        return d;
    }

    public void select(Vector3d vector3d) {
        TerrainObject terrainObject;
        if (this.selection != null) {
            this.selection.setSelected(false);
            this.selection = null;
        }
        ListIterator<Vehicle> listIterator = this.vehicles.listIterator(this.vehicles.size());
        while (listIterator.hasPrevious()) {
            terrainObject = listIterator.previous();
            if (!terrainObject.contains(vector3d)) continue;
            this.selection = terrainObject;
            terrainObject.setSelected(true);
            break;
        }
        ListIterator<TerrainObject> listIterator2 = this.obstacles.listIterator(this.obstacles.size());
        while (listIterator2.hasPrevious()) {
            terrainObject = listIterator2.previous();
            if (!terrainObject.contains(vector3d)) continue;
            this.selection = terrainObject;
            terrainObject.setSelected(true);
            break;
        }
    }

    public void selectVehicle(Vector3d vector3d) {
        if (this.selection != null) {
            this.selection.setSelected(false);
            this.selection = null;
        }
        ListIterator<Vehicle> listIterator = this.vehicles.listIterator(this.vehicles.size());
        while (listIterator.hasPrevious()) {
            TerrainObject terrainObject = listIterator.previous();
            if (!terrainObject.contains(vector3d)) continue;
            this.selection = terrainObject;
            terrainObject.setSelected(true);
            break;
        }
    }

    public void selectObstacle(Vector3d vector3d) {
        if (this.selection != null) {
            this.selection.setSelected(false);
            this.selection = null;
        }
        ListIterator<TerrainObject> listIterator = this.obstacles.listIterator(this.obstacles.size());
        while (listIterator.hasPrevious()) {
            TerrainObject terrainObject = listIterator.previous();
            if (!terrainObject.contains(vector3d)) continue;
            this.selection = terrainObject;
            terrainObject.setSelected(true);
            break;
        }
    }

    public void deselect() {
        if (this.selection != null) {
            this.selection.setSelected(false);
        }
        this.selection = null;
    }

    public TerrainObject getSelection() {
        return this.selection;
    }

    public void addVehicle(Vector3d vector3d) {
        if (this.selection != null) {
            this.selection.setSelected(false);
        }
        Vehicle vehicle = new Vehicle();
        vehicle.position.set(vector3d);
        this.selection = vehicle;
        vehicle.setSelected(true);
        this.vehicles.add(vehicle);
    }

    public void deleteSelectedVehicle() {
        if (this.selection != null && this.selection instanceof Vehicle) {
            this.vehicles.remove(this.selection);
            this.selection = null;
        }
    }

    public void setSelectedVehiclePosition(Vector3d vector3d) {
        if (this.selection != null && this.selection instanceof Vehicle) {
            this.selection.getPosition().set(vector3d);
        }
    }

    public Vector3d getSelectedVehiclePosition() {
        if (this.selection != null && this.selection instanceof Vehicle) {
            return new Vector3d(this.selection.getPosition());
        }
        return null;
    }

    public void setSelectedVehicleRadius(float f) {
        if (this.selection != null && this.selection instanceof Vehicle) {
            this.selection.setRadius(f);
        }
    }

    public float getSelectedVehicleRadius() {
        if (this.selection != null && this.selection instanceof Vehicle) {
            return this.selection.getRadius();
        }
        return 0.5f;
    }

    public void setSelectedVehicleMass(float f) {
        if (this.selection != null && this.selection instanceof Vehicle) {
            ((Vehicle)this.selection).setMass(f);
        }
    }

    public float getSelectedVehicleMass() {
        if (this.selection != null && this.selection instanceof Vehicle) {
            return ((Vehicle)this.selection).getMass();
        }
        return 1.0f;
    }

    public void setSelectedVehicleCharge(double d) {
        if (this.selection != null && this.selection instanceof Vehicle) {
            this.selection.setCharge(d);
        }
    }

    public double getSelectedVehicleCharge() {
        if (this.selection != null && this.selection instanceof Vehicle) {
            return this.selection.getCharge();
        }
        return 0.25;
    }

    public void setSelectedVehicleDamping(float f) {
        if (this.selection != null && this.selection instanceof Vehicle) {
            ((Vehicle)this.selection).setDamping(f);
        }
    }

    public float getSelectedVehicleDamping() {
        if (this.selection != null && this.selection instanceof Vehicle) {
            return ((Vehicle)this.selection).getDamping();
        }
        return 0.75f;
    }

    public void setSelectedVehicleMaximumSpeed(float f) {
        if (this.selection != null && this.selection instanceof Vehicle) {
            ((Vehicle)this.selection).setMaximumSpeed(f);
        }
    }

    public float getSelectedVehicleMaximumSpeed() {
        if (this.selection != null && this.selection instanceof Vehicle) {
            return ((Vehicle)this.selection).getMaximumSpeed();
        }
        return 0.6f;
    }

    public void addObstacle(Vector3d vector3d) {
        if (this.selection != null) {
            this.selection.setSelected(false);
        }
        TerrainObject terrainObject = new TerrainObject();
        terrainObject.position.set(vector3d);
        this.selection = terrainObject;
        terrainObject.setSelected(true);
        this.obstacles.add(terrainObject);
    }

    public void deleteSelectedObstacle() {
        if (this.selection != null && !(this.selection instanceof Vehicle)) {
            this.obstacles.remove(this.selection);
            this.selection = null;
        }
    }

    public void setSelectedObstaclePosition(Vector3d vector3d) {
        if (this.selection != null && !(this.selection instanceof Vehicle)) {
            this.selection.getPosition().set(vector3d);
        }
    }

    public Vector3d getSelectedObstaclePosition() {
        if (this.selection != null && !(this.selection instanceof Vehicle)) {
            return new Vector3d(this.selection.getPosition());
        }
        return null;
    }

    public void setSelectedObstacleRadius(float f) {
        if (this.selection != null && !(this.selection instanceof Vehicle)) {
            this.selection.setRadius(f);
        }
    }

    public float getSelectedObstacleRadius() {
        if (this.selection != null && !(this.selection instanceof Vehicle)) {
            return this.selection.getRadius();
        }
        return 0.5f;
    }

    public void setSelectedObstacleCharge(double d) {
        if (this.selection != null && !(this.selection instanceof Vehicle)) {
            this.selection.setCharge(d);
        }
    }

    public double getSelectedObstacleCharge() {
        if (this.selection != null && !(this.selection instanceof Vehicle)) {
            return this.selection.getCharge();
        }
        return 0.25;
    }

    public void setAttractionCharge(double d) {
        this.target.setCharge(d);
    }

    public double getAttractionCharge() {
        return this.target.getCharge();
    }

    public void setAttractionMaximum(double d) {
        this.attraction.setMaximumForce(d);
    }

    public double getAttractionMaximum() {
        return this.attraction.getMaximumForce();
    }

    public void setAttractionBreaking(double d) {
        this.attraction.setBreakingDistance(d);
    }

    public double getAttractionBreaking() {
        return this.attraction.getBreakingDistance();
    }

    public void setAttractionPosition(Vector3d vector3d) {
        if (vector3d == null) {
            this.target.setActive(false);
        } else {
            this.target.getPosition().set(vector3d);
            this.target.setActive(true);
        }
    }

    public Vector3d getAttractionPosition() {
        return this.target.isActive() ? new Vector3d(this.target.getPosition()) : null;
    }

    public void setAvoidanceSeparation(double d) {
        this.repulsion.setSeparation(d);
    }

    public double getAvoidanceSeparation() {
        return this.repulsion.getSeparation();
    }

    public void setAvoidanceCoefficient(double d) {
        this.repulsion.setCoefficient(d);
    }

    public double getAvoidanceCoefficient() {
        return this.repulsion.getCoefficient();
    }

    public void setAvoidanceEpsilon(byte by) {
        double d = by;
        this.repulsion.setEpsilon(Math.pow(10.0, d));
    }

    public byte getAvoidanceEpsilon() {
        double d = this.repulsion.getEpsilon();
        return (byte)Math.log10(d);
    }
}

