/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.Color;
import java.awt.Graphics2D;
import potential.DrawingContext;
import potential.TerrainObject;
import potential.Vector3d;

public class Target
extends TerrainObject {
    public static final float COLOR_SHADE = 0.5f;
    public static final float COLOR_CHANGE = 0.1f;
    private float alpha = 1.0f;
    private boolean lighten = true;
    protected boolean active = true;

    public Target() {
        this(new Vector3d(0.0f, 0.0f, 0.0f), 0.5f);
    }

    public Target(Vector3d vector3d) {
        this(vector3d, 0.5f);
    }

    public Target(Vector3d vector3d, float f) {
        super(vector3d, f);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void draw(Graphics2D graphics2D, DrawingContext drawingContext) {
        if (!this.active) {
            return;
        }
        this.alpha = this.lighten ? this.alpha - 0.1f : this.alpha + 0.1f;
        drawingContext.fillCircle(graphics2D, this.position, this.radius, new Color(0.5f, 0.0f, 0.0f, this.alpha));
        if (this.alpha <= 0.0f) {
            this.lighten = false;
        } else if (this.alpha >= 1.0f) {
            this.lighten = true;
        }
    }
}

