/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.Container;
import java.awt.Font;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import potential.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabComponent
extends JPanel
implements Constants {
    public static final String COORDINATE_FORMAT = "%.2f";
    public static final int SLIDER_TICK_SIZE = 500;
    public static final int MAJOR_TICK_INCREMENT = 100;
    public static final int MINOR_TICK_INCREMENT = 20;
    public static final int FONT_SIZE = 9;

    public abstract void update();

    protected JSlider addSlider(String string, int n, Container container) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(string);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.0f);
        JSlider jSlider = new JSlider(0, 0, 500, n);
        jSlider.setMajorTickSpacing(100);
        jSlider.setMinorTickSpacing(20);
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(true);
        jSlider.setPaintTrack(true);
        jSlider.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(jSlider);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        container.add(jPanel);
        return jSlider;
    }

    protected JTextField addField(String string, int n, Container container) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.5f);
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        JTextField jTextField = new JTextField(n);
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
        container.add(jPanel);
        return jTextField;
    }

    protected JTextArea addArea(String string, int n, int n2, Container container) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.5f);
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JTextArea jTextArea = new JTextArea(n, n2);
        jLabel.setAlignmentX(0.0f);
        jTextArea.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(jTextArea);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        container.add(jPanel);
        return jTextArea;
    }

    protected Hashtable<Integer, JLabel> createLabels(float f, float f2) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 500; i += 100) {
            JLabel jLabel = new JLabel("" + this.tickToFloat(i, f, f2));
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
            hashtable.put(new Integer(i), jLabel);
        }
        return hashtable;
    }

    protected Hashtable<Integer, JLabel> createLabels(float f, float f2, String string, String string2) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 500; i += 100) {
            JLabel jLabel = new JLabel(string + this.tickToFloat(i, f, f2) + string2);
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
            hashtable.put(new Integer(i), jLabel);
        }
        return hashtable;
    }

    protected Hashtable<Integer, JLabel> createLabels(double d, double d2) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 500; i += 100) {
            JLabel jLabel = new JLabel("" + this.tickToDouble(i, d, d2));
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
            hashtable.put(new Integer(i), jLabel);
        }
        return hashtable;
    }

    protected Hashtable<Integer, JLabel> createLabels(double d, double d2, String string, String string2) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 500; i += 100) {
            JLabel jLabel = new JLabel(string + this.tickToDouble(i, d, d2) + string2);
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
            hashtable.put(new Integer(i), jLabel);
        }
        return hashtable;
    }

    protected Hashtable<Integer, JLabel> createLabels(long l, long l2) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 500; i += 100) {
            JLabel jLabel = new JLabel("" + this.tickToLong(i, l, l2));
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
            hashtable.put(new Integer(i), jLabel);
        }
        return hashtable;
    }

    protected Hashtable<Integer, JLabel> createLabels(long l, long l2, String string, String string2) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 500; i += 100) {
            JLabel jLabel = new JLabel(string + this.tickToLong(i, l, l2) + string2);
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
            hashtable.put(new Integer(i), jLabel);
        }
        return hashtable;
    }

    protected Hashtable<Integer, JLabel> createLabels(int n, int n2) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 500; i += 100) {
            JLabel jLabel = new JLabel("" + this.tickToInt(i, n, n2));
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
            hashtable.put(new Integer(i), jLabel);
        }
        return hashtable;
    }

    protected Hashtable<Integer, JLabel> createLabels(int n, int n2, String string, String string2) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 500; i += 100) {
            JLabel jLabel = new JLabel(string + this.tickToInt(i, n, n2) + string2);
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
            hashtable.put(new Integer(i), jLabel);
        }
        return hashtable;
    }

    protected Hashtable<Integer, JLabel> createLabels(byte by, byte by2) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 500; i += 100) {
            JLabel jLabel = new JLabel("" + this.tickToByte(i, by, by2));
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
            hashtable.put(new Integer(i), jLabel);
        }
        return hashtable;
    }

    protected Hashtable<Integer, JLabel> createLabels(byte by, byte by2, String string, String string2) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 500; i += 100) {
            JLabel jLabel = new JLabel(string + this.tickToByte(i, by, by2) + string2);
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), font.getStyle(), 9));
            hashtable.put(new Integer(i), jLabel);
        }
        return hashtable;
    }

    protected int floatToTick(float f, float f2, float f3) {
        return (int)((f - f2) * 500.0f / (f3 - f2));
    }

    protected int doubleToTick(double d, double d2, double d3) {
        return (int)((d - d2) * 500.0 / (d3 - d2));
    }

    protected int byteToTick(int n, byte by, byte by2) {
        return (n - by) * 500 / (by2 - by);
    }

    protected int intToTick(int n, int n2, int n3) {
        return (n - n2) * 500 / (n3 - n2);
    }

    protected int longToTick(long l, long l2, long l3) {
        return (int)((l - l2) * 500L / (l3 - l2));
    }

    protected float tickToFloat(int n, float f, float f2) {
        return (f2 - f) * (float)n / 500.0f + f;
    }

    protected double tickToDouble(int n, double d, double d2) {
        return (d2 - d) * (double)n / 500.0 + d;
    }

    protected long tickToLong(int n, long l, long l2) {
        return (l2 - l) * (long)n / 500L + l;
    }

    protected int tickToInt(int n, int n2, int n3) {
        return (n3 - n2) * n / 500 + n2;
    }

    protected byte tickToByte(int n, int n2, int n3) {
        return (byte)((n3 - n2) * n / 500 + n2);
    }
}

